;*******************************************************
;
; THE H8-500 TABLE CONTAINS THE INSTRUCTIONS USED BY THE
; HITACHI H8/500 MICROCOMPUTER, USING THE SYNTAX DEFINED
; IN THE H8/500 SERIES PROGRAMMING MANUAL.
;
	CPU	"H8-500.TBL"
	HOF	"MOT16"


; NOTE!  ACCESS TO WORD DATA IN MEMORY MUST ALWAYS
;        BEGIN AT AN EVEN ADDRESS.  TO INSURE THIS,
; USE THE ALIGN DIRECTIVE, BUT ONLY BEFORE DATA.
; I.E.
        ORG     0               ;Even
	ALGN	2		;Align code
TEXT1:  DFB     "ABC"
TEXT2:  DFB     "DEF"
        ALGN    1               ;Reset to 1

; NOTE!  FP (FRAME POINTER) AND SP (STACK POINTER)
;        MAY BE USED TO REPRESENT GENERAL REGISTERS
; R6 AND R7 RESPECTIVELY.  THE ONLY EXCEPTION IS
; THE LDM AND STM INSTRUCTIONS, WHERE ONLY R0 THROUGH
; R7 MAY BE USED.


; NOTE!  THE REGISTER LIST USED IN THE LDM AND STM
;        INSTRUCTIONS IS DIFFICULT TO SUPPORT WITH
; A META-ASSEMBLER.  THE USER MUST SPECIFY EACH
; REGISTER (R0 THROUGH R7 ONLY) INDIVIDUALLY.
; EXPRESSIONS SUCH AS R1-R4 MUST NOT BE USED.
; I.E.
	LDM	@SP+,(R7,R1,R2)
	STM	(R0,R1,R3,R2,R4,R5,R6),@-SP


; NOTE!  IN ASSEMBLY-LANGUAGE CODING IT IS USUALLY
;        NOT NECESSARY TO SPECIFY THE GENERAL OR
; SPECIAL FORMAT (BY CODING :G ETC.).  IF THE FORMAT
; SPECIFICATION IS OMITTED, THE ASSEMBLER AUTOMATICALLY
; GENERATES THE SHORTEST OBJECT CODE.  IF A FORMAT IS
; SPECIFIED, THE ASSEMBLER FOLLOWS THE FORMAT
; SPECIFICATION.
; I.E.

a08:	equ	12h
a16:	equ	1234h
a24:	equ	123456h
d08:	equ	12h
d16:	equ	1234h
x08:	equ	12h
x16:	equ	1234h

	ADD:G.B	R5,R6			;A526
	ADD:G.B	@R5,FP			;D526
	ADD:G.B	@(d08:8,R5),R6		;E51226
	ADD:G.B	@(d08,R5),R6		;E51226
	ADD:G.B	@(d16:16,R5),R6		;F5123426
	ADD:G.B	@(d16,R5),R6		;F5123426
	ADD:G.B	@-R5,R6			;B526
	ADD:G.B	@R5+,R6			;C526
	ADD:G.B	@a08:8,R6		;051226
	ADD:G.B	@a08,R6			;051226
	ADD:G.B	@a16:16,R6		;15123426
	ADD:G.B	@a16,R6			;15123426
	ADD:G.B	#x08:8,R6		;041226
	ADD:G.B	#x08,R6			;041226

	ADD:G.W	R5,R6			;AD26
	ADD:G.W	@R5,FP			;DD26
	ADD:G.W	@(d08:8,R5),R6		;ED1226
	ADD:G.W	@(d08,R5),R6		;ED1226
	ADD:G.W	@(d16:16,R5),R6		;FD123426
	ADD:G.W	@(d16,R5),R6		;FD123426
	ADD:G.W	@-R5,R6			;BD26
	ADD:G.W	@R5+,R6			;CD26
	ADD:G.W	@a08:8,R6		;0D1226
	ADD:G.W	@a08,R6			;0D1226
	ADD:G.W	@a16:16,R6		;1D123426
	ADD:G.W	@a16,R6			;1D123426
	ADD:G.W	#x16:16,R6		;0C123426
	ADD:G.W	#x16,R6			;0C123426

	ADD:Q.B	#2,R5			;A509
	ADD:Q.B	#2,@R5			;D509
	ADD:Q.B	#2,@(d08:8,R5)		;E51209
	ADD:Q.B	#2,@(d08,R5)		;E51209
	ADD:Q.B	#2,@(d16:16,R5)		;F5123409
	ADD:Q.B	#2,@(d16,R5)		;F5123409
	ADD:Q.B	#2,@-R5			;B509
	ADD:Q.B	#2,@R5+			;C509
	ADD:Q.B	#2,@a08:8		;051209
	ADD:Q.B	#2,@a08			;051209
	ADD:Q.B	#2,@a16:16		;15123409
	ADD:Q.B	#2,@a16			;15123409

	ADD:Q.W	#-2,R5			;AD0D
	ADD:Q.W	#-2,@R5			;DD0D
	ADD:Q.W	#-2,@(d08:8,R5)		;ED120D
	ADD:Q.W	#-2,@(d08,R5)		;ED120D
	ADD:Q.W	#-2,@(d16:16,R5)	;FD12340D
	ADD:Q.W	#-2,@(d16,R5)		;FD12340D
	ADD:Q.W	#-2,@-R5		;BD0D
	ADD:Q.W	#-2,@R5+		;CD0D
	ADD:Q.W	#-2,@a08:8		;0D120D
	ADD:Q.W	#-2,@a08		;0D120D
	ADD:Q.W	#-2,@a16:16		;1D12340D
	ADD:Q.W	#-2,@a16		;1D12340D

	ADD.B	R5,R6			;A526
	ADD.B	@R5,FP			;D526
	ADD.B	@(d08:8,R5),R6		;E51226
	ADD.B	@(d08,R5),R6		;E51226
	ADD.B	@(d16:16,R5),R6		;F5123426
	ADD.B	@(d16,R5),R6		;F5123426
	ADD.B	@-R5,R6			;B526
	ADD.B	@R5+,R6			;C526
	ADD.B	@a08:8,R6		;051226
	ADD.B	@a08,R6			;051226
	ADD.B	@a16:16,R6		;15123426
	ADD.B	@a16,R6			;15123426
	ADD.B	#x08:8,R6		;041226
	ADD.B	#x08,R6			;041226

	ADD.W	R5,R6			;AD26
	ADD.W	@R5,FP			;DD26
	ADD.W	@(d08:8,R5),R6		;ED1226
	ADD.W	@(d08,R5),R6		;ED1226
	ADD.W	@(d16:16,R5),R6		;FD123426
	ADD.W	@(d16,R5),R6		;FD123426
	ADD.W	@-R5,R6			;BD26
	ADD.W	@R5+,R6			;CD26
	ADD.W	@a08:8,R6		;0D1226
	ADD.W	@a08,R6			;0D1226
	ADD.W	@a16:16,R6		;1D123426
	ADD.W	@a16,R6			;1D123426
	ADD.W	#x16:16,R6		;0C123426
	ADD.W	#x16,R6			;0C123426

	ADD.B	#2,R5			;A509
	ADD.B	#2,@R5			;D509
	ADD.B	#2,@(d08:8,R5)		;E51209
	ADD.B	#2,@(d08,R5)		;E51209
	ADD.B	#2,@(d16:16,R5)		;F5123409
	ADD.B	#2,@(d16,R5)		;F5123409
	ADD.B	#2,@-R5			;B509
	ADD.B	#2,@R5+			;C509
	ADD.B	#2,@a08:8		;051209
	ADD.B	#2,@a08			;051209
	ADD.B	#2,@a16:16		;15123409
	ADD.B	#2,@a16			;15123409

	ADD.W	#-2,R5			;AD0D
	ADD.W	#-2,@R5			;DD0D
	ADD.W	#-2,@(d08:8,R5)		;ED120D
	ADD.W	#-2,@(d08,R5)		;ED120D
	ADD.W	#-2,@(d16:16,R5)	;FD12340D
	ADD.W	#-2,@(d16,R5)		;FD12340D
	ADD.W	#-2,@-R5		;BD0D
	ADD.W	#-2,@R5+		;CD0D
	ADD.W	#-2,@a08:8		;0D120D
	ADD.W	#-2,@a08		;0D120D
	ADD.W	#-2,@a16:16		;1D12340D
	ADD.W	#-2,@a16		;1D12340D

	ANDC.B	#x08:8,TP		;04125F
	ANDC.B	#x08,TP			;04125F
	ANDC.W	#x16:16,SR		;0C123458
	ANDC.W	#x16,SR			;0C123458

	BCC	$+42H			;2440
	BCS	$+42H			;2540
	BEQ	$+42H			;2740
	BF	$+42H			;2140
	BGE	$+42H			;2C40
	BEQ	$+0x1237		;371234
	BF	$+0x1237		;311234
	BGE	$+0x1237		;3C1234

	JSR	@R5			;11DD
	JSR	@(d08:8,R5)		;11ED12
	JSR	@(d08,R5)		;11ED12
	JSR	@(d16:16,R5)		;11FD1234
	JSR	@(d16,R5)		;11FD1234
	JSR	@a16:16			;181234
	JSR	@a16			;181234

	LDC.B	R5,TP			;A58F
	LDC.B	@R5,TP			;D58F
	LDC.B	@(d08:8,R5),TP		;E5128F
	LDC.B	@(d08,R5),TP		;E5128F
	LDC.B	@(d16:16,R5),TP		;F512348F
	LDC.B	@(d16,R5),TP		;F512348F
	LDC.B	@-R5,TP			;B58F
	LDC.B	@R5+,TP			;C58F
	LDC.B	@a08:8,TP		;05128F
	LDC.B	@a08,TP			;05128F
	LDC.B	@a16:16,TP		;1512348F
	LDC.B	@a16,TP			;1512348F
	LDC.B	#x08:8,TP		;04128F
	LDC.B	#x08,TP			;04128F

	LDC.W	R5,SR			;AD88
	LDC.W	@R5,SR			;DD88
	LDC.W	@(d08:8,R5),SR		;ED1288
	LDC.W	@(d08,R5),SR		;ED1288
	LDC.W	@(d16:16,R5),SR		;FD123488
	LDC.W	@(d16,R5),SR		;FD123488
	LDC.W	@-R5,SR			;BD88
	LDC.W	@R5+,SR			;CD88
	LDC.W	@a08:8,SR		;0D1288
	LDC.W	@a08,SR			;0D1288
	LDC.W	@a16:16,SR		;1D123488
	LDC.W	@a16,SR			;1D123488
	LDC.W	#x16:16,SR		;0C123488
	LDC.W	#x16,SR			;0C123488

	LINK	FP,#d08			;1712
	LINK	FP,#d08:8		;1712
	LINK	R6,#d08			;1712
	LINK	R6,#d08:8		;1712
	LINK	FP,#d16			;1F1234
	LINK	FP,#d16:16		;1F1234
	LINK	R6,#d16			;1F1234
	LINK	R6,#d16:16		;1F1234

	RTS				;19

	SCB/F	R0,$+$43		;01B840
	SCB/NE	R1,$+$43		;06B940
	SCB/EQ	R7,$+$43		;07BF40

	XOR.B	R5,R6			;A566
	XOR.B	@R5,FP			;D566
	XOR.B	@(d08:8,R5),R6		;E51266
	XOR.B	@(d08,R5),R6		;E51266
	XOR.B	@(d16:16,R5),R6		;F5123466
	XOR.B	@(d16,R5),R6		;F5123466
	XOR.B	@-R5,R6			;B566
	XOR.B	@R5+,R6			;C566
	XOR.B	@a08:8,R6		;051266
	XOR.B	@a08,R6			;051266
	XOR.B	@a16:16,R6		;15123466
	XOR.B	@a16,R6			;15123466
	XOR.B	#x08:8,R6		;041266
	XOR.B	#x08,R6			;041266

	XOR.W	R5,R6			;AD66
	XOR.W	@R5,FP			;DD66
	XOR.W	@(d08:8,R5),R6		;ED1266
	XOR.W	@(d08,R5),R6		;ED1266
	XOR.W	@(d16:16,R5),R6		;FD123466
	XOR.W	@(d16,R5),R6		;FD123466
	XOR.W	@-R5,R6			;BD66
	XOR.W	@R5+,R6			;CD66
	XOR.W	@a08:8,R6		;0D1266
	XOR.W	@a08,R6			;0D1266
	XOR.W	@a16:16,R6		;1D123466
	XOR.W	@a16,R6			;1D123466
	XOR.W	#x16:16,R6		;0C123466
	XOR.W	#x16,R6			;0C123466

	XORC.B	#x08:8,TP		;04126F
	XORC.B	#x08,TP			;04126F
	XORC.W	#x16:16,SR		;0C123468
	XORC.W	#x16,SR			;0C123468
ZZZ:
	END
