;*******************************************************
;
; THE H8-300 TABLE CONTAINS THE INSTRUCTIONS USED BY THE
; HITACHI H8/300 MICROCOMPUTER, USING THE SYNTAX DEFINED
; IN THE H8/300 SERIES PROGRAMMING MANUAL.
;
	CPU	"H8-300.TBL"
	HOF	"MOT8"
	ORG	1000H


; NOTE!  ACCESS TO WORD DATA IN MEMORY MUST ALWAYS
;	 BEGIN AT AN EVEN ADDRESS.  TO INSURE THIS,
; USE THE ALIGN DIRECTIVE.
; I.E.
	ALGN	2		;Align code


; NOTE!  SP, SPH AND SPL (STACK POINTER)
;	 MAY BE USED TO REPRESENT REGISTERS
; R7, R7H AND R7L RESPECTIVELY.


; NOTE!  IN ASSEMBLY-LANGUAGE CODING IT IS USUALLY
;	 NOT NECESSARY TO SPECIFY THE GENERAL OR
; SPECIAL FORMAT (BY CODING :8, .B ETC.).  IF THE FORMAT
; SPECIFICATION IS OMITTED, THE ASSEMBLER AUTOMATICALLY
; GENERATES THE SHORTEST OBJECT CODE.  IF A FORMAT IS
; SPECIFIED, THE ASSEMBLER FOLLOWS THE FORMAT
; SPECIFICATION.
; I.E.

ppaa:	equ	0ff67h
xx:	equ	12h
xxaa:	equ	1267h

	ADD.B	#XX,R5H
	ADD.B	#XX,SPL
	ADD.B	#XX:8,R5H
	ADD.B	#XX:8,R5L
	ADD.B	R0H,R0H
	ADD.B	R5H,R6L
	ADD.B	SPH,SPL

	ADD.W	R0,R0
	ADD.W	R6,R3
	ADD.W	SP,SP

	ADD	#XX,R5H
	ADD	#XX,SPL
	ADD	#XX:8,R5H
	ADD	#XX:8,R5L
	ADD	R0H,R0H
	ADD	R5H,R6L
	ADD	SPH,SPL

	ADD	R0,R0
	ADD	R6,R3
	ADD	SP,SP

	ADDS	#1,R0
	ADDS	#1,R5
	ADDS	#2,R0
	ADDS	#2,SP

	BCLR	#2,R0H
	BCLR	#0:3,R0L
	BCLR	#6,R2H
	BCLR	#1,R7L
	BCLR	#0,@R1
	BCLR	#0,@R2
	BCLR	#1,@R2
	BCLR	#2,@R0
	BCLR	#2,@R1
	BCLR	#3,@R0
	BCLR	#5:3,@R7
	BCLR	#6,@R7
	BCLR	#7,@R7
	BCLR	#0,@PPAA:8
	BCLR	#4,@PPAA
	BCLR	#4:3,@PPAA
	BCLR	#7:3,@PPAA:8

	BCLR	R0H,R0H
	BCLR	R2L,R5L
	BCLR	R7L,R7L
	BCLR	R0H,@R1
	BCLR	R0H,@R2
	BCLR	R0H,@R3
	BCLR	R0H,@R5
	BCLR	R0H,@R6
	BCLR	R1H,@R3
	BCLR	R1H,@R5
	BCLR	R7L,@R5
	BCLR	R7L,@R6
	BCLR	R7L,@R7
	BCLR	R0H,@PPAA:8
	BCLR	R4L,@PPAA:8
	BCLR	R5L,@PPAA
	BCLR	R7L,@PPAA:8

	BSR	$ + 36H

	JMP	@R0
	JMP	@R1
	JMP	@R2
	JMP	@R4
	JMP	@R7
	JMP	@XXAA
	JMP	@XXAA:16
	JMP	@@67H
	JMP	@@67H:8

	LDC	#xx:8,CCR
	LDC	#xx,CCR
	LDC	R0H,CCR
	LDC	R1H,CCR
	LDC	R7L,CCR

	MOV.B	R0H,R0H
	MOV.B	R0H,R1H

	MOV.W	R0,R0
	MOV.W	R0,R1
	MOV.W	#XXAA,R5
	MOV.W	#XXAA,R6
	MOV.W	#XXAA:16,R0
	MOV.W	@R0,R0
	MOV.W	@R0,R1
	MOV.W	@(XXAA,R0),R1
	MOV.W	@(XXAA:16,R0),R0
	MOV.W	@R0+,R1
	MOV.W	@R0+,R2
	MOV.W	@XXAA:16,R0
	MOV.W	@XXAA:16,R6
	MOV.W	R0,@R4
	MOV.W	R1,@R7
	MOV.W	R7,@R7
	MOV.W	R5,@(XXAA,R4)
	MOV.W	R0,@(XXAA,R7)
	MOV.W	R6,@(XXAA:16,R7)
	MOV.W	R7,@(XXAA:16,R7)
	MOV.W	R0,@-R0
	MOV.W	R6,@-R7
	MOV.W	R5,@XXAA:16
	MOV.W	R6,@XXAA
	MOV.W	R6,@XXAA:16

	MOVFPE	@XXAA,R2L
	MOVFPE	@XXAA:16,R0H
	MOVFPE	@XXAA:16,R6L

	MOVTPE	R5L,@XXAA:16
	MOVTPE	R6H,@XXAA
	MOVTPE	R6L,@XXAA:16
	MOVTPE	R7L,@XXAA:16

	NOP

	ROTXL	R1H
	ROTXL	R2H
	ROTXL	R5L
	ROTXL	R6L
	ROTXL	R7L

	SLEEP

	STC	CCR,R0H
	STC	CCR,R0L
	STC	CCR,R6L
	STC	CCR,R7H
	STC	CCR,R7L

	XOR	#XX:8,R0H
	XOR	#XX,R7L
	XOR	R0H,R0H
	XOR	R2H,R6H
	XOR	R7L,SPL

	XORC	#xx:8,CCR
	XORC	#xx,CCR
ZZZ:
	END
