;***********************************************************
; THE COP800 TABLE CONTAINS ALL THE INSTRUCTIONS USED BY
; THE COP420C/COP840C MICROCONTROLLERS.  THE TABLE MAY BE
; TAILORED FOR ANY ONE MICROCONTROLLER IN PARTICULAR.
;
; The assembler with the supplied COP800 table, does not
; implicitly recognize register, RAM or I/O location
; labels.  These should be defined at the
; beginning of the source file, using their real
; address values, as shown in the following example.
;
X:       EQU    0FCH
SP:      EQU    0FDH
B:       EQU    0FEH

; THIS IS AN EXAMPLE PROGRAM FOR THE COP840C PROCESSOR.
; IT IS TAKEN FROM PAGE D-2 OF THE COP820C/COP840C USER'S
; MANUAL (DRAFT), AND AFTER ONLY FORMAT MODIFICATIONS,
; IT IS PASSED ON AS AN EXAMPLE, FREE OF CHARGE,
; BY UNIVERSAL CROSS-ASSEMBLERS.
;
         HOF    "INT8"        ; HEX OUTPUT FORMAT

;***********************************************************
;
; COP840 TEST PROGRAM     12/12/86     VERNE.H.WILSON
;
; PROGRAM NAME: TEST840.MAC
;
         TITL   "TEST840"
;
;
;
PORTLD:  EQU    0D0H          ; PORT L DATA
PORTLC:  EQU    0D1H          ; PORT L CONFIGURATION
PORTLP:  EQU    0D2H          ; PORT L PIN
;
PORTGD:  EQU    0D4H          ; PORT G DATA
PORTGC:  EQU    0D5H          ; PORT G CONFIGURATION
PORTGP:  EQU    0D6H          ; PORT G PIN
PORTD:   EQU    0DCH          ; PORT D
PORTI:   EQU    0D7H          ; PORT I
;
SIOR:    EQU    0E9H          ; SIO SHIFT REGISTER
TMRLO:   EQU    0EAH          ; TIMER LOW BYTE
TMRHI:   EQU    0EBH          ; TIMER HIGH BYTE
TAULO:   EQU    0ECH          ; TIMER REGISTER LOW BYTE
TAUHI:   EQU    0EDH          ; TIMER REGISTER HIGH BYTE
;
CNTRL:   EQU    0EEH          ; CONTROL REGISTER
PSW:     EQU    0EFH          ; PSW REGISTER
;
; CONSTANT DECLARE
;
INTR:    EQU    0
TIO:     EQU    3
SO:      EQU    4
SK:      EQU    5
SI:      EQU    6
CKO:     EQU    7
;
TSEL:    EQU    7
CSEL:    EQU    6
TEDG:    EQU    5
TRUN:    EQU    4
MSEL:    EQU    3
IEDG:    EQU    2
S1:      EQU    1
S0:      EQU    0
;
HCARRY:  EQU    7
CARRY:   EQU    6
TPND:    EQU    5
ENTI:    EQU    4
IPND:    EQU    3
BUSY:    EQU    2
ENI:     EQU    1
GIE:     EQU    0
TMRINP:  EQU    3
;
;
; REGISTER ASSIGNMENTS
;
CNT:     EQU    0F3H
BS:      EQU    0F4H
BD:      EQU    0F5H
BCD:     EQU    0F6H
TEMP:    EQU    0F7H
ERC:     EQU    0FAH
;
;
;
         CPU    "COP800.TBL"  ; PROCESSOR TABLE
;
         LD     SP,#06FH      ; DEFAULT INITIALIZATION
                              ;    OF SP STACK POINTER
                              ;    FOR INTERRUPTS AND
                              ;    SUBROUTINES
;
         LD     PORTD,#0
         LD     A,PORTI
         AND    A,#0FH        ; TEST PORT I FOR
         IFEQ   A,#0FH        ;    INPUTS ALL HIGH
         JP     START         ; GO TO OP CODE TEST
         RRC    A
         IFC                  ;TEST I-PORT BIT 0
         JMP    MAINP
         JMP    DTST          ;DTST IF BIT0 = 0
;
;
START:   LD     ERC,#0        ; INITIALIZE ERROR
                              ;    REFERENCE COUNTER
;
;
; SECTION 1 - LOAD MEMORY LOCATIONS WITH ADDRESSES
;    THIS SECTION UTILIZES ALL VARIATIONS OF
;    THE LOAD(LD) AND EXCHANGE(X) INSTRUCTIONS,
;    INCLUDING ALL ADDRESSING MODES.
;    MEMORY LOCATIONS 010H-01FH ARE LOADED WITH
;    THEIR RESPECTIVE ADDRESSES.
;
         LD     010H,#010H
         LD     011H,#011H
         LD     B,#012H
         LD     A,B
         X      A,[B]
         LD     A,[B+]
         INC    A
         X      A,[B+]
         LD     [B+],#014H
         LD     [B],#015H
         LD     A,#00AH
         ADD    A,B
         LD     B,#01FH
         X      A,[B]
         LD     A,[B-]
         DEC    A
         X      A,[B]
         LD     A,[B]
         DEC    A
         X      A,B
         LD     A,B
         X      A,[B-]
         LD     [B-],#01CH
         LD     [B-],#01BH
         LD     X,#01AH
         LD     A,X
         X      A,[X]
         LD     A,[X-]
         DEC    A
         X      A,[X-]
         LD     A,#002H
         X      A,X
         SC
         SUBC   A,X
         RC
         X      A,X
         LD     A,X
         X      A,[X]
         LD     A,[X+]
         INC    A
         X      A,[X+]
         LD     A,#018H
         X      A,[X+]
         LD     A,[X]
         IFEQ   A,#019H       ; RESULT=019H ?
         SC
         DRSZ   ERC
         IFNC
         JMP    ER1

ER1:     EQU    00E0H         ; REMAINING LABELS
MAINP:   EQU    04DBH
DTST:    EQU    0512H

         END
