;***********************************************************
;
; THIS IS AN EXAMPLE PROGRAM FOR THE COP420C PROCESSOR.
; IT IS TAKEN FROM PAGE 9-122 OF THE 1982 COPS MICROCONTROL-
; LERS DATABOOK, AND AFTER ONLY FORMAT MODIFICATIONS,
; IT IS PASSED ON AS AN EXAMPLE, FREE OF CHARGE,
; BY UNIVERSAL CROSS-ASSEMBLERS.

; THE COP400 TABLE CONTAINS THE INSTRUCTIONS USED BY THE
; COP420C/COP421C AND COP320C/COP321C SERIES OF
; MICROCONTROLLERS.  THE TABLE MAY OF COURSE BE TAILORED
; FOR ANY ONE MICROCONTROLLER IN PARTICULAR.

         CPU     "COP400.TBL"   ; CPU TABLE
         HOF     "INT8"         ; HEX OUTPUT FORMAT

;***********************************************************
;
; TITLE REPEX
; EXAMPLE ROUTINE TO WRITE THE DIGIT IN REGISTER 0, 0
; INTO THE FIRST ADDRESS SPACE IN STORE BLOCK 1.
; TELEPHONE NUMBERS OF 20 DIGITS ARE CHOSEN TO
; DEMONSTRATE THE USE OF A LOOK-UP TABLE TO GENERATE
; THE START ADDRESS.  THUS, BLOCK 1 START ADDRESS IS
; HEX 15, WHICH WILL BE STORED IN A LOOK-UP TABLE
; BEGINNING IN ROM LOCATION 0F1 (MUST BE IN SAME 4
; PAGE SEGMENT OF ROM).


WRITE:   CLRA
         OGI     0
         LBI     2, 15    ;POINT OF BLOCK NO. IN RAM (B)
         AISC    15       ;LOAD F INTO ACCUMULATOR
         LQID             ;CONTENTS OF F1 PUT IN Q
         LBI     2, 14    ;WANT ADDRESS COPIED IN RAM (B)
         CQMA             ;ADDRESS UPPER NIBBLE IN 2, 14
         LBI     2, 13
         X       0        ;ADDRESS LOWER NIBBLE IN 2, 13
         LEI     4        ;ADDRESS OUT TO 74C921
         OGI     7        ;ST, WE, CEL GO LO
         LDD     2, 0     ;PUTS FIRST DIGIT IN ACC
         CAMQ             ;DIGIT OUT TO 74C921 DATA PORT
         OGI     0        ;DATA STROBED IN
         LEI     0        ;TRI STATE L
         ORG     0F1H
         DFB     15H
         END
