;***********************************************************
;
; NOTE!!!
;   THE 8096 TABLE INCLUDES EXTRA INSTRUCTIONS FOR THE
; 80C196KA/KB, 80C196KC AND 80C196NT PROCESSORS.  THESE
; ARE CLEARLY MARKED AT THE END OF THE TABLE, AND MAY
; BE REMOVED IF NOT REQUIRED.

; BELOW IS AN EXAMPLE ROUTINE FOR THE 8096 MICRO-
; CONTROLLER FAMILY.  IT IS TAKEN FROM THE 1985
; INTEL MICROCONTROLLER HANDBOOK ON PAGE 3-20.
; AFTER ONLY FORMAT MODIFICATIONS,
; IT IS PASSED ON AS AN EXAMPLE, FREE OF CHARGE,
; BY UNIVERSAL CROSS-ASSEMBLERS.

	CPU	"8096.TBL"	; CPU TABLE
	HOF	"INT8"		; HEX FORMAT

; WHEN COMPARING THE LISTING PRODUCED BY THE ASSEMBLER
; TO THAT IN THE INTEL MICROCONTROLLER HANDBOOK, REMEMBER
; THAT THE ASSEMBLER DOES NOT PRODUCE RELOCATABLE OBJECT
; FILES, AND THEREFORE THE HEX CODE WILL BE DIFFERENT
; (USUALLY SHORTER AND FASTER WITH THE VALUES OF ALL
; THE LABELS FILLED IN).

; ALSO INCLUDED, IS A LIST OF THE 8096 REGISTER  NAMES
; WITH THEIR CORRESPONDING ADDRESSES.  THESE SHOULD BE
; COPIED INTO YOUR SOURCE FILE.

;***********************************************************

; MCS-96 INTERNAL REGISTERS

R0:		EQU	00H	;ZERO REGISTER
AD_RESULT:	EQU	02H	;A/D RESULT
AD_COMMAND:	EQU	02H	;A/D COMMAND REGISTER
HSI_MODE:	EQU	03H	;HIGH SPEED INPUT MODE
HSI_TIME:	EQU	04H	;HIGH SPEED TRIGGER TIME
HSO_COMMAND:	EQU	06H	;HSO COMMAND REGISTER
HSI_STATUS:	EQU	06H	;HSI STATUS REGISTERS
SBUF:		EQU	07H	;SERIAL BUFFER
INT_MASK:	EQU	08H	;INTERRUPT MASK
INT_PENDING:	EQU	09H	;INTERRUPT PENDING REGISTER
WATCHDOG:	EQU	0AH	;WATCHDOG TIMER REGISTER
TIMER1: 	EQU	0AH	;TIMER 1
TIMER2: 	EQU	0CH	;TIMER2
IOPORT0:	EQU	0EH	;PORT 0 REGISTER
BAUD_RATE:	EQU	0EH	;BAUD RATE REGISTER
IOPORT1:	EQU	0FH	;PORT 1 REGISTER
IOPORT2:	EQU	10H	;PORT 2 REGISTER
SP_STAT:	EQU	11H	;SERIAL PORT STATUS
SP_CON: 	EQU	11H	;SERIAL PORT CONTROL
IOS0:		EQU	15H	;I/O STATUS REGISTER 0
IOS1:		EQU	16H	;I/O STATUS REGISTER 1
IOC0:		EQU	15H	;I/O CONTROL REGISTER 0
IOC1:		EQU	16H	;I/O CONTROL REGISTER 1
PWM_CONTROL:	EQU	17H	;PWM CONTROL REGISTER

;***********************************************************
;
; SCANNING THE A TO D CHANNELS

; This program scans the A to D lines 0 through 3 and stores
; the result in RES_N

AD_RES_LO:	equ	02
AD_RES_HI:	equ	03
AD_COMMAND:	equ	02
SP:		equ	18H

; Data Segment
RES_TABLE:	ORG	0
RES_1:		dfs	2
RES_2:		dfs	2
RES_3:		dfs	2
RES_4:		dfs	2

; Register Segment
	ORG	0
AX:	dfs	2
AL:	equ	AX	;byte
AH:	equ	AX+1	;byte

BX:	dfs	2
BL:	equ	BX	;byte
BU:	equ	BX+1	;byte

; Note that 'BH' is an opcode so it
; can't be used as a label.

DX:	dfs	2
DL:	equ	DX	;byte
DH:	equ	DX+1	;byte


; Code Segment

	ORG	0000H

start:	LD	SP, #0C0H	;Set Stack Pointer
	LD	BX, 00H 	;Use the zero register

next:	ORB	BL, #1000B	;Start conversion on channel
	LDB	AD_COMMAND,BL	;indicated by BL register
	ANDB	BL, #0111B

	NOP			;Wait for conversion to start

check:	JBS AD_RES_LO, 3, check
				;Wait while A to D is busy

	LDB	AL, AD_RES_LO	;Load low order result
	LDB	AH, AD_RES_HI	;Load high order result

	ADDB	DL, BL, BL	;DL=BL*2
	LDBZE	DX, DL
	ST	AX, RES_TABLE[DX] ;Store result indexed by BL*2

	INCB	BL
	ANDB	BL, #03H

	SJMP	next

	END

