;******************************************************
; THERE ARE NUMEROUS VERY POWERFUL MACRO-ASSEMBLERS
; AVAILABLE FOR THE 8086 FAMILY, BUT IN THE NAME OF 
; COMPLETENESS, A TABLE FOR THE 8086 - 80C88
; FAMILY IS INCLUDED.
;
; THE TABLE SUPPORTS AN 8086 INSTRUCTION FORMAT THAT
; IS COMPATIBLE WITH THE MICROSOFT MACRO ASSEMBLER 5.1
; FURTHER NOTES ON THE 8086 TABLE FOLLOW THE EXAMPLE.

;******************************************************
; IF THE HEX OUTPUT IS WRITTEN TO A .COM FILE,
; I.E. CLEAR.COM, THIS ROUTINE WILL CLEAR THE
; SCREEN OF A x86 MS-DOS COMPUTER.
;
	   CPU	   "8086.TBL"	   ; CPU TABLE
	   HOF	   "BIN16"	   ; HEX OUTPUT FORMAT
;
BEGIN:	   org	   0100H
;
; CLEAR SCREEN ROUTINE
cls_near:  mov	   cx,0
	   mov	   dx,2479h
	   mov	   bh,7
	   mov	   ax,600h
	   int	   10h
	   ret
;
;
;******************************************************
;
; NOTE!  THE 8086 TABLE DOES NOT SUPPORT SEGMENT  
;	 OVERRIDES WITHIN THE INSTRUCTION.  SEGMENT 
; OVERRIDES MUST BE PLACED ON THE PREVIOUS LINE IN
; THE FOLLOWING FORMAT:
;
;	SEG	segreg
;
; I.E.
	SEG	DS
	SEG	CS
	SEG	ES
	SEG	SS

;******************************************************
;
; NOTE!  BEING AND ABSOLUTE ASSEMBLER, CROSS-32 DOES
;	 NOT MOVE CODE SEGMENTS AROUND.  IT ASSUMES
; THAT CS=DS=ES=SS=0.  USERS MAY CERTAINLY ASSIGN 
; SEGMENT REGISTERS OTHER VALUES, AND USE THEM IN
; THEIR CODE.
;
; I.E.
DATA:	DFB	"ABCDEFGHIJKLMNOPQRSTUVWXYZ",0
;
CODE:	MOV	AX,DATA
	MOV	DS,AX		;LOAD DATA SEGMENT
	MOV	DI,4		;LOAD DATA INDEX
;
	MOV	AL,[DI+1]	;PUT "F" IN AL
	RET

;******************************************************
;
; NOTE!  THE CALL, JMP AND RET INSTRUCTIONS DEFAULT
;	 TO NEAR POINTERS.  FAR POINTERS MUST BE
; SPECIFIED USING FAR PTR OR DWORD PTR.  AN ADDITIONAL
; FAR POINTER FORMAT IS SUPPORTED WHERE THE USER CAN
; SPECIFY THE EXACT INTRUCTION POINTER AND 
; CODE SEGMENT ***
; I.E.

	CALL	BEGIN
	CALL	NEAR PTR BEGIN
	CALL	FAR PTR BEGIN
	CALL	FAR PTR $FFFFF
	CALL	FAR PTR 1234H,5678H	;CALL IP,CS ***
	JMP	FAR PTR 1234H,5678H	;CALL IP,CS ***

;CALL_WORD_PTR_mod_00_disp0_r/m
	CALL	[BX+SI]
	CALL	[BX+DI]
	CALL	[BP+SI]
	CALL	[BP+DI]
	CALL	[SI]
	CALL	[DI]
	CALL	[DRWRD]
	CALL	[BX]
;CALL_WORD_PTR_mod_01_disp8_r/m
	CALL	[BX+SI	+1] 
	CALL	[BX+DI	+5] 
	CALL	[BP+SI +55] 
	CALL	[BP+DI+127] 
	CALL	[SI   -128] 
	CALL	[DI    -40] 
	CALL	[BP	-8] 
	CALL	[BX	-1] 
;CALL_WORD_PTR_mod_10_disp16_r/m
	CALL	[BX+SI	+128]
	CALL	[BX+DI +1234]
	CALL	[BP+SI+32767]
	CALL	[BP+DI+60000]
	CALL	[SI   -32768]
	CALL	[DI    -1234]
	CALL	[BP    -2345]
	CALL	[BX	-129]
;CALL	reg16
	CALL	AX
	CALL	CX
	CALL	DX
	CALL	BX
	CALL	SP
	CALL	BP
	CALL	SI
	CALL	DI
;CALL_WORD_PTR_mod_00_disp0_r/m
	CALL	WORD PTR[BX+SI]
	CALL	WORD PTR[BX+DI]
	CALL	WORD PTR[BP+SI]
	CALL	WORD PTR[BP+DI]
	CALL	WORD PTR[SI]
	CALL	WORD PTR[DI]
	CALL	WORD PTR[DRWRD]
	CALL	WORD PTR[BX]
;CALL_WORD_PTR_mod_01_disp8_r/m
	CALL	WORD PTR[BX+SI	+1] 
	CALL	WORD PTR[BX+DI	+5] 
	CALL	WORD PTR[BP+SI +55] 
	CALL	WORD PTR[BP+DI+127] 
	CALL	WORD PTR[SI   -128] 
	CALL	WORD PTR[DI    -40] 
	CALL	WORD PTR[BP	-8] 
	CALL	WORD PTR[BX	-1] 
;CALL_WORD_PTR_mod_10_disp16_r/m
	CALL	WORD PTR[BX+SI	+128]
	CALL	WORD PTR[BX+DI +1234]
	CALL	WORD PTR[BP+SI+32767]
	CALL	WORD PTR[BP+DI+60000]
	CALL	WORD PTR[SI   -32768]
	CALL	WORD PTR[DI    -1234]
	CALL	WORD PTR[BP    -2345]
	CALL	WORD PTR[BX	-129]
;CALL_DWORD_PTR_mod_00_disp0_r/m
	CALL	DWORD PTR[BX+SI]
	CALL	DWORD PTR[BX+DI]
	CALL	DWORD PTR[BP+SI]
	CALL	DWORD PTR[BP+DI]
	CALL	DWORD PTR[SI]
	CALL	DWORD PTR[DI]
	CALL	DWORD PTR[DRWRD]
	CALL	DWORD PTR[BX]
;CALL_DWORD_PTR_mod_01_disp8_r/m
	CALL	DWORD PTR[BX+SI  +1]
	CALL	DWORD PTR[BX+DI  +5]
	CALL	DWORD PTR[BP+SI +55]
	CALL	DWORD PTR[BP+DI+127]
	CALL	DWORD PTR[SI   -128]
	CALL	DWORD PTR[DI	-40]
	CALL	DWORD PTR[BP	 -8]
	CALL	DWORD PTR[BX	 -1]
;CALL_DWORD_PTR_mod_10_disp16_r/m
	CALL	DWORD PTR[BX+SI  +128]
	CALL	DWORD PTR[BX+DI +1234]
	CALL	DWORD PTR[BP+SI+32767]
	CALL	DWORD PTR[BP+DI+60000]
	CALL	DWORD PTR[SI   -32768]
	CALL	DWORD PTR[DI	-1234]
	CALL	DWORD PTR[BP	-2345]
	CALL	DWORD PTR[BX	 -129]

	RET
	RET	2
	RET	65535
	RETN
	RETN	2
	RETN	65535
	RETF
	RETF	2
	RETF	65535

;******************************************************
;	
; NOTE!  ALL MEMORY OPERANDS AND THEIR DISPLACEMENTS
;	 MUST BE PLACED WITHIN BRACKETS [].  ALL
; INSTRUCTIONS WHOSE SIZE (BYTE, WORD OR DWORD) CAN
; NOT BE DETERMINED BY REGISTER SIZE OR INSTRUCTION
; TYPE, MUST BE EXPLICITLY STATED.
;
;
	MOV	BH,[BX+SI]
	MOV	DH,[BX+DI]
	MOV	CH,[BP+SI]
	MOV	AH,[BP+DI]
	MOV	BL,[SI]
	MOV	DL,[DI]
	MOV	CL,[DRBYT]
	MOV	AL,[BX]
;MOV	mod 00	[r/m],r8
	MOV	[BX+SI],BH
	MOV	[BX+DI],DH
	MOV	[BP+SI],CH
	MOV	[BP+DI],AH
	MOV	[SI],BL
	MOV	[DI],DL
	MOV	[DRBYT],CL
	MOV	[BX],AL
;MOV	mod 01	r8,[r/m+d8]
	MOV	BH,[BX+SI  +1]
	MOV	DH,[BX+DI  +5]
	MOV	CH,[BP+SI +55]
	MOV	AH,[BP+DI+127]
	MOV	BL,[SI	 -128]
	MOV	DL,[DI	  -40]
	MOV	CL,[BP	   -8]
	MOV	AL,[BX	   -1]
;MOV	mod 01	[r/m+d8],r8
	MOV	[BX+SI	+1],BH
	MOV	[BX+DI	+5],DH
	MOV	[BP+SI +55],CH
	MOV	[BP+DI+127],AH
	MOV	[SI   -128],BL
	MOV	[DI    -40],DL
	MOV	[BP	-8],CL
	MOV	[BX	-1],AL
;MOV	mod 10	r8,[r/m+d16]
	MOV	BH,[BX+SI  +128]
	MOV	DH,[BX+DI +1234]
	MOV	CH,[BP+SI+32767]
	MOV	AH,[BP+DI+60000]
	MOV	BL,[SI	 -32768]
	MOV	DL,[DI	  -1234]
	MOV	CL,[BP	  -2345]
	MOV	AL,[BX	   -129]
;MOV	mod 10	[r/m+d16],r8
	MOV	[BX+SI	+128],BH
	MOV	[BX+DI +1234],DH
	MOV	[BP+SI+32767],CH
	MOV	[BP+DI+60000],AH
	MOV	[SI   -32768],BL
	MOV	[DI    -1234],DL
	MOV	[BP    -2345],CL
	MOV	[BX	-129],AL
;MOV	mod 11	r8,r8		       
	MOV	AL,BH
	MOV	CL,DH
	MOV	DL,CH
	MOV	BL,AH
	MOV	AH,BL
	MOV	CH,DL
	MOV	DH,CL
	MOV	BH,AL
;MOV	mod 00	r16,[r/m]
	MOV	DI,[BX+SI]
	MOV	SI,[BX+DI]
	MOV	BP,[BP+SI]
	MOV	SP,[BP+DI]
	MOV	BX,[SI]
	MOV	DX,[DI]
	MOV	CX,[DRWRD]
	MOV	AX,[BX]
;MOV	mod 00	[r/m],r16
	MOV	[BX+SI],DI
	MOV	[BX+DI],SI
	MOV	[BP+SI],BP
	MOV	[BP+DI],SP
	MOV	[SI],BX
	MOV	[DI],DX
	MOV	[DRWRD],CX
	MOV	[BX],AX
;MOV	mod 01	r16,[r/m+d8]
	MOV	DI,[BX+SI  +1]
	MOV	SI,[BX+DI  +5]
	MOV	BP,[BP+SI +55]
	MOV	SP,[BP+DI+127]
	MOV	BX,[SI	 -128]
	MOV	DX,[DI	  -40]
	MOV	CX,[BP	   -8]
	MOV	AX,[BX	   -1]
;MOV	mod 01	[r/m+d8],r16
	MOV	[BX+SI	+1],DI
	MOV	[BX+DI	+5],SI
	MOV	[BP+SI +55],BP
	MOV	[BP+DI+127],SP
	MOV	[SI   -128],BX
	MOV	[DI    -40],DX
	MOV	[BP	-8],CX
	MOV	[BX	-1],AX
;MOV	mod 10	r16,[r/m+d16]
	MOV	DI,[BX+SI  +128]
	MOV	SI,[BX+DI +1234]
	MOV	BP,[BP+SI+32767]
	MOV	SP,[BP+DI+60000]
	MOV	BX,[SI	 -32768]
	MOV	DX,[DI	  -1234]
	MOV	CX,[BP	  -2345]
	MOV	AX,[BX	   -129]
;MOV	mod 10	[r/m+d16],r16
	MOV	[BX+SI	+128],DI
	MOV	[BX+DI +1234],SI
	MOV	[BP+SI+32767],BP
	MOV	[BP+DI+60000],SP
	MOV	[SI   -32768],BX
	MOV	[DI    -1234],DX
	MOV	[BP    -2345],CX
	MOV	[BX	-129],AX
;MOV	mod 11	r16,r16
	MOV	AX,DI
	MOV	CX,SI
	MOV	DX,BP
	MOV	BX,SP
	MOV	SP,BX
	MOV	BP,DX
	MOV	SI,CX
	MOV	DI,AX
;MOV	mod 00	[r/m],imm8
	MOV	BYTE PTR[BX+SI],   0
	MOV	BYTE PTR[BX+DI],   1
	MOV	BYTE PTR[BP+SI], 127
	MOV	BYTE PTR[BP+DI], 128
	MOV	BYTE PTR   [SI], 255
	MOV	BYTE PTR   [DI],-128
	MOV	BYTE PTR[DRBYT], -28
	MOV	BYTE PTR   [BX],  -1
;MOV	mod 01	[r/m+d8],imm8
	MOV	BYTE PTR[BX+SI	+1],   0
	MOV	BYTE PTR[BX+DI	+5],   1
	MOV	BYTE PTR[BP+SI +55], 127
	MOV	BYTE PTR[BP+DI+127], 128
	MOV	BYTE PTR[SI   -128], 255
	MOV	BYTE PTR[DI    -40],-128
	MOV	BYTE PTR[BP	-8], -28
	MOV	BYTE PTR[BX	-1],  -1
;MOV	mod 10	[r/m+d16],imm8
	MOV	BYTE PTR[BX+SI	+128],	 0
	MOV	BYTE PTR[BX+DI +1234],	 1
	MOV	BYTE PTR[BP+SI+32767], 127
	MOV	BYTE PTR[BP+DI+60000], 128
	MOV	BYTE PTR[SI   -32768], 255
	MOV	BYTE PTR[DI    -1234],-128
	MOV	BYTE PTR[BP    -2345], -28
	MOV	BYTE PTR[BX	-129],	-1
;MOV	mod 11	r8,imm8
	MOV	AL,   0
	MOV	CL,   1
	MOV	DL, 127
	MOV	BL, 128
	MOV	AH, 255
	MOV	CH,-128
	MOV	DH, -28
	MOV	BH,  -1
;MOV	mod 00	[r/m],imm16
	MOV	WORD PTR[BX+SI],   128
	MOV	WORD PTR[BX+DI],   255
	MOV	WORD PTR[BP+SI],  1024
	MOV	WORD PTR[BP+DI], 65000
	MOV	WORD PTR   [SI],-32768
	MOV	WORD PTR   [DI],-10000
	MOV	WORD PTR[DRWRD], -1000
	MOV	WORD PTR   [BX],  -129
;MOV	mod 01	[r/m],imm16
	MOV	WORD PTR[BX+SI	+1],   128
	MOV	WORD PTR[BX+DI	+5],   255
	MOV	WORD PTR[BP+SI +55],  1024
	MOV	WORD PTR[BP+DI+127], 65000
	MOV	WORD PTR[SI   -128],-32768
	MOV	WORD PTR[DI    -40],-10000
	MOV	WORD PTR[BP	-8], -1000
	MOV	WORD PTR[BX	-1],  -129
;MOV	mod 10	[r/m],imm16
	MOV	WORD PTR[BX+SI	+128],	 128
	MOV	WORD PTR[BX+DI +1234],	 255
	MOV	WORD PTR[BP+SI+32767],	1024
	MOV	WORD PTR[BP+DI+60000], 60000
	MOV	WORD PTR[SI   -32768],-32768
	MOV	WORD PTR[DI    -1234],-10000
	MOV	WORD PTR[BP    -2345], -1000
	MOV	WORD PTR[BX	-129],	-129
;MOV	mod 11	[r/m],imm16
	MOV	AX,   128
	MOV	CX,   255
	MOV	DX,  1024
	MOV	BX, 65000
	MOV	SP,-32768
	MOV	BP,-10000
	MOV	SI, -1000
	MOV	DI,  -129

;MOV	mod 00	segreg,[r/m]
	MOV	DS,[BX+SI]
	MOV	DS,[BX+DI]
	MOV	ES,[BP+SI]
	MOV	SS,[BP+DI]
	MOV	DS,[SI	 ]
	MOV	DS,[DI	 ]
	MOV	ES,[DRWRD]
	MOV	SS,[BX	 ]
;MOV	mod 00	[r/m],segreg
	MOV	[BX+SI],DS
	MOV	[BX+DI],CS
	MOV	[BP+SI],ES
	MOV	[BP+DI],SS
	MOV	[SI   ],DS
	MOV	[DI   ],CS
	MOV	[DRWRD],ES
	MOV	[BX   ],SS
;MOV	mod 01	segreg,[r/m+d8]
	MOV	DS,[BX+SI  +1]
	MOV	DS,[BX+DI  +5]
	MOV	ES,[BP+SI +55]
	MOV	SS,[BP+DI+127]
	MOV	DS,[SI	 -128]
	MOV	DS,[DI	  -40]
	MOV	ES,[BP	   -8]
	MOV	SS,[BX	   -1]
;MOV	mod 01	[r/m+d8],segreg
	MOV	[BX+SI	+1],DS
	MOV	[BX+DI	+5],CS
	MOV	[BP+SI +55],ES
	MOV	[BP+DI+127],SS
	MOV	[SI   -128],DS
	MOV	[DI    -40],CS
	MOV	[BP	-8],ES
	MOV	[BX	-1],SS
;MOV	mod 10	segreg,[r/m+d16]
	MOV	DS,[BX+SI  +128]
	MOV	DS,[BX+DI +1234]
	MOV	ES,[BP+SI+32767]
	MOV	SS,[BP+DI+60000]
	MOV	DS,[SI	 -32768]
	MOV	DS,[DI	  -1234]
	MOV	ES,[BP	  -2345]
	MOV	SS,[BX	   -129]
;MOV	mod 10	[r/m+d16],segreg
	MOV	[BX+SI	+128],DS
	MOV	[BX+DI +1234],CS
	MOV	[BP+SI+32767],ES
	MOV	[BP+DI+60000],SS
	MOV	[SI   -32768],DS
	MOV	[DI    -1234],CS
	MOV	[BP    -2345],ES
	MOV	[BX	-129],SS
;MOV	mod 11	segreg,r16
	MOV	DS,DI
	MOV	DS,SI
	MOV	ES,BP
	MOV	SS,SP
	MOV	DS,BX
	MOV	DS,DX
	MOV	ES,CX
	MOV	SS,AX
;MOV	mod 11	r16,segreg
	MOV	AX,DS
	MOV	CX,CS
	MOV	DX,ES
	MOV	BX,SS
	MOV	SP,DS
	MOV	BP,CS
	MOV	SI,ES
	MOV	DI,SS


DRBYT:	DFB	56h			;DRECT BYTE
DRWRD:	dwL	7890H			;DRECT WORD


	END	BEGIN
