;***********************************************************
;
; THIS IS AN EXAMPLE PROGRAM FOR THE 8085 PROCESSOR.
; IT IS TAKEN FROM PAGE 245 OF THE NOVEMBER 29, 1984 ISSUE
; OF EDN MAGAZINE, AND AFTER ONLY FORMAT MODIFICATIONS,
; IT IS PASSED ON AS AN EXAMPLE, FREE OF CHARGE,
; BY UNIVERSAL CROSS-ASSEMBLERS.
;
; THERE ARE NO SPECIAL NOTES CONCERNING THE USE OF THE
; ASSEMBLER WITH THE 8085 FAMILY OF MICROPROCESSORS.
;
         CPU     "8085.TBL"    ;CPU TABLE
         HOF     "INT8"        ;HEX FORMAT
;
;
;
; THIS ROUTINE 32BIT LENGTH FRAME SYNCH CODE (4 BYTES)
;
TEMREG:  EQU     2003H        ;TOP ADD. OF TEMPORARY REGISTERS
FSCODE:  EQU     3003H        ;TOP ADD. OF FRAME SYNCH CODE
REGLEN:  EQU     04H          ;FRAME SYNCH CODE LENGTH
ERRSET:  EQU     00H          ;ADDRESS OF THE ERROR PORT
SYNDET:  EQU     01H          ;ADDRESS OF SYNDET PORT
DISFSC:  EQU     0BH
;
START:   LXI     H,TEMREG
         RIM
         MVI     D,REGLEN
         RLC                  ;SID -> CARRY
LOOP1:   MOV     A,M          ;ROTATE REG.SET BY ONE BIT
         RAL
         MOV     M,A
         DCX     H
         DCR     D
         JNZ     LOOP1
         INX     H
         LXI     B,FSCODE
         MVI     D,REGLEN
         MVI     E,0H
LOOP:    LDAX    B            ;FINDS NUMBER OF ERRORS
         CALL    COUNT        ;IN RECEIVED DATA
         DCX     B
         DCR     D
         JNZ     LOOP
         IN      ERRSET       ;ALLOWABLE NO. OF ERRORS
         CMP     E
         JNC     CORRECT      ;JUMPS IF RX DATA HAS LESS
         EI                   ;ERRORS THAN PROGRAMMED
         RET
CORRECT: OUT     SYNDET
         MVI     A,DISFSC
         SIM
         RET
COUNT:   PUSH    D            ;COMPARES EACH BYTE -
         MVI     D,08H        ;FINDS ERRORS
LOOP2:   RLC
         JNC     SKIP
         INR     E
SKIP:    DCR     D
         JNZ     LOOP2
         INX     H
         POP     D
         RET
	 END     START
