;******************************************************
;******************************************************
;The 8051 table "8051.TBL" supports Intel's MCS-51
;microcontroller family.  A list of the register and
;bit names with their corresponding addresses appears
;at the end of "8051.TBL".  This processor has been
;extended and modified by many manufacturers, therefore
;additions may have to this list by the user.  Cross-32
;tables are ASCII text files, and may be modified with
;any editor
;
	CPU	"8051.TBL"	;Processor declaration
	HOF	"INT8"		;Intel 8-bit hexcode

;******************************************************
;UNIVERSAL CROSS-ASSEMBLERS HAS ADDED TWO MNEMONICS,
;CALL AND JMP.	THE ASSEMBLER AUTOMATICALLY USES THE
;SHORTEST OF ACALL AND LCALL WITH THE CALL MNEMONIC,
;AND THE SHORTEST OF SJMP, AJMP AND LJMP WITH THE JMP
;MNEMONIC.  EXAMPLE:
;
RESET:	ORG	0000H		;Reset vector
	JMP	START

;******************************************************
; ALL 8051 BIT ADDRESSES MAY BE SPECIFIED IN ONE OF
;THREE WAYS:

	ORG	0100H
START:	CLR	20H.1	;BIT ADDRESSABLE AREA
	CLR	CY	;BIT DIRECT ADDRESS
	CLR	PSW.7	;BIT ADDRESSABLE REG

;******************************************************
; Further examples of 8051 instructions, and an
; 8051 example subroutine follow:
;
	ACALL	ABSOL		

	ADD	A,R0		
	ADD	A,R1		
	ADD	A,R2		
	ADD	A,R6		
	ADD	A,DIRECT	
	ADD	A,R7		
	ADD	A,@R0		
	ADD	A,@R1		
	ADD	A,#IMM8		

	ADDC	A,R0		
	ADDC	A,R7		
	ADDC	A,DIRECT	
	ADDC	A,@R0		
	ADDC	A,@R1		
	ADDC	A,#IMM8		

	AJMP	ABSOL		

	ANL	A,R0		
	ANL	A,R1		
	ANL	A,R6		
	ANL	A,R7		
	ANL	A,DIRECT	
	ANL	A,@R0		
	ANL	A,@R1		
	ANL	A,#IMM8		
	ANL	DIRECT,A	
	ANL	DIRECT,#IMM8	
	ANL	C,CY		
	ANL	C,2AH.6		
	ANL	C,P0.5		
	ANL	C,/CY		
	ANL	C,/PSW.7	
	ANL	C,/2AH.6	

	CJNE	A,DIRECT,$+42H	
	CJNE	A,#IMM8,$+42H	
	CJNE	R0,#IMM8,$+42H	
	CJNE	R1,#IMM8,$+42H	
	CJNE	R7,#IMM8,$+42H	
	CJNE	@R0,#IMM8,$+42H	
	CJNE	@R1,#IMM8,$+42H	

	CLR	A		
	CLR	C		
	CLR	CY		
	CLR	PSW.7		
	CLR	2AH.6		

	CPL	A		
	CPL	C		
	CPL	CY		
	CPL	PSW.7		
	CPL	2AH.6		

	DAA			
	DA	A		

LDEC:	DEC	A		
	DEC	R0		
	DEC	R1		
	DEC	R7		
	DEC	DIRECT		
	DEC	@R0		
	DEC	@R1		

	DIV	AB		

	DJNZ	R0,$+42H	
	DJNZ	R1,$+42H	
	DJNZ	R7,$+42H	

	DJNZ	DIRECT,$+42H	

	INC	A		
	INC	R0		
	INC	R7		
	INC	DIRECT		
	INC	@R0		
	INC	@R1		
	INC	DPTR		

	JB	2AH.6,$+42H	
	JB	PSW.7,$+42H	
	JB	CY,$+42H	

	JBC	2AH.6,$+42H	
	JBC	PSW.7,$+42H	
	JBC	CY,$+42H	

	JC	$+42H		

	JMP	@A+DPTR		

	JNB	2AH.6,$+42H	
	JNB	PSW.7,$+42H	
	JNB	CY,$+42H	

	JNC	$+42H		

	JNZ	$+42H		

	JZ	$+42H		

	LCALL	LONG		
	LJMP	LONG		

	MOV	A,R0		
	MOV	A,R1		
	MOV	A,R7		
	MOV	A,DIRECT	
	MOV	A,@R0		
	MOV	A,@R1		
	MOV	A,#IMM8		
	MOV	R0,A		
	MOV	R7,A		
	MOV	R0,DIRECT	
	MOV	R6,DIRECT	
	MOV	R7,DIRECT	
	MOV	R0,#IMM8	
	MOV	R7,#IMM8	
	MOV	DIRECT,A	
	MOV	DIRECT,R0	
	MOV	DIRECT,R7	
	MOV	DIRECT,DIRECT	
	MOV	DIRECT,@R0	
	MOV	DIRECT,@R1	
	MOV	DIRECT,#IMM8	
	MOV	@R0,A		
	MOV	@R1,A		
	MOV	@R0,DIRECT	
	MOV	@R1,DIRECT	
	MOV	@R0,#IMM8	
	MOV	@R1,#IMM8	
	MOV	C,2AH.6		
	MOV	C,CY		
	MOV	C,PSW.7		
	MOV	2AH.6,C		
	MOV	CY,C		
	MOV	PSW.7,C		
	MOV	DPTR,#IMM16	

	MOVC	A,@A+DPTR	
	MOVC	A,@A+PC		

	MOVX	A,@R0		
	MOVX	A,@R1		
	MOVX	A,@DPTR		
	MOVX	@R0,A		
	MOVX	@R1,A		
	MOVX	@DPTR,A		

	NOP			

	MUL	AB		

	ORL	A,R0		
	ORL	A,R7		
	ORL	A,DIRECT	
	ORL	A,@R0		
	ORL	A,@R1		
	ORL	A,#IMM8		
	ORL	DIRECT,A	
	ORL	DIRECT,#IMM8	
	ORL	C,2AH.6		
	ORL	C,PSW.7		
	ORL	C,CY		
	ORL	C,/2AH.6	
	ORL	C,/PSW.7	
	ORL	C,/CY		

	POP	DIRECT		
	PUSH	DIRECT		

	RET			
	RETI			

	RL	A		
	RLC	A		

	RR	A		
	RRC	A		

	SETB	C		
	SETB	2AH.6		
	SETB	PSW.7		
	SETB	CY		

	SJMP	$+42H		

	SUBB	A,R0		
	SUBB	A,R7		
	SUBB	A,DIRECT	
	SUBB	A,@R0		
	SUBB	A,@R1		
	SUBB	A,#IMM8		

	SWAP	A		

	XCH	A,R0		
	XCH	A,R7		
	XCH	A,DIRECT	
	XCH	A,@R0		
	XCH	A,@R1		

	XCHD	A,@R0		
	XCHD	A,@R1		

	XRL	A,R0		
	XRL	A,R6		
	XRL	A,R7		
	XRL	A,DIRECT	
	XRL	A,@R0		
	XRL	A,@R1		
	XRL	A,#IMM8		
	XRL	DIRECT,A	
	XRL	DIRECT,#IMM8	

ABSOL:	EQU	0580H
IMM8:	EQU	-16
IMM16:	EQU	-1024
DIRECT:	EQU	80H
LONG:	EQU	1234H
BIT.56:	EQU	56H

;******************************************************
;THESE ARE EXAMPLE SUBROUTINES FOR THE 8051 MICRO-
;CONTROLLER FAMILY.  THEY ARE TAKEN FROM THE 1982
;INTEL MICROCONTROLLER USER'S MANUAL ON PAGES 9-1
;& 9-2.  AFTER ONLY FORMAT MODIFICATIONS,
;THEY ARE PASSED ON AS EXAMPLES, FREE OF CHARGE, BY
;UNIVERSAL CROSS-ASSEMBLERS.
;
	ORG	0280H
;
;BINBCD  CONVERT 8-BIT BINARY VARIABLE IN ACCUMULATOR
;	TO 3-DIGIT PACKED BCD FORMAT.
;	HUNDREDS' PLACE LEFT IN VARIABLE 'HUND',
;	TENS' AND ONES' PLACES IN 'TENONE'.
;
HUND:	EQU	21H
TENONE: EQU	22H
;
BINBCD: MOV	B,#100	;DIVIDED BY 100 TO
	DIV	AB	;DETERMINE NUM OF HUNDREDS
	MOV	HUND,A
	MOV	A,#10	;DIVIDE REMAIN. BY TEN TO
	XCH	A,B	;DETERMINE NUMBER OF TENS
	DIV	AB	;TEN'S DIGIT IN ACC,
			;REMAINDER IS ONE'S DIGIT
	SWAP	A	;
	ADD	A,B	;PACK BCD DIGITS IN ACC
	MOV	TENONE,A
	RET
;
;MULBCD  UNPACK TWO BCD DIGITS RECEIVED IN ACCUMULATOR,
;	FIND THEIR PRODUCT, AND RETURN PRODUCT
;	IN PACKED BCD FORMAT IN ACCUMULATOR
;
MULBCD: MOV	B,#10H	;DIVIDE INPUT BY 16
	DIV	AB	;A & B HOLD SEP. DIGITS
			;(RIGHT JUSTIFIED IN REG).
	MUL	AB	;A HOLDS PRODUCT IN BINARY
			;(0-99(DECIMAL) = 0 - 63H)
	MOV	B,#10	;DIVIDE PRODUCT BY 10
	DIV	AB	;A HOLDS NUMBER OF TENS,
			;B HOLDS REMAINDER
	SWAP	A
	ORL	A,B	;PACK DIGITS
	RET

;******************************************************
;******************************************************
; An error has been purposely placed here!
; To fix it, remove the space between "EN"
; and "D" and press F9 to re-assemble.
; A hex file "E8051.HEX" and a list file
; "E8051.LST" have been created automatically.
;******************************************************
	EN D
;******************************************************

