;******************************************************
; THERE ARE NO SPECIAL INSTRUCTION FOR THE 8041.
;
	 CPU     "8041.TBL"     ; CPU TABLE
         HOF     "INT8"         ; HEX FORMAT

;******************************************************
; SOME SAMPLE INSTRUCTIONS ARE:
;
IMM8:	EQU	80H
REL:	EQU	0112H
;
START:	ORG	0100H
;
	ADD	A,R0		;68
	ADD	A,R1		;69
	ADD	A,R2		;6A
	ADD	A,R7		;6F
	ADD	A,@R0		;60
	ADD	A,@R1		;61
	ADD	A,#IMM8		;0380

	ADDC	A,R0		;78
	ADDC	A,R1		;79
	ADDC	A,R7		;7F
	ADDC	A,@R0		;70
	ADDC	A,@R1		;71
	ADDC	A,#IMM8		;1380

	ANL	A,R0		;58
	ANL	A,R6		;5E
	ANL	A,R7		;5F
	ANL	A,@R0		;50
	ANL	A,@R1		;51
	ANL	A,#IMM8		;5380
	ANL	P1,#IMM8	;9980
	ANL	P2,#IMM8	;9A80

	ANLD	P4,A		;9C
	ANLD	P5,A		;9D
	ANLD	P6,A		;9E
	ANLD	P7,A		;9F

	CALL	START		;3400

	CLR	A		;27
	CLR	C		;97
	CLR	F1		;A5
	CLR	F0		;85

	CPL	A		;37
	CPL	C		;A7
	CPL	F0		;95
	CPL	F1		;B5

	DA	A		;57

	DEC	A		;07
	DEC	R0		;C8
	DEC	R1		;C9
	DEC	R7		;CF

	DIS	I		;15
	DIS	TCNTI		;35

	DJNZ	R0,REL		;E812
	DJNZ	R1,REL		;E912
	DJNZ	R2,REL		;EA12

	EN	I		;05
	EN	TCNTI		;25
	EN	DMA		;E5
	EN	FLAGS		;F5

	JB0	REL		;1212
	JB7	REL		;F212

	JC	REL		;F612
	JF0	REL		;B612
	JF1	REL		;7612

	JMP	START		;2400
	JMPP	@A		;B3

	JNC	REL		;E612
	JNIBF	REL		;D612
	JNT0	REL		;2612
	JNT1	REL		;4612
	JNZ	REL		;9612
	JTF	REL		;1612
	JOBF	REL		;8612
	JT0	REL		;3612
	JT1	REL		;5612
	JZ	REL		;C612

	MOV	A,#IMM8		;2380

	MOV	A,PSW		;C7

	MOV	A,R0		;F8
	MOV	A,R1		;F9
	MOV	A,R2		;FA
	MOV	A,R3		;FB
	MOV	A,R4		;FC
	MOV	A,R5		;FD
	MOV	A,R6		;FE
	MOV	A,R7		;FF

	MOV	A,@R0		;F0
	MOV	A,@R1		;F1

	MOV	A,T		;42

	MOV	PSW,A		;D7

	MOV	R0,A		;A8
	MOV	R1,A		;A9
	MOV	R2,A		;AA
	MOV	R3,A		;AB
	MOV	R4,A		;AC
	MOV	R5,A		;AD
	MOV	R6,A		;AE
	MOV	R7,A		;AF

	MOV	R0,#IMM8	;B880
	MOV	R1,#IMM8	;B980
	MOV	R2,#IMM8	;BA80
	MOV	R3,#IMM8	;BB80
	MOV	R4,#IMM8	;BC80
	MOV	R5,#IMM8	;BD80
	MOV	R6,#IMM8	;BE80
	MOV	R7,#IMM8	;BF80

	MOV	@R0,A		;A0
	MOV	@R1,A		;A1

	MOV	@R0,#IMM8	;B080
	MOV	@R1,#IMM8	;B180

	MOV	T,A		;62

	MOV	STS,A		;90

	MOVD	A,P4		;0C
	MOVD	A,P5		;0D
	MOVD	A,P6		;0E
	MOVD	A,P7		;0F

	MOVD	P4,A		;3C
	MOVD	P5,A		;3D
	MOVD	P6,A		;3E
	MOVD	P7,A		;3F

	MOVP	A,@A		;A3

	MOVP3	A,@A		;E3

	STOP	TCNT		;65
	STRT	CNT		;45
	STRT	T		;55
ZZZ:
	END
