;******************************************************
;
	CPU	"80166.TBL"
	HOF	"INT8"
	ALGN	2	;ALIGN FOR 2 BYTE WORDS
;
;******************************************************
;
; THE 80166 TABLE SUPPORTS THE SIEMENS SAB 80C166/83C166
; 16-BIT CMOS SINGLE CHIP MICROCONTROLLERS
;
;******************************************************
;
; SPECIAL FUNCTION REGISTERS MAY BE DEFINED USING
; THEIR 8-BIT ADDRESSES OR THEIR 16-BIT PHYSICAL
; ADDRESSES.  THE ASSEMBLER WILL AUTOMATICALLY
; CONVERT 16-BIT PHYSICAL ADDRESSES INTO THEIR
; SHORTER 8-BIT EQUIVALENTS WHERE POSSIBLE.  MOST OF
; THE FOLLOWING REGISTERS ARE DEFINED USING 8-BITS.
; FOR A 16-BIT EXAMPLE, SEE P3.
;
; INDIVIDUAL BIT ADDRESSES MAY ALSO BE USED.  MOST
; OF THE COMMON ONES ARE DEFINED BELOW.  THESE ARE
; CREATED BY MULTIPLYING AN 8-BIT BY 256 AND ADDING
; THE BIT NUMBER (SEE BELOW), OR MULTIPLYING A 16-BIT
; REGISTER ADDRESS BY 128 AND ADDING THE BIT NUMBER
; (SEE P3).
;
; THE FOLLOWING DEFINITIONS SHOULD BE INCLUDED
; INTO YOUR SOURCE FILE.
;
DPP0:	EQU	$00	;CPU DATA PAGE POINTER 0
DPP1:	EQU	$01	;CPU DATA PAGE POINTER 1
DPP2:	EQU	$02	;CPU DATA PAGE POINTER 2
DPP3:	EQU	$03	;CPU DATA PAGE POINTER 3
CSP:	EQU	$04	;CPU CODE SEGMENT POINTER
;
MDH:	EQU	$06	;CPU MUL/DIV - HIGH WORD
MDL:	EQU	$07	;CPU MUL/DIV - LOW WORD
CP:	EQU	$08	;CPU CONTEXT POINTER
SP:	EQU	$09	;CPU SYSTEM STACK POINTER
STKOV:	EQU	$0A	;CPU STACK OVERFLOW POINTER
STKUN:	EQU	$0B	;CPU STACK UNDERFLOW POINTER
;
T2:	EQU	$20	;GPT1 TIMER 2
T3:	EQU	$21	;GPT1 TIMER 3
T4:	EQU	$22	;GPT1 TIMER 4
T5:	EQU	$23	;GPT2 TIMER 5
T6:	EQU	$24	;GPT2 TIMER 6
CAPREL: EQU	$25	;GPT2 CAPTURE/RELOAD
;
T0:	EQU	$28	;CAPCON TIMER 0
T1:	EQU	$29	;CAPCON TIMER 1
T0REL:	EQU	$2A	;CAPCON TIMER 0 RELOAD
T1REL:	EQU	$2B	;CAPCON TIMER 1 RELOAD
;
CC0:	EQU	$40	;CAPCON REGISTER 0
CC1:	EQU	$41	;CAPCON REGISTER 1
CC2:	EQU	$42	;CAPCON REGISTER 2
CC3:	EQU	$43	;CAPCON REGISTER 3
CC4:	EQU	$44	;CAPCON REGISTER 4
CC5:	EQU	$45	;CAPCON REGISTER 5
CC6:	EQU	$46	;CAPCON REGISTER 6
CC7:	EQU	$47	;CAPCON REGISTER 7
CC8:	EQU	$48	;CAPCON REGISTER 8
CC9:	EQU	$49	;CAPCON REGISTER 9
CC10:	EQU	$4A	;CAPCON REGISTER 10
CC11:	EQU	$4B	;CAPCON REGISTER 11
CC12:	EQU	$4C	;CAPCON REGISTER 12
CC13:	EQU	$4D	;CAPCON REGISTER 13
CC14:	EQU	$4E	;CAPCON REGISTER 14
CC15:	EQU	$4F	;CAPCON REGISTER 15
ADDAT:	EQU	$50	;A/D CONVERTER RESULT
;
WDT:	EQU	$57	;WATCHDOG TIMER
S0TBUF: EQU	$58	;SERIAL CHANNEL 0 TRANSMIT BUFFER
S0RBUF: EQU	$59	;SERIAL CHANNEL 0 RECEIVE BUFFER
S0BG:	EQU	$5A	;SERIAL CHANNEL 0 BAUD RATE GENERATOR
;
S1TBUF: EQU	$5C	;SERIAL CHANNEL 1 TRANSMIT BUFFER
S1RBUF: EQU	$5D	;SERIAL CHANNEL 1 RECEIVE BUFFER
S1BG:	EQU	$5E	;SERIAL CHANNEL 1 BAUD RATE GENERATOR
;
PECC0:	EQU	$60	;PEC CHANNEL 0 CONTROL
 BWT0:	EQU	PECC0*256+8	;BYTE/WORD SELECT
PECC1:	EQU	$61	;PEC CHANNEL 1 CONTROL
 BWT1:	EQU	PECC1*256+8	;BYTE/WORD SELECT
PECC2:	EQU	$62	;PEC CHANNEL 2 CONTROL
 BWT2:	EQU	PECC2*256+8	;BYTE/WORD SELECT
PECC3:	EQU	$63	;PEC CHANNEL 3 CONTROL
 BWT3:	EQU	PECC3*256+8	;BYTE/WORD SELECT
PECC4:	EQU	$64	;PEC CHANNEL 4 CONTROL
 BWT4:	EQU	PECC4*256+8	;BYTE/WORD SELECT
PECC5:	EQU	$65	;PEC CHANNEL 5 CONTROL
 BWT5:	EQU	PECC5*256+8	;BYTE/WORD SELECT
PECC6:	EQU	$66	;PEC CHANNEL 6 CONTROL
 BWT6:	EQU	PECC6*256+8	;BYTE/WORD SELECT
PECC7:	EQU	$67	;PEC CHANNEL 7 CONTROL
 BWT7:	EQU	PECC7*256+8	;BYTE/WORD SELECT
;
P0:	EQU	$80	;PORT 0
DP0:	EQU	$81	;PORT 0 DIRECTION CONTROL
P1:	EQU	$82	;PORT 1
DP1:	EQU	$83	;PORT 1 DIRECTION CONTROL
P4:	EQU	$84	;PORT 4
 A16:	EQU	P4*256+0	;LOWER ADDRESS LINE OF SEG ADR
 A17:	EQU	P4*256+1	;HIGHER ADDRESS LINE OF SEG ADR
DP4:	EQU	$85	;PORT 4 DIRECTION CONTROL
SYSCON: EQU	$86	;CPU SYSTEM CONFIGURATION
MDC:	EQU	$87	;CPU MULTIPLY/DIVIDE CONTROL
 MDRIU: EQU	MDC*256+4	;MULTIPLY/DIVIDE
PSW:	EQU	$88	;CPU PROCESSOR STATUS WORD
 N:	EQU	PSW*256+0	;NEGATIVE
 C:	EQU	PSW*256+1	;CARRY
 V:	EQU	PSW*256+2	;OVERFLOW
 Z:	EQU	PSW*256+3	;ZERO
 E:	EQU	PSW*256+4	;END OF A TABLE
 MULIP: EQU	PSW*256+5	;MULTIPLY/DIVIDE
 USR0:	EQU	PSW*256+6	;USER FLAG
 IEN:	EQU	PSW*256+11	;INTERRUPT ENABLE
;
ZEROS:	EQU	$8E	;CONSTANT VALUE 0'S
ONES:	EQU	$8F	;CONSTANT VALUE 1'S
;
T2CON:	EQU	$FF40  ;GPT1 TIMER 2 CONTROL
 T2R:	EQU	T2CON*128+6	;RUN BIT
 T2UD:	EQU	T2CON*128+7	;UP/DOWN CONTROL BIT
T3CON:	EQU	$A1    ;GPT1 TIMER 3 CONTROL
 T3R:	EQU	T3CON*256+6	;RUN BIT
 T3UD:	EQU	T3CON*256+7	;UP/DOWN CONTROL
 T3UDE: EQU	T3CON*256+8	;EXTERNAL UP/DOWN CONTROL ENABLE BIT
 T3OE:	EQU	T3CON*256+9	;ALTERNATE OUTPUT FUNCTION ENABLE
 T3OTL: EQU	T3CON*256+10	;TIMER OUTPUT TOGGLE LATCH
T4CON:	EQU	$A2    ;GPT1 TIMER 4 CONTROL
 T4R:	EQU	T4CON*256+6	;RUN BIT
 T4UD:	EQU	T4CON*256+7	;UP/DOWN CONTROL BIT
T5CON:	EQU	$A3    ;GPT2 TIMER 5 CONTROL
 T5M:	EQU	T5CON*256+3	;MODE CONTROL
 T5R:	EQU	T5CON*256+6	;RUN BIT
 T5UD:	EQU	T5CON*256+7	;UP/DOWN CONTROL
 T5CLR: EQU	T5CON*256+14	;CLEAR BIT
 T5SC:	EQU	T5CON*256+15	;CAPTURE MODE ENABLE BIT
T6CON:	EQU	$A4    ;GPT2 TIMER 6 CONTROL
 T6R:	EQU	T6CON*256+6	;RUN BIT
 T6UD:	EQU	T6CON*256+7	;UP/DOWN CONTROL
 T6OE:	EQU	T6CON*256+9	;ALTERNATE OUTPUT FUNCTION ENABLE
 T6OTL: EQU	T6CON*256+10	;TIMER OUTPUT TOGGLE LATCH
 T6SR:	EQU	T6CON*256+15	;RELOAD MODE ENABLE BIT
;
T01CON: EQU	$A8    ;CAPCOM TIMER 0 AND TIMER 1 CONTROL
 T0M:	EQU	T01CON*256+3	;TIMER/COUNTER 0 MODE SELECTION
 T0R:	EQU	T01CON*256+6	;TIMER/COUNTER 0 RUN BIT
 T1M:	EQU	T01CON*256+11	;TIMER/COUNTER 1 MODE SELECTION
 T1R:	EQU	T01CON*256+14	;TIMER/COUNTER 1 RUN BIT

CCM0:	EQU	$A9    ;CAPCOM MODE CONTROL 0
 ACC0:	EQU	CCM0*256+3	;ALLOCATION BIT
 ACC1:	EQU	CCM0*256+7	;ALLOCATION BIT
 ACC2:	EQU	CCM0*256+11	;ALLOCATION BIT
 ACC3:	EQU	CCM0*256+15	;ALLOCATION BIT
CCM1:	EQU	$AA    ;CAPCOM MODE CONTROL 1
 ACC4:	EQU	CCM1*256+3	;ALLOCATION BIT
 ACC5:	EQU	CCM1*256+7	;ALLOCATION BIT
 ACC6:	EQU	CCM1*256+11	;ALLOCATION BIT
 ACC7:	EQU	CCM1*256+15	;ALLOCATION BIT
CCM2:	EQU	$AB    ;CAPCOM MODE CONTROL 2
 ACC8:	EQU	CCM2*256+3	;ALLOCATION BIT
 ACC9:	EQU	CCM2*256+7	;ALLOCATION BIT
 ACC10: EQU	CCM2*256+11	;ALLOCATION BIT
 ACC11: EQU	CCM2*256+15	;ALLOCATION BIT
CCM3:	EQU	$AC    ;CAPCOM MODE CONTROL 3
 ACC12: EQU	CCM3*256+3	;ALLOCATION BIT
 ACC13: EQU	CCM3*256+7	;ALLOCATION BIT
 ACC14: EQU	CCM3*256+11	;ALLOCATION BIT
 ACC15: EQU	CCM3*256+15	;ALLOCATION BIT
;
T2IC:	EQU	$B0    ;GPT1 TIMER 2 INTERRUPT CONTROL
 T2IE:	EQU	T2IC*256+6	;INTERRUPT ENABLE
 T2IR:	EQU	T2IC*256+7	;INTERRUPT REQUEST
T3IC:	EQU	$B1    ;GPT1 TIMER 3 INTERRUPT CONTROL
 T3IE:	EQU	T3IC*256+6	;INTERRUPT ENABLE
 T3IR:	EQU	T3IC*256+7	;INTERRUPT REQUEST
T4IC:	EQU	$B2    ;GPT1 TIMER 4 INTERRUPT CONTROL
 T4IE:	EQU	T4IC*256+6	;INTERRUPT ENABLE
 T4IR:	EQU	T4IC*256+7	;INTERRUPT REQUEST
T5IC:	EQU	$B3    ;GPT2 TIMER 5 INTERRUPT CONTROL
 T5IE:	EQU	T5IC*256+6	;INTERRUPT ENABLE
 T5IR:	EQU	T5IC*256+7	;INTERRUPT REQUEST
T6IC:	EQU	$B4    ;GPT2 TIMER 6 INTERRUPT CONTROL
 T6IE:	EQU	T6IC*256+6	;INTERRUPT ENABLE
 T6IR:	EQU	T6IC*256+7	;INTERRUPT REQUEST
CRIC:	EQU	$B5    ;GPT2 CAPREL INTERRUPT CONTROL
 CRIE:	EQU	CRIC*256+6	;INTERRUPT ENABLE
 CRIR:	EQU	CRIC*256+7	;INTERRUPT REQUEST
S0TIC:	EQU	$B6    ;SERIAL CHANNEL 0 TRANSMIT INTERRUPT CONTROL
 S0TIE: EQU	S0TIC*256+6	;INTERRUPT ENABLE
 S0TIR: EQU	S0TIC*256+7	;INTERRUPT REQUEST
S0RIC:	EQU	$B7    ;SERIAL CHANNEL 0 RECEIVE INTERRUPT CONTROL
 S0RIE: EQU	S0RIC*256+6	;INTERRUPT ENABLE
 S0RIR: EQU	S0RIC*256+7	;INTERRUPT REQUEST
S0EIC:	EQU	$B8    ;SERIAL CHANNEL 0 ERROR INTERRUPT CONTROL
 S0EIE: EQU	S0EIC*256+6	;INTERRUPT ENABLE
 S0EIR: EQU	S0EIC*256+7	;INTERRUPT REQUEST
S1TIC:	EQU	$B9    ;SERIAL CHANNEL 1 TRANSMIT INTERRUPT CONTROL
 S1TIE: EQU	S1TIC*256+6	;INTERRUPT ENABLE
 S1TIR: EQU	S1TIC*256+7	;INTERRUPT REQUEST
S1RIC:	EQU	$BA    ;SERIAL CHANNEL 1 RECEIVE INTERRUPT CONTROL
 S1RIE: EQU	S1RIC*256+6	;INTERRUPT ENABLE
 S1RIR: EQU	S1RIC*256+7	;INTERRUPT REQUEST
S1EIC:	EQU	$BB    ;SERIAL CHANNEL 1 ERROR INTERRUPT CONTROL
 S1EIE: EQU	S1EIC*256+6	;INTERRUPT ENABLE
 S1EIR: EQU	S1EIC*256+7	;INTERRUPT REQUEST

CC0IC:	EQU	$BC	;CAPCON REGISTER 0 INTERRUPT CONTROL
 CC0IE: EQU	CC0IC*256+6	;INTERRUPT ENABLE FLAG
 CC0IR: EQU	CC0IC*256+7	;INTERRUPT REQUEST FLAG
CC1IC:	EQU	$BD    ;CAPCON REGISTER 1 INTERRUPT CONTROL
 CC1IE: EQU	CC1IC*256+6	;INTERRUPT ENABLE FLAG
 CC1IR: EQU	CC1IC*256+7	;INTERRUPT REQUEST FLAG
CC2IC:	EQU	$BE    ;CAPCON REGISTER 2 INTERRUPT CONTROL
 CC2IE: EQU	CC2IC*256+6	;INTERRUPT ENABLE FLAG
 CC2IR: EQU	CC2IC*256+7	;INTERRUPT REQUEST FLAG
CC3IC:	EQU	$BF    ;CAPCON REGISTER 3 INTERRUPT CONTROL
 CC3IE: EQU	CC3IC*256+6	;INTERRUPT ENABLE FLAG
 CC3IR: EQU	CC3IC*256+7	;INTERRUPT REQUEST FLAG
CC4IC:	EQU	$C0    ;CAPCON REGISTER 4 INTERRUPT CONTROL
 CC4IE: EQU	CC4IC*256+6	;INTERRUPT ENABLE FLAG
 CC4IR: EQU	CC4IC*256+7	;INTERRUPT REQUEST FLAG
CC5IC:	EQU	$C1    ;CAPCON REGISTER 5 INTERRUPT CONTROL
 CC5IE: EQU	CC5IC*256+6	;INTERRUPT ENABLE FLAG
 CC5IR: EQU	CC5IC*256+7	;INTERRUPT REQUEST FLAG
CC6IC:	EQU	$C2    ;CAPCON REGISTER 6 INTERRUPT CONTROL
 CC6IE: EQU	CC6IC*256+6	;INTERRUPT ENABLE FLAG
 CC6IR: EQU	CC6IC*256+7	;INTERRUPT REQUEST FLAG
CC7IC:	EQU	$C3    ;CAPCON REGISTER 7 INTERRUPT CONTROL
 CC7IE: EQU	CC7IC*256+6	;INTERRUPT ENABLE FLAG
 CC7IR: EQU	CC7IC*256+7	;INTERRUPT REQUEST FLAG
CC8IC:	EQU	$C4    ;CAPCON REGISTER 8 INTERRUPT CONTROL
 CC8IE: EQU	CC8IC*256+6	;INTERRUPT ENABLE FLAG
 CC8IR: EQU	CC8IC*256+7	;INTERRUPT REQUEST FLAG
CC9IC:	EQU	$C5    ;CAPCON REGISTER 9 INTERRUPT CONTROL
 CC9IE: EQU	CC9IC*256+6	;INTERRUPT ENABLE FLAG
 CC9IR: EQU	CC9IC*256+7	;INTERRUPT REQUEST FLAG
CC10IC: EQU	$C6    ;CAPCON REGISTER 10 INTERRUPT CONTROL
 CC10IE: EQU	CC10IC*256+6	;INTERRUPT ENABLE FLAG
 CC10IR: EQU	CC10IC*256+7	;INTERRUPT REQUEST FLAG
CC11IC: EQU	$C7    ;CAPCON REGISTER 11 INTERRUPT CONTROL
 CC11IE: EQU	CC11IC*256+6	;INTERRUPT ENABLE FLAG
 CC11IR: EQU	CC11IC*256+7	;INTERRUPT REQUEST FLAG
CC12IC: EQU	$C8    ;CAPCON REGISTER 12 INTERRUPT CONTROL
 CC12IE: EQU	CC12IC*256+6	;INTERRUPT ENABLE FLAG
 CC12IR: EQU	CC12IC*256+7	;INTERRUPT REQUEST FLAG
CC13IC: EQU	$C9    ;CAPCON REGISTER 13 INTERRUPT CONTROL
 CC13IE: EQU	CC13IC*256+6	;INTERRUPT ENABLE FLAG
 CC13IR: EQU	CC13IC*256+7	;INTERRUPT REQUEST FLAG
CC14IC: EQU	$CA    ;CAPCON REGISTER 14 INTERRUPT CONTROL
 CC14IE: EQU	CC14IC*256+6	;INTERRUPT ENABLE FLAG
 CC14IR: EQU	CC14IC*256+7	;INTERRUPT REQUEST FLAG
CC15IC: EQU	$CB    ;CAPCON REGISTER 15 INTERRUPT CONTROL
 CC15IE: EQU	CC15IC*256+6	;INTERRUPT ENABLE FLAG
 CC15IR: EQU	CC15IC*256+7	;INTERRUPT REQUEST FLAG

ADCIC:	EQU	$CC    ;A/D CONVERTER END OF CONVERSION INTERRUPT CONTROL
 ADCIE: EQU	ADCIC*256+6	;INTERRUPT ENABLE
 ADCIR: EQU	ADCIC*256+7	;INTERRUPT REQUEST
ADEIC:	EQU	$CD    ;A/D CONVERTER OVERRUN ERROR INTERRUPT CONTROL
 ADEIE: EQU	ADEIC*256+6	;INTERRUPT ENABLE
 ADEIR: EQU	ADEIC*256+7	;INTERRUPT REQUEST
T0IC:	EQU	$CE    ;CAPCOM TIMER 0 INTERRUPT CONTROL
 T0IE:	EQU	T0IC*256+6	;INTERRUPT ENABLE
 T0IR:	EQU	T0IC*256+7	;INTERRUPT REQUEST
T1IC:	EQU	$CF    ;CAPCOM TIMER 1 INTERRUPT CONTROL
 T1IE:	EQU	T1IC*256+6	;INTERRUPT ENABLE
 T1IR:	EQU	T1IC*256+7	;INTERRUPT REQUEST
ADCON:	EQU	$D0    ;A/D CONVERTER CONTROL
 ADST:	EQU	ADCON*256+7	;ADC START BIT
 ADBSY: EQU	ADCON*256+8	;ADC BUSY FLAG

P5:	EQU	$D1    ;PORT 5 REGISTER
 AN0:	EQU	P5*256+0	;ANALOG INPUT CHANNEL 0
 AN1:	EQU	P5*256+1	;ANALOG INPUT CHANNEL 1
 AN2:	EQU	P5*256+2	;ANALOG INPUT CHANNEL 2
 AN3:	EQU	P5*256+3	;ANALOG INPUT CHANNEL 3
 AN4:	EQU	P5*256+4	;ANALOG INPUT CHANNEL 4
 AN5:	EQU	P5*256+5	;ANALOG INPUT CHANNEL 5
 AN6:	EQU	P5*256+6	;ANALOG INPUT CHANNEL 6
 AN7:	EQU	P5*256+7	;ANALOG INPUT CHANNEL 7
 AN8:	EQU	P5*256+8	;ANALOG INPUT CHANNEL 8
 AN9:	EQU	P5*256+9	;ANALOG INPUT CHANNEL 9
;
TFR:	EQU	$D6    ;TRAP FLAG
 NMI:	EQU	TFR*256+15	;EXTERNAL NON-MASKABLE INTERRUPT
 STKOF: EQU	TFR*256+14	;STACK OVERFLOW TRAP
 STKUF: EQU	TFR*256+13	;STACK UNDERFLOW TRAP
 UNDOPC: EQU	TFR*256+7	;UNDEFINED OPCODE TRAP
 PRTFLT: EQU	TFR*256+3	;PROTECTION FAULT TRAP
 ILLOPA: EQU	TFR*256+2	;ILLEGAL WORD OPERAND ACCESS TRAP
 ILLINA: EQU	TFR*256+1	;ILLEGAL INSTRUCTION ACCESS TRAP
 ILLBUS: EQU	TFR*256+0	;ILLEGAL EXTERNAL BUS ACCESS TRAP

WDTCON: EQU	$D7    ;WATCHDOG TIMER CONTROL FOR OVERFLOW
 WDTIN: EQU	WDTCON*256+0	;WATCHDOG TIMER INPUT FREQUENCY
 WDTR:	EQU	WDTCON*256+1	;WATCHDOG TIMER RESET INDICATION FLAG
S0CON:	EQU	$D8    ;SERIAL CHANNEL 0 CONTROL
 S0STP: EQU	S0CON*256+3	;NUMBER OF STOP BITS SELECTION
 S0REN: EQU	S0CON*256+4	;RECEIVER ENABLE BIT
 S0PEN: EQU	S0CON*256+5	;PARITY CHECK ENABLE BIT
 S0FEN: EQU	S0CON*256+6	;FRAMING CHECK ENABLE BIT
 S0OEN: EQU	S0CON*256+7	;OVERRUN CHECK ENABLE BIT
 S0PE:	EQU	S0CON*256+8	;PARITY ERROR FLAG
 S0FE:	EQU	S0CON*256+9	;FRAMING ERROR FLAG
 S0OE:	EQU	S0CON*256+10	;OVERRUN ERROR FLAG
 S0LB:	EQU	S0CON*256+14	;LOOP BACK MODE ENABLE BIT
 S0R:	EQU	S0CON*256+15	;ASC0 BAUD RATE GENERATOR RUN BIT
;
S1CON:	EQU	$DC    ;SERIAL CHANNEL 1 CONTROL
 S1STP: EQU	S1CON*256+3	;NUMBER OF STOP BITS SELECTION
 S1REN: EQU	S1CON*256+4	;RECEIVER ENABLE BIT
 S1PEN: EQU	S1CON*256+5	;PARITY CHECK ENABLE BIT
 S1FEN: EQU	S1CON*256+6	;FRAMING CHECK ENABLE BIT
 S1OEN: EQU	S1CON*256+7	;OVERRUN CHECK ENABLE BIT
 S1PE:	EQU	S1CON*256+8	;PARITY ERROR FLAG
 S1FE:	EQU	S1CON*256+9	;FRAMING ERROR FLAG
 S1OE:	EQU	S1CON*256+10	;OVERRUN ERROR FLAG
 S1LB:	EQU	S1CON*256+14	;LOOP BACK MODE ENABLE BIT
 S1R:	EQU	S1CON*256+15	;ASC1 BAUD RATE GENERATOR RUN BIT
;
P2:	EQU	$E0    ;PORT 2 REGISTER
 CC0IO: EQU	P2*256+0	;CAPCOM REG 0 CAPTURE/COMPARE
 CC1IO: EQU	P2*256+1	;CAPCOM REG 1 CAPTURE/COMPARE
 CC2IO: EQU	P2*256+2	;CAPCOM REG 2 CAPTURE/COMPARE
 CC3IO: EQU	P2*256+3	;CAPCOM REG 3 CAPTURE/COMPARE
 CC4IO: EQU	P2*256+4	;CAPCOM REG 4 CAPTURE/COMPARE
 CC5IO: EQU	P2*256+5	;CAPCOM REG 5 CAPTURE/COMPARE
 CC6IO: EQU	P2*256+6	;CAPCOM REG 6 CAPTURE/COMPARE
 CC7IO: EQU	P2*256+7	;CAPCOM REG 7 CAPTURE/COMPARE
 CC8IO: EQU	P2*256+8	;CAPCOM REG 8 CAPTURE/COMPARE
 CC9IO: EQU	P2*256+9	;CAPCOM REG 9 CAPTURE/COMPARE
 CC10IO: EQU	P2*256+10	;CAPCOM REG 10 CAPTURE/COMPARE
 CC11IO: EQU	P2*256+11	;CAPCOM REG 11 CAPTURE/COMPARE
 CC12IO: EQU	P2*256+12	;CAPCOM REG 12 CAPTURE/COMPARE
 CC13IO: EQU	P2*256+13	;CAPCOM REG 13 CAPTURE/COMPARE
 CC14IO: EQU	P2*256+14	;CAPCOM REG 14 CAPTURE/COMPARE
 CC15IO: EQU	P2*256+15	;CAPCOM REG 15 CAPTURE/COMPARE

DP2:	EQU	$E1    ;PORT 2 DIRECTION CONTROL
P3:	EQU	$FFC4  ;PORT 3 REGISTER
 T0IN:	EQU	P3*128+0	;TIMER 0 COUNT INPUT
 T6OUT: EQU	P3*128+1	;TIMER 6 TOGGLE LATCH OUTPUT
 CAPIN: EQU	P3*128+2	;CAPREL REGISTER CAPTURE INPUT
 T3OUT: EQU	P3*128+3	;TIMER 3 TOGGLE LATCH OUTPUT
 T3EUD: EQU	P3*128+4	;TIMER 3 EXTERNAL UP/DOWN CONTROL INPUT
 T4IN:	EQU	P3*128+5	;TIMER 4 COUNT/GATE/RELOAD/CAPTURE INPUT
 T3IN:	EQU	P3*128+6	;TIMER 3 COUNT/GATE INPUT
 T2IN:	EQU	P3*128+7	;TIMER 2 COUNT/GATE/RELOAD/CAPTURE INPUT
 TXD1:	EQU	P3*128+8	;SERIAL CHANNEL 1 DATA/CLOCK OUT
 RXD1:	EQU	P3*128+9	;SERIAL CHANNEL 1 DATA INPUT
 TXD0:	EQU	P3*128+10	;SERIAL CHANNEL 0 DATA/CLOCK OUT
 RXD0:	EQU	P3*128+11	;SERIAL CHANNEL 0 DATA INPUT
 BHE:	EQU	P3*128+12	;BYTE HIGH ENABLE CONTROL SIGNAL FOR EXT MEM
 WR:	EQU	P3*128+13	;WRITE STROBE FOR EXTERANL DATA MEMORY
 READY: EQU	P3*128+14	;READY INPUT
 CLKOUT: EQU	P3*128+15	;SYSTEM CLOCK OUTPUT

DP3:	EQU	$E3    ;PORT 3 DIRECTION CONTROL
;
;
;****************************************************************
;
; EXAMPLES OF 80166 INSTRUCTIONS FOLLOW:
;
BIT:	EQU	$BC	;BIT ADDRESS
REG:	EQU	$9A	;GENERAL PURPOSE REGISTER
MEM:	EQU	$3412	;MEMORY LOCATION
TRAP7:	EQU	$45	;7 BIT TRAP DATA
MASK8:	EQU	$34	;8 BIT MASK DATA
DATA3:	EQU	$05	;3 BIT IMMEDIATE DATA
DATA4:	EQU	$0A	;4 BIT IMMEDIATE DATA
DATA8:	EQU	$12	;8 BIT IMMEDIATE DATA
DATA16: EQU	$7856	;16 BIT IMMEDIATE DATA
;
	ADD	R9,R6
	ADD	R9,[R2]
	ADD	R9,[R2+]
	ADD	R9,#DATA3
	ADD	REG,#DATA16
	ADD	REG,MEM
	ADD	MEM,REG

	ADDB	RL4,RH4
	ADDB	RL4,[R2]
	ADDB	RL4,[R2+]
	ADDB	RL4,#DATA3
	ADDB	REG,#DATA16
	ADDB	REG,MEM
	ADDB	MEM,REG

	ASHR	R9,R6
	ASHR	R9,#DATA4

	BCMP	REG.8,BIT.9

	BCLR	BIT.0
	BCLR	BIT.1
	BCLR	BIT.2
	BCLR	BIT.3
	BCLR	BIT.4
	BCLR	BIT.5
	BCLR	BIT.6
	BCLR	BIT.7
	BCLR	BIT.8
	BCLR	BIT.9
	BCLR	BIT.10
	BCLR	BIT.11
	BCLR	BIT.12
	BCLR	BIT.13
	BCLR	BIT.14
	BCLR	BIT.15

	BFLDL	BIT,#MASK8,#DATA8

	BXOR	REG.8,BIT.9

	CALLA	MEM
	CALLA	UC,MEM
	CALLA	Z,MEM
	CALLA	NZ,MEM
	CALLA	V,MEM
	CALLA	NV,MEM
	CALLA	N,MEM
	CALLA	NN,MEM
	CALLA	C,MEM
	CALLA	NC,MEM
	CALLA	EQ,MEM
	CALLA	NE,MEM
	CALLA	ULT,MEM
	CALLA	ULE,MEM
	CALLA	UGE,MEM
	CALLA	UGT,MEM
	CALLA	SLT,MEM
	CALLA	SLE,MEM
	CALLA	SGE,MEM
	CALLA	SGT,MEM
	CALLA	NET,MEM

	CALLI	[R9]
	CALLI	UC,[R9]
	CALLI	Z,[R9]
	CALLI	NZ,[R9]
	CALLI	V,[R9]
	CALLI	NV,[R9]
	CALLI	N,[R9]
	CALLI	NN,[R9]
	CALLI	C,[R9]
	CALLI	NC,[R9]
	CALLI	EQ,[R9]
	CALLI	NE,[R9]
	CALLI	ULT,[R9]
	CALLI	ULE,[R9]
	CALLI	UGE,[R9]
	CALLI	UGT,[R9]
	CALLI	SLT,[R9]
	CALLI	SLE,[R9]
	CALLI	SGE,[R9]
	CALLI	SGT,[R9]
	CALLI	NET,[R9]

	CALLR	REL

	CALLS	0,MEM
	CALLS	1,MEM
	CALLS	2,MEM
	CALLS	3,MEM

	CMPD1	R9,#DATA4
	CMPD1	R9,#DATA16
	CMPD1	R9,MEM

	CPL	R4

	CPLB	RL4

	DISWDT

	DIV	R4

	IDLE

	JB	BIT.10,REL

REL:	JMPA	MEM
	JMPA	UC,MEM
	JMPA	Z,MEM
	JMPA	NZ,MEM
	JMPA	V,MEM
	JMPA	NV,MEM
	JMPA	N,MEM
	JMPA	NN,MEM
	JMPA	C,MEM
	JMPA	NC,MEM
	JMPA	EQ,MEM
	JMPA	NE,MEM
	JMPA	ULT,MEM
	JMPA	ULE,MEM
	JMPA	UGE,MEM
	JMPA	UGT,MEM
	JMPA	SLT,MEM
	JMPA	SLE,MEM
	JMPA	SGE,MEM
	JMPA	SGT,MEM
	JMPA	NET,MEM

	JMPS	0,MEM
	JMPS	1,MEM
	JMPS	2,MEM
	JMPS	3,MEM

	MOV	R9,R6
	MOV	R9,#DATA4
	MOV	REG,#DATA16
	MOV	R9,[R6]
	MOV	R9,[R6+]
	MOV	[R9],R6
	MOV	[-R9],R6
	MOV	[R9],[R6]
	MOV	[R9+],[R6]
	MOV	[R9],[R6+]
	MOV	R9,[R6+#DATA16]
	MOV	[R6+#DATA16],R9
	MOV	[R9],MEM
	MOV	MEM,[R9]
	MOV	REG,MEM
	MOV	MEM,REG

	MOVB	RL5,RH3
	MOVB	RL5,#DATA4
	MOVB	REG,#DATA16
	MOVB	RL5,[R6]
	MOVB	RL5,[R6+]
	MOVB	[R9],RH3
	MOVB	[-R9],RH3
	MOVB	[R9],[R6]
	MOVB	[R9+],[R6]
	MOVB	[R9],[R6+]
	MOVB	RH3,[R6+#DATA16]
	MOVB	[R6+#DATA16],RH3
	MOVB	[R9],MEM
	MOVB	MEM,[R9]
	MOVB	REG,MEM
	MOVB	MEM,REG

	MOVBS	R9,RH3
	MOVBS	REG,MEM
	MOVBS	MEM,REG

	MOVBZ	R9,RH3
	MOVBZ	REG,MEM
	MOVBZ	MEM,REG

	PCALL	REG,MEM

	POP	REG

	PRIOR	R9,R6

	PUSH	REG

	PWRDN

	RET

	SCXT	REG,#DATA16
	SCXT	REG,MEM

	TRAP	#TRAP7
ZZZ:
	END
