;**************************************************************
;
; THE 7831x TABLE CONTAINS THE INSTRUCTIONS USED BY THE
; NEC78C31xA MICROCOMPUTER, USING THE SYNTAX DEFINED
; IN THE NEC PROGRAMMING MANUAL.
;
; NOTE: This assembler will not accept some combinations
;       of absolute names (RP0-RP7) and functional names
; (AX-HL) in the POP and PUSH instructions only.  All
; absolute or all functional names should be used.  Valid
; examples are listed in the POP and PUSH sections of this
; file.
;
; SOME SAMPLE CODE FOLLOWS:

	CPU	"7831x.TBL"	;CPU TABLE
	HOF	"INT8"		;HEX FORMAT

;Special Function Registers
;
P0:	EQU	0FF00H	;I/O port 0
P1:	EQU	0FF01H	;I/O port 1
P2:	EQU	0FF02H	;I/O port 2
P3:	EQU	0FF03H	;I/O port 3
P4:	EQU	0FF04H	;I/O port 4
P5:	EQU	0FF05H	;I/O port 5
CR00:	EQU	0FF08H	;Capture/compare register 00
CR00L:	EQU	0FF08H	;Capture/compare register 00
CR00H:	EQU	0FF09H	;Capture/compare register 00
CR01:	EQU	0FF0AH	;Capture/compare register 01
CR01L:	EQU	0FF0AH	;Capture/compare register 01
CR01H:	EQU	0FF0BH	;Capture/compare register 01
CR10:	EQU	0FF0CH	;Capture/compare register 10
CR10L:	EQU	0FF0CH	;Capture/compare register 10
CR10H:	EQU	0FF0DH	;Capture/compare register 10
CR11:	EQU	0FF0EH	;Capture/compare register 11
CR11L:	EQU	0FF0EH	;Capture/compare register 11
CR11H:	EQU	0FF0FH	;Capture/compare register 11
CRT0:	EQU	0FF10H	;Capture register 0
CRT0L:	EQU	0FF10H	;Capture register 0
CRT0H:	EQU	0FF11H	;Capture register 0
CRT1:	EQU	0FF12H	;Capture register 1
CRT1L:	EQU	0FF12H	;Capture register 1
CRT1H:	EQU	0FF13H	;Capture register 1
PWM0:	EQU	0FF14H	;PWM register 0
PWM0L:	EQU	0FF14H	;PWM register 0
PWM0H:	EQU	0FF15H	;PWM register 0
PWM1:	EQU	0FF16H	;PWM register 1
PWM1L:	EQU	0FF16H	;PWM register 1
PWM1H:	EQU	0FF17H	;PWM register 1
UDC0:	EQU	0FF1CH	;Presettable up/down counter 0
UDC0L:	EQU	0FF1CH	;Presettable up/down counter 0
UDC0H:	EQU	0FF1DH	;Presettable up/down counter 0
UDC1:	EQU	0FF1EH	;Presettable up/down counter 1
UDC1L:	EQU	0FF1EH	;Presettable up/down counter 1
UDC1H:	EQU	0FF1FH	;Presettable up/down counter 1
PM0:	EQU	0FF20H	;Port 0 mode register
PM1:	EQU	0FF21H	;Port 1 mode register
PM2:	EQU	0FF22H	;Port 2 mode register
PM3:	EQU	0FF23H	;Port 3 mode register
PM5:	EQU	0FF25H	;Port 5 mode register
PMC2:	EQU	0FF32H	;Port 2 mode control register
PMC3:	EQU	0FF33H	;Port 3 mode control register
RTPC:	EQU	0FF38H	;Real-time output port control register
P0L:	EQU	0FF3AH	;Port 0 buffer register
P0H:	EQU	0FF3BH	;Port 0 buffer register
MM:	EQU	0FF40H	;Memory expansion mode register
RFM:	EQU	0FF41H	;Refresh mode register
WDM:	EQU	0FF42H	;Watchdog timer mode register
STBC:	EQU	0FF44H	;Standby control register
TBM:	EQU	0FF46H	;Timebase mode register
INTM:	EQU	0FF48H	;External interrupt mode register
ISPR:	EQU	0FF4AH	;In-service priority register
CCW:	EQU	0FF4EH	;CPU control word
SCM:	EQU	0FF50H	;Serial communication mode register
SCC:	EQU	0FF52H	;Serial communication control register
BRG:	EQU	0FF53H	;Baud rat generator
RXB:	EQU	0FF56H	;Serial communications receive buffer
TXB:	EQU	0FF57H	;Serial communications transmit buffer
FRCC:	EQU	0FF60H	;Free-running counter control register
CPTM:	EQU	0FF64H	;Capture mode register
PWMM:	EQU	0FF66H	;PWM mode register
ADM:	EQU	0FF68H	;A/D converter mode register
ADCR:	EQU	0FF6AH	;A/D converter result register
CUIM:	EQU	0FF70H	;Count unit input mode register
UDCC0:	EQU	0FF72H	;Up/down counter control register 0
CRC:	EQU	0FF74H	;Capture/compare control register
UDCC1:	EQU	0FF7AH	;Up/down counter control register 1
TMC0:	EQU	0FF80H	;Timer 0 control register
TMC1:	EQU	0FF82H	;Timer 1 control register
TM0:	EQU	0FF88H	;Timer 0
TM0L:	EQU	0FF88H	;Timer 0
TM0H:	EQU	0FF89H	;Timer 0
MD0:	EQU	0FF8AH	;Modulus/timer register 0
MD0L:	EQU	0FF8AH	;Modulus/timer register 0
MD0H:	EQU	0FF8BH	;Modulus/timer register 0
TM1:	EQU	0FF8CH	;Timer 1
TM1L:	EQU	0FF8CH	;Timer 1
TM1H:	EQU	0FF8DH	;Timer 1
MD1:	EQU	0FF8EH	;Modulus/timer register 1
MD1L:	EQU	0FF8EH	;Modulus/timer register 1
MD1H:	EQU	0FF8FH	;Modulus/timer register 1
CRIC00: EQU	0FFC0H	;CRF00 interrupt control
CRMS00: EQU	0FFC1H	;CRF00 macroservice control
CRIC01: EQU	0FFC2H	;CRF01 interrupt control
CRIC10: EQU	0FFC4H	;CRF10 interrupt control
CRMS10: EQU	0FFC5H	;CRF10 macroservice control
CRIC11: EQU	0FFC6H	;CRF11 interrupt control
EXIC0:	EQU	0FFC8H	;EXIF0 interrupt control
EXMS0:	EQU	0FFC9H	;EXIF0 macroservice control
EXIC1:	EQU	0FFCAH	;EXIF1 interrupt control
EXMS1:	EQU	0FFCBH	;EXIF1 micro-service control
EXIC2:	EQU	0FFCCH	;EXIF2 interrupt control
EXMS2:	EQU	0FFCDH	;EXIF2 macroservice control
TMIC0:	EQU	0FFCEH	;TMF0 interrupt control
TMMS0:	EQU	0FFCFH	;TMF0 macroservice control
TMIC1:	EQU	0FFD0H	;TMF1 interrupt control
TMMS1:	EQU	0FFD1H	;TMF1 macroservice control
TMIC2:	EQU	0FFD2H	;TMF2 interrupt control
TMMS2:	EQU	0FFD3H	;TMF2 macroservice control
SEIC:	EQU	0FFDAH	;Receive error interrupt control
SRIC:	EQU	0FFDCH	;Receive interrupt control
SRMS:	EQU	0FFDDH	;Receive macroservice control
STIC:	EQU	0FFDEH	;Transmit interrupt control
STMS:	EQU	0FFDFH	;Transmit macroservice control
ADIC:	EQU	0FFE0H	;A/D converter interrupt control
ADMS:	EQU	0FFE1H	;A/D converter macroservice control
TBIC:	EQU	0FFE2H	;Timebase counter interrupt control

	ORG	0
RESET:	DWL	0080H	;External reset line
NMI:	DWL	0	;External nonmaskable interrupt
EXIF0:	DWL	0	;External interrupt 0
EXIF1:	DWL	0	;External interrupt 1
EXIF2:	DWL	0	;External interrupt 2
WDT:	DWL	0	;Watchdog timer
TBF:	DWL	0	;Timebase counter flag
TMF0:	DWL	0	;Timer flag 0
TMF1:	DWL	0	;Timer flag 1
TMF2:	DWL	0	;Timer flag 2
	DWL	0	;
	DWL	0	;
	DWL	0	;
CRF00:	DWL	0	;Up/down counter 00
CRF01:	DWL	0	;Up/down counter 01
CRF10:	DWL	0	;Up/down counter 10
CRF11:	DWL	0	;Up/down counter 11
SEF:	DWL	0	;Serial port error
SRF:	DWL	0	;Serial port receive buffer
STF:	DWL	0	;Serial port transmit buffer
ADF:	DWL	0	;A/D converter done flag
	DWL	0	;
	DWL	0	;
	DWL	0	;
	DWL	0	;
	DWL	0	;
	DWL	0	;
	DWL	0	;
	DWL	0	;
	DWL	0	;
	DWL	0	;
BRK:	DWL	0	;Break instruction
;
	DFS	0040H	;Call Table Area
;
BIT:	EQU	7H
BYTE:	EQU	56H
WORD:	EQU	3412H
SADDR:	EQU	$FE23
SADDRP: EQU	SADDR & $FFFE			;FE22
SFR:	EQU	$FF45
SFRP:	EQU	$FF45 & $FFFE			;FE44
ADDR5:	EQU	04CH

	ORG	400H
;
; 8-bit data transfer
;
	MOV	R5,#BYTE
	MOV	SADDR,#BYTE
	MOV	SFR,#BYTE
	MOV	R10,R5
	MOV	A,R5
	MOV	A,SADDR
	MOV	SADDR,A
	MOV	SADDR,SADDR
	MOV	A,SFR
	MOV	SFR,A

	MOV	A,[DE+]
	MOV	A,[HL+]
	MOV	A,[HL]
	MOV	A,[VP]
	MOV	A,[UP]

	MOV	A,[DE+A]
	MOV	A,[VP+DE]
	MOV	A,[VP+HL]

	MOV	A,[DE+BYTE]
	MOV	A,[SP+BYTE]
	MOV	A,[HL+BYTE]
	MOV	A,[VP+BYTE]

	MOV	A,WORD[DE]
	MOV	A,WORD[A]
	MOV	A,WORD[HL]
	MOV	A,WORD[B]

	MOV	[DE+],A
	MOV	[HL+],A
	MOV	[DE-],A
	MOV	[VP],A
	MOV	[UP],A

	MOV	[DE+A],A
	MOV	[VP+DE],A
	MOV	[VP+HL],A

	MOV	[DE+BYTE],A
	MOV	[UP+BYTE],A
	MOV	[VP+BYTE],A

	MOV	WORD[DE],A
	MOV	WORD[A],A
	MOV	WORD[HL],A
	MOV	WORD[B],A

	MOV	A,[SADDRP]
	MOV	[SADDRP],A
	MOV	A,ADDR16
	MOV	ADDR16,A
	MOV	PSWL,#BYTE
	MOV	PSWH,#BYTE
	MOV	PSWL,A
	MOV	PSWH,A
	MOV	A,PSWL
	MOV	A,PSWH

;
	XCH	A,R5
	XCH	R10,R5

	XCH	A,[DE+]
	XCH	A,[HL+]
	XCH	A,[HL]
	XCH	A,[VP]
	XCH	A,[UP]

	XCH	A,[DE+A]
	XCH	A,[HL+A]
	XCH	A,[VP+DE]
	XCH	A,[VP+HL]

	XCH	A,[DE+BYTE]
	XCH	A,[HL+BYTE]
	XCH	A,[UP+BYTE]

	XCH	A,WORD[DE]
	XCH	A,WORD[B]

	XCH	A,SADDR
	XCH	A,SFR
	XCH	A,[SADDRP]
	XCH	SADDR,SADDR

;
; 16-bit data transfer
;
	MOVW	RP5,#WORD
	MOVW	SADDRP,#WORD
	MOVW	SFRP,#WORD
	MOVW	RP7,RP7
	MOVW	AX,SADDRP
	MOVW	SADDRP,AX
	MOVW	SADDRP,SADDRP
	MOVW	AX,SFRP
	MOVW	SFRP,AX

	XCHW	AX,SADDRP
	XCHW	AX,SFRP
	XCHW	SADDRP,SADDRP
	XCHW	RP7,RP7

;
; 8-Bit arithmetic
;
	ADD	A,#BYTE
	ADD	SADDR,#BYTE
	ADD	SFR,#BYTE
	ADD	R10,R5
	ADD	A,SADDR
	ADD	A,SFR
	ADD	SADDR,SADDR

	ADD	A,[DE+]
	ADD	A,[HL+]
	ADD	A,[HL-]
	ADD	A,[VP]
	ADD	A,[UP]

	ADD	A,[DE+A]
	ADD	A,[VP+DE]
	ADD	A,[VP+HL]

	ADD	A,[DE+BYTE]
	ADD	A,[HL+BYTE]
	ADD	A,[UP+BYTE]
	ADD	A,[VP+BYTE]

	ADD	A,WORD[DE]
	ADD	A,WORD[A]
	ADD	A,WORD[HL]
	ADD	A,WORD[B]

	ADD	[DE+],A
	ADD	[HL+],A
	ADD	[VP],A
	ADD	[UP],A

	ADD	[DE+B],A
	ADD	[HL+B],A
	ADD	[VP+DE],A
	ADD	[VP+HL],A

	ADD	[DE+BYTE],A
	ADD	[HL+BYTE],A
	ADD	[UP+BYTE],A
	ADD	[VP+BYTE],A

	ADD	WORD[DE],A
	ADD	WORD[A],A
	ADD	WORD[HL],A
	ADD	WORD[B],A

	ADDC	 A,#BYTE
	ADDC	 SADDR,#BYTE
	ADDC	 SFR,#BYTE
	ADDC	 R10,R5
	ADDC	 A,SADDR
	ADDC	 A,SFR
	ADDC	 SADDR,SADDR

	ADDC	 A,[HL-]
	ADDC	 A,[DE]
	ADDC	 A,[UP]

	ADDC	 A,[DE+A]
	ADDC	 A,[HL+A]

	ADDC	 A,[DE+BYTE]
	ADDC	 A,[UP+BYTE]
	ADDC	 A,[VP+BYTE]

	ADDC	 A,WORD[HL]
	ADDC	 A,WORD[B]

	ADDC	 [DE],A
	ADDC	 [HL],A
	ADDC	 [VP],A
	ADDC	 [UP],A

	ADDC	 [DE+A],A
	ADDC	 [HL+A],A
	ADDC	 [DE+B],A

	ADDC	 [DE+BYTE],A
	ADDC	 [SP+BYTE],A
	ADDC	 [VP+BYTE],A

	ADDC	 WORD[DE],A
	ADDC	 WORD[A],A
	ADDC	 WORD[B],A

;
	SUB	A,#BYTE
	SUB	SADDR,#BYTE
	SUB	SFR,#BYTE
	SUB	R10,R5
	SUB	A,SADDR
	SUB	A,SFR
	SUB	SADDR,SADDR

	SUB	A,[DE+]
	SUB	A,[HL+]
	SUB	A,[VP]
	SUB	A,[UP]

	SUB	A,[DE+A]
	SUB	A,[VP+HL]

	SUB	A,[UP+BYTE]
	SUB	A,[VP+BYTE]

	SUB	A,WORD[DE]
	SUB	A,WORD[B]

	SUB	[DE+],A
	SUB	[VP],A
	SUB	[UP],A

	SUB	[DE+A],A
	SUB	[HL+A],A
	SUB	[VP+HL],A

	SUB	[DE+BYTE],A
	SUB	[UP+BYTE],A
	SUB	[VP+BYTE],A

	SUB	WORD[DE],A
	SUB	WORD[A],A
	SUB	WORD[B],A

;
	SUBC	A,#BYTE
	SUBC	SADDR,#BYTE
	SUBC	SFR,#BYTE
	SUBC	R10,R5
	SUBC	A,SADDR
	SUBC	A,SFR
	SUBC	SADDR,SADDR

	SUBC	A,[DE+]
	SUBC	A,[HL+]
	SUBC	A,[UP]

	SUBC	A,[DE+A]
	SUBC	A,[HL+A]
	SUBC	A,[DE+B]
	SUBC	A,[VP+HL]

	SUBC	A,[DE+BYTE]
	SUBC	A,[VP+BYTE]

	SUBC	A,WORD[DE]
	SUBC	A,WORD[B]

	SUBC	[DE+],A
	SUBC	[HL],A
	SUBC	[VP],A
	SUBC	[UP],A

	SUBC	[DE+A],A
	SUBC	[VP+DE],A
	SUBC	[VP+HL],A

	SUBC	[DE+BYTE],A
	SUBC	[VP+BYTE],A

	SUBC	WORD[A],A
	SUBC	WORD[HL],A

;
	AND	A,#BYTE
	AND	SADDR,#BYTE
	AND	SFR,#BYTE
	AND	R10,R5
	AND	A,SADDR
	AND	A,SFR
	AND	SADDR,SADDR

	AND	A,[HL]
	AND	A,[VP]
	AND	A,[UP]

	AND	A,[DE+A]

	AND	A,[DE+BYTE]
	AND	A,[SP+BYTE]

	AND	A,WORD[DE]
	AND	A,WORD[A]
	AND	A,WORD[HL]

	AND	[DE+],A
	AND	[HL+],A
	AND	[VP],A
	AND	[UP],A

	AND	[DE+A],A

	AND	[DE+BYTE],A
	AND	[VP+BYTE],A

	AND	WORD[DE],A
	AND	WORD[B],A

;
	OR	A,#BYTE
	OR	SADDR,#BYTE
	OR	SFR,#BYTE
	OR	R10,R5
	OR	A,SADDR
	OR	A,SFR
	OR	SADDR,SADDR

	OR	A,[DE+]
	OR	A,[HL+]
	OR	A,[DE-]

	OR	A,[DE+A]
	OR	A,[HL+A]

	OR	A,[DE+BYTE]
	OR	A,[SP+BYTE]

	OR	A,WORD[DE]
	OR	A,WORD[B]

	OR	[DE],A
	OR	[HL],A
	OR	[VP],A
	OR	[UP],A

	OR	[HL+B],A
	OR	[VP+DE],A
	OR	[VP+HL],A

	OR	[UP+BYTE],A
	OR	[VP+BYTE],A

	OR	WORD[HL],A
	OR	WORD[B],A

;
	XOR	A,#BYTE
	XOR	SADDR,#BYTE
	XOR	SFR,#BYTE
	XOR	R10,R5
	XOR	A,SADDR
	XOR	A,SFR
	XOR	SADDR,SADDR

	XOR	A,[DE+]
	XOR	A,[HL+]
	XOR	A,[DE-]
	XOR	A,[HL-]

	XOR	A,[DE+A]
	XOR	A,[HL+A]

	XOR	A,[DE+BYTE]
	XOR	A,[SP+BYTE]

	XOR	A,WORD[DE]
	XOR	A,WORD[A]

	XOR	[DE+],A

	XOR	[DE+A],A
	XOR	[HL+A],A

	XOR	[DE+BYTE],A
	XOR	[VP+BYTE],A

	XOR	WORD[DE],A
	XOR	WORD[A],A

;
	CMP	A,#BYTE
	CMP	SADDR,#BYTE
	CMP	SFR,#BYTE
	CMP	R10,R5
	CMP	A,SADDR
	CMP	A,SFR
	CMP	SADDR,SADDR

	CMP	A,[DE+]
	CMP	A,[HL+]
	CMP	A,[VP]
	CMP	A,[UP]

	CMP	A,[DE+A]
	CMP	A,[HL+A]

	CMP	A,[DE+BYTE]
	CMP	A,[VP+BYTE]

	CMP	A,WORD[DE]
	CMP	A,WORD[B]

	CMP	[DE+],A
	CMP	[UP],A

	CMP	[DE+A],A
	CMP	[VP+HL],A

	CMP	[DE+BYTE],A
	CMP	[VP+BYTE],A

	CMP	WORD[DE],A
	CMP	WORD[B],A

;
; 16-bit arithmetic
;
	ADDW	AX,#WORD
	ADDW	SADDRP,#WORD
	ADDW	SFRP,#WORD
	ADDW	RP7,RP7
	ADDW	AX,SADDRP
	ADDW	AX,SFRP
	ADDW	SADDRP,SADDRP

;
	SUBW	AX,#WORD
	SUBW	SADDRP,#WORD
	SUBW	SFRP,#WORD
	SUBW	RP7,RP7
	SUBW	AX,SADDRP
	SUBW	AX,SFRP
	SUBW	SADDRP,SADDRP

;
	CMPW	AX,#WORD
	CMPW	SADDRP,#WORD
	CMPW	SFRP,#WORD
	CMPW	RP7,RP7
	CMPW	AX,SADDRP
	CMPW	AX,SFRP
	CMPW	SADDRP,SADDRP

;
; Multiplication/Division
;
	MULU	R0
	MULU	 A
	MULU	R2
	MULU	R3
	MULU	R7

;
	DIVUW	R0
	DIVUW	 A
	DIVUW	R5
	DIVUW	R6
	DIVUW	R7

;
	MULUW	RP0
	MULUW	RP2
	MULUW	 DE
	MULUW	RP3
	MULUW	RP7

;
	DIVUX	RP0
	DIVUX	RP4
	DIVUX	RP1
	DIVUX	 DE
	DIVUX	RP3
	DIVUX	RP7

;
; Increment/Decrement
;
	INC	R0
	INC	 A
	INC	R6
	INC	R7
	INC	SADDR

;
	DEC	R0
	DEC	 A
	DEC	R2
	DEC	R7
	DEC	SADDR

;
	INCW	VP
	INCW	UP
	INCW	SADDRP
;
	DECW	VP
	DECW	SADDRP
;
	ROR	R0,7
	ROR	 A,6
	ROR	R2,5
	ROR	R7,0

;
	ROL	R0,7
	ROL	 A,6
	ROL	R6,1
	ROL	R7,0

;
	RORC	R0,7
	RORC	 A,6
	RORC	R2,5
	RORC	R7,0

;
	ROLC	R0,7
	ROLC	R7,0

;
	SHR	R0,7
	SHR	R7,0

;
	SHL	R0,7
	SHL	 A,6
	SHL	R7,0

;
	SHRW	RP0,7
	SHRW	RP4,6
	SHRW	RP1,5
	SHRW	RP5,4
	SHRW	RP2,3
	SHRW	 DE,2
	SHRW	RP3,1
	SHRW	RP7,0

;
	SHLW	RP0,7
	SHLW	RP7,0

;
	ROR4	[RP0]
	ROR4	[ DE]
	ROR4	[RP3]
	ROR4	[RP7]

;
	ROL4	[RP0]
	ROL4	[RP7]

;
; BCD adjust
;
	ADJ4

ADDR16:

;
; Bit manipulation
;
	MOV1	CY,SADDR.BIT
	MOV1	CY,SFR.BIT
	MOV1	CY,A.BIT
	MOV1	CY,X.BIT
	MOV1	CY,PSWH.BIT
	MOV1	CY,PSWL.BIT
	MOV1	SADDR.BIT,CY
	MOV1	SFR.BIT,CY
	MOV1	A.BIT,CY
	MOV1	X.BIT,CY
	MOV1	PSWH.BIT,CY
	MOV1	PSWL.BIT,CY

;
	AND1	CY,SADDR.BIT
	AND1	CY,/SADDR.BIT
	AND1	CY,SFR.BIT
	AND1	CY,/SFR.BIT
	AND1	CY,A.BIT
	AND1	CY,/A.BIT
	AND1	CY,X.BIT
	AND1	CY,/X.BIT
	AND1	CY,PSWH.BIT
	AND1	CY,/PSWH.BIT
	AND1	CY,PSWL.BIT
	AND1	CY,/PSWL.BIT

;
	OR1	CY,SADDR.BIT
	OR1	CY,/SADDR.BIT
	OR1	CY,SFR.BIT
	OR1	CY,/SFR.BIT
	OR1	CY,A.BIT
	OR1	CY,/A.BIT
	OR1	CY,X.BIT
	OR1	CY,/X.BIT
	OR1	CY,PSWH.BIT
	OR1	CY,/PSWH.BIT
	OR1	CY,PSWL.BIT
	OR1	CY,/PSWL.BIT

;
	XOR1	CY,SADDR.BIT
	XOR1	CY,SFR.BIT
	XOR1	CY,A.BIT
	XOR1	CY,X.BIT
	XOR1	CY,PSWH.BIT
	XOR1	CY,PSWL.BIT

;
	SET1	SADDR.BIT
	SET1	SFR.BIT
	SET1	A.BIT
	SET1	X.BIT
	SET1	PSWH.BIT
	SET1	PSWL.BIT

;
	CLR1	SADDR.BIT
	CLR1	SFR.BIT
	CLR1	A.BIT
	CLR1	X.BIT
	CLR1	PSWH.BIT
	CLR1	PSWL.BIT

;
	NOT1	SADDR.BIT
	NOT1	SFR.BIT
	NOT1	A.BIT
	NOT1	X.BIT
	NOT1	PSWH.BIT
	NOT1	PSWL.BIT

;
	SET1	CY
	CLR1	CY
	NOT1	CY
ADDR11:
;
; Call/Return
;
	CALL	ADDR16
	CALLF	ADDR11
	CALLT	[ADDR5]

;
	CALL	RP0
	CALL	RP2
	CALL	 DE
	CALL	RP3
	CALL	RP7

;
	CALL	[RP0]
	CALL	[RP4]
	CALL	[ DE]
	CALL	[RP3]
	CALL	[RP7]

;
	BRK
	RET
	RETI

;
;
; Stack manipulation
;
	PUSH	RP0				
	PUSH	RP1,RP0 
	PUSH	RP2,RP1,RP0		
	PUSH	RP3,RP2,RP1,RP0 	
	PUSH	RP4,RP3,RP2,RP1,RP0	
	PUSH	RP5,RP4,RP3,RP2,RP1,RP0 	
	PUSH	RP6,RP5,RP4,RP3,RP2,RP1,RP0	
	PUSH	RP7,RP6,RP5,RP4,RP3,RP2,RP1,RP0
	PUSH	 AX		
	PUSH	 BC, AX 
	PUSH	RP2, BC, AX	
	PUSH	RP3,RP2, BC, AX 
	PUSH	 VP,RP3,RP2, BC, AX	
	PUSH	 UP, VP,RP3,RP2, BC, AX 
	PUSH	 DE, UP, VP,RP3,RP2, BC, AX	
	PUSH	 HL, DE, UP, VP,RP3,RP2, BC, AX 

	PUSH	PSW		 	

	PUSHU	RP0			
	PUSHU	RP1,RP0
	PUSHU	RP2,RP1,RP0	
	PUSHU	RP3,RP2,RP1,RP0 	
	PUSHU	RP4,RP3,RP2,RP1,RP0		
	PUSHU	RP5,RP4,RP3,RP2,RP1,rP0
	PUSHU	RP6,RP5,RP4,RP3,RP2,RP1,RP0	
	PUSHU	RP7,RP6,RP5,RP4,RP3,RP2,RP1,RP0
	PUSHU	 AX			
	PUSHU	 BC, AX 		
	PUSHU	RP2, BC, AX			
	PUSHU	RP3,RP2, BC, AX 		
	PUSHU	 VP,RP3,RP2, BC, AX		
	PUSHU	PSW, VP,RP3,RP2, BC, AX 	
	PUSHU	 DE,PSW, VP,RP3,RP2, BC, AX	
	PUSHU	 HL, DE,PSW, VP,RP3,RP2, BC, AX 

;
	POP	RP0				
	POP	RP1,RP0 			
	POP	RP2,RP1,RP0			
	POP	RP3,RP2,RP1,RP0 		
	POP	RP4,RP3,RP2,RP1,RP0		
	POP	RP5,RP4,RP3,RP2,RP1,RP0 	
	POP	RP6,RP5,RP4,RP3,RP2,RP1,RP0	
	POP	RP7,RP6,RP5,RP4,RP3,RP2,RP1,RP0 
	POP	 AX				
	POP	 BC, AX 			
	POP	RP2, BC, AX			
	POP	RP3,RP2, BC, AX 		
	POP	 VP,RP3,RP2, BC, AX		
	POP	 UP, VP,RP3,RP2, BC, AX 	
	POP	 DE, UP, VP,RP3,RP2, BC, AX	
	POP	 HL, DE, UP, VP,RP3,RP2, BC, AX 

	POP	PSW		 		

	POPU	RP0				
	POPU	RP1,RP0 			
	POPU	RP2,RP1,RP0			
	POPU	RP3,RP2,RP1,RP0 		
	POPU	RP4,RP3,RP2,RP1,RP0		
	POPU	RP5,RP4,RP3,RP2,RP1,RP0 	
	POPU	RP6,RP5,RP4,RP3,RP2,RP1,RP0	
	POPU	RP7,RP6,RP5,RP4,RP3,RP2,RP1,RP0 
	POPU	 AX				
	POPU	 BC, AX 			
	POPU	RP2, BC, AX			
	POPU	RP3,RP2, BC, AX 		
	POPU	 VP,RP3,RP2, BC, AX		
	POPU	PSW, VP,RP3,RP2, BC, AX 	
	POPU	 DE,PSW, VP,RP3,RP2, BC, AX	
	POPU	 HL, DE,PSW, VP,RP3,RP2, BC, AX

;
	MOVW	SP,#WORD
	MOVW	SP,AX
	MOVW	AX,SP

	INCW	SP
	DECW	SP

;
; Unconditional jump
;
	BR	ADDR16

	BR	RP0
	BR	RP2
	BR	 DE
	BR	RP3
	BR	RP7

	BR	[RP2]
	BR	[ DE]
	BR	[RP3]
	BR	[RP7]

	BR	ADR08

;
; Conditional jump
;

	BC	ADR08
	BL	ADR08
	BNC	ADR08
	BNL	ADR08
	BZ	ADR08
	BE	ADR08
	BNZ	ADR08
ADR08:	BNE	ADR08
	BV	ADR08
	BPE	ADR08
	BNV	ADR08
	BPO	ADR08
	BN	ADR08
	BP	ADR08
	BGT	ADR08
	BGE	ADR08
	BLT	ADR08
	BLE	ADR08
	BH	ADR08
	BNH	ADR08

;
	BT	SADDR.BIT,ADR08
	BT	SFR.BIT,ADR08
	BT	A.BIT,ADR08
	BT	X.BIT,ADR08
	BT	PSWH.BIT,ADR08
	BT	PSWL.BIT,ADR08

;
	BF	SADDR.BIT,ADR08
	BF	SFR.BIT,ADR08
	BF	A.BIT,ADR08
	BF	X.BIT,ADR08
	BF	PSWH.BIT,ADR08
	BF	PSWL.BIT,ADR08

;
	BTCLR	SADDR.BIT,ADR08
	BTCLR	SFR.BIT,ADR08
	BTCLR	A.BIT,ADR08
	BTCLR	X.BIT,ADR08
	BTCLR	PSWH.BIT,ADR08
	BTCLR	PSWL.BIT,ADR08

;
	BFSET	SADDR.BIT,ADR08
	BFSET	SFR.BIT,ADR08
	BFSET	A.BIT,ADR08
	BFSET	X.BIT,ADR08
	BFSET	PSWH.BIT,ADR08
	BFSET	PSWL.BIT,ADR08

;
	DBNZ	C,ADR08
	DBNZ	B,ADR08

	DBNZ	SADDR,ADR08

;
; Context Switch
;
	BRKCS	RB0
	BRKCS	RB1
	BRKCS	RB6
	BRKCS	RB7

;
	RETCS	ADDR16

;
; String
;
	MOVM	[DE+],A
	MOVM	[DE-],A

	MOVBK	[DE+],[HL+]
	MOVBK	[DE-],[HL-]

;
	XCHM	[DE+],A
	XCHM	[DE-],A

	XCHBK	[DE+],[HL+]
	XCHBK	[DE-],[HL-]

;
	CMPME	[DE+],A
	CMPME	[DE-],A

	CMPBKE	[DE+],[HL+]
	CMPBKE	[DE-],[HL-]

;
	CMPMNE	[DE+],A
	CMPMNE	[DE-],A

	CMPBKNE [DE+],[HL+]
	CMPBKNE [DE-],[HL-]

;
	CMPMC	[DE+],A
	CMPMC	[DE-],A

	CMPBKC	[DE+],[HL+]
	CMPBKC	[DE-],[HL-]

;
	CMPMNC	[DE+],A
	CMPMNC	[DE-],A

	CMPBKNC [DE+],[HL+]
	CMPBKNC [DE-],[HL-]

;
; CPU control
;
	MOV	STBC,#BYTE
	MOV	WDM,#BYTE

	SWRS

;
	SEL	RB0
	SEL	RB1
	SEL	RB6
	SEL	RB7

;
	SEL	RB0,ALT
	SEL	RB1,ALT
	SEL	RB6,ALT
	SEL	RB7,ALT

	NOP
	EI
	DI

ZZZ:
	END

