;***************************************************************
;
; The 782xx table supports the entire NEC78K/II microcontroller
; family.
; Examples of valid 78k/II instructions follow:
;
	CPU	"782xx.TBL"	;CPU TABLE
	HOF	"INT8"		;HEX FORMAT

;Special function registers
;The following equates should be added to your source file.
;
Port0:	EQU	0FF00H		;Port 0
Port1:	EQU	0FF01H		;Port 1
Port2:	EQU	0FF02H		;Port 2
Port3:	EQU	0FF03H		;Port 3
Port4:	EQU	0FF04H		;Port 4
Port5:	EQU	0FF05H		;Port 5
Port6:	EQU	0FF06H		;Port 6
Port7:	EQU	0FF07H		;Port 7
P0L:	EQU	0FF0AH		;Port 0 buffer register low
P0H:	EQU	0FF0BH		;Port 0 buffer register high
RTPC:	EQU	0FF0CH		;Real-time output port control register
CR00:	EQU	0FF10H		;16-bit compare register
CR01:	EQU	0FF12H		;16-bit compare register
CR10:	EQU	0FF14H		;8-bit compare register
CR20:	EQU	0FF15H		;8-bit compare register
CR21:	EQU	0FF16H		;8-bit compare register
CR30:	EQU	0FF17H		;8-bit compare register
CR02:	EQU	0FF18H		;16-bit capture register
CR22:	EQU	0FF1AH		;8-bit capture register
CR11:	EQU	0FF1CH		;8-bit capture/compare register
PM0:	EQU	0FF20H		;Port 0 mode register
PM1:	EQU	0FF21H		;Port 1 mode register
PM3:	EQU	0FF23H		;Port 3 mode register
PM5:	EQU	0FF25H		;Port 5 mode register
PM6:	EQU	0FF26H		;Port 6 mode register
CRC0:	EQU	0FF30H		;Capture/compare control register 0
TOC:	EQU	0FF31H		;Timer output control register
CRC1:	EQU	0FF32H		;Capture/compare control register 1
CRC2:	EQU	0FF34H		;Capture/compare control register 2
PUO:	EQU	0FF40H		;Pull-up resistor option register
PMC3:	EQU	0FF43H		;Port 3 mode control register
TM0:	EQU	0FF50H		;16-bit timer register 0
TM1:	EQU	0FF52H		;8-bit timer register 1
TM2:	EQU	0FF54H		;8-bit timer register 2
TM3:	EQU	0FF56H		;8-bit timer register 3
PRM0:	EQU	0FF5CH		;Prescaler mode register 0
TMC0:	EQU	0FF5DH		;Timer control register 0
PRM1:	EQU	0FF5EH		;Prescaler mode register 1
TMC1:	EQU	0FF5FH		;Timer control register 1
DACS0:	EQU	0FF60H		;D/A conversion setting register 0
DACS1:	EQU	0FF61H		;D/A conversion setting register 1
ADM:	EQU	0FF68H		;A/D converter mode register
ADCR:	EQU	0FF6AH		;A/D conversion result register
PWMC:	EQU	0FF70H		;PWM control register
PWM0:	EQU	0FF72H		;PWM modulo register 0
PWM1:	EQU	0FF74H		;PWM modulo register 1
OSPC:	EQU	0FF7DH		;One-shot pulse output control register
OSIM:	EQU	0FF80H		;Clock-synchronized serial interface mode register
SBIC:	EQU	0FF82H		;Serial bus interface control register
SIO:	EQU	0FF86H		;Serial shift register
ASIM:	EQU	0FF88H		;Asynchronous serial interface mode register
ASIS:	EQU	0FF8AH		;Asynchronous serial interface status register
RXB:	EQU	0FF8CH		;Serial receive buffer : UART
TXS:	EQU	0FF8EH		;Serial transmit shift register : UART
BRGC:	EQU	0FF90H		;Baud rate generator control register
STBC:	EQU	0FFC0H		;Standby control register
MM:	EQU	0FFC4H		;Memory expansion mode register
PW:	EQU	0FFC5H		;Programmable wait control register
RFM:	EQU	0FFC6H		;Refresh mode register
IMS:	EQU	0FFCFH		;Memory size select register
IF0L:	EQU	0FFE0H		;Interrupt request flag register L
IF0H:	EQU	0FFE1H		;Interrupt request flag register H
MK0L:	EQU	0FFE4H		;Interrupt mask flag register L
MK0H:	EQU	0FFE5H		;Interrupt mask flag register H
PR0L:	EQU	0FFE8H		;Priority flag register L
PR0H:	EQU	0FFE9H		;Priority flag register H
ISM0L:	EQU	0FFECH		;Interrupt processing format flag register L
ISM0H:	EQU	0FFEDH		;Interrupt processing format flag register H
INTM0:	EQU	0FFF4H		;External interrupt mode register 0
INTM1:	EQU	0FFF5H		;External interrupt mode register 1
IST:	EQU	0FFF8H		;Interrupt status register

;Interrupts and their vector table addresses
;
RESET:	ORG	00000H
NMI:	ORG	00002H
INTP0:	ORG	00006H
INTP1:	ORG	00008H
INTP2:	ORG	0000AH
INTP3:	ORG	0000CH
INTP4:	ORG	0000EH
INTP5:	ORG	00010H
INTP6:	ORG	00012H

INTC00: ORG	00014H
INTC01: ORG	00016H
INTC10: ORG	00018H
INTC11: ORG	0001AH
INTC21: ORG	0001CH

INTSER: ORG	00020H
INTSR:	ORG	00022H
INTST:	ORG	00024H
INTCSI: ORG	00026H
INTEER: ORG	00028H
INTEPW: ORG	0002AH
BRK:	ORG	0003EH

; Examples of valid 78k/II instructions follow:
;
BIT	EQU	07H		;bit
BBYTE	EQU	056H		;byte
WWORD	EQU	03412H		;word
SADDR	EQU	0FE21H		;Short address register
SADDRP	EQU	0FE20H		;Short address register pair

SFR	EQU	0FF35H		;Special function register
SFRP	EQU	0FF34H		;Special function register pair
ADDR5	EQU	04CH		;One byte CALLT vector 004CH
ADDR11	EQU	082FH		;Two byte CALLF vector 082FH

	ORG	00080H

; 8-bit data transfer
;
	MOV	R5,#BBYTE
	MOV	D,#BBYTE
	MOV	SADDR,#BBYTE
	MOV	SFR,#BBYTE
	MOV	R7,R5
	MOV	A,R5
	MOV	A,SADDR
	MOV	SADDR,A
	MOV	A,SFR
	MOV	SFR,A
	MOV	SADDR,SADDR

	MOV	A,[DE+]
	MOV	A,[HL+]
	MOV	A,[DE-]
	MOV	A,[HL-]
	MOV	A,[DE]
	MOV	A,[HL]
	MOV	A,[DE+BBYTE]
	MOV	A,[SP+BBYTE]
	MOV	A,[HL+BBYTE]
	MOV	A,WWORD[DE]
	MOV	A,WWORD[A]
	MOV	A,WWORD[HL]
	MOV	A,WWORD[B]

	MOV	A,&[DE+]
	MOV	A,&[HL+]
	MOV	A,&[DE-]
	MOV	A,&[HL-]
	MOV	A,&[DE]
	MOV	A,&[HL]
	MOV	A,&[DE+BBYTE]
	MOV	A,&[SP+BBYTE]
	MOV	A,&[HL+BBYTE]
	MOV	A,&WWORD[DE]
	MOV	A,&WWORD[A]
	MOV	A,&WWORD[HL]
	MOV	A,&WWORD[B]

	MOV	[DE+],A
	MOV	[HL+],A
	MOV	[DE-],A
	MOV	[HL-],A
	MOV	[DE],A
	MOV	[HL],A
	MOV	[DE+BBYTE],A
	MOV	[SP+BBYTE],A
	MOV	[HL+BBYTE],A
	MOV	WWORD[DE],A
	MOV	WWORD[A],A
	MOV	WWORD[HL],A
	MOV	WWORD[B],A

	MOV	&[DE+],A
	MOV	&[HL+],A
	MOV	&[DE-],A
	MOV	&[HL-],A
	MOV	&[DE],A
	MOV	&[HL],A
	MOV	&[DE+BBYTE],A
	MOV	&[SP+BBYTE],A
	MOV	&[HL+BBYTE],A
	MOV	&WWORD[DE],A
	MOV	&WWORD[A],A
	MOV	&WWORD[HL],A
	MOV	&WWORD[B],A

	MOV	A,!WWORD
	MOV	A,&!WWORD

	MOV	!WWORD,A
	MOV	&!WWORD,A

	MOV	PSW,#BBYTE
	MOV	PSW,A
	MOV	A,PSW

	XCH	A,R5
	XCH	R7,R5

	XCH	A,[DE+]
	XCH	A,[HL]

	XCH	A,&[DE+]
	XCH	A,&[HL]

	XCH	A,[DE+BBYTE]
	XCH	A,[HL+BBYTE]

	XCH	A,&[DE+BBYTE]
	XCH	A,&[HL+BBYTE]

	XCH	A,WWORD[DE]
	XCH	A,WWORD[B]

	XCH	A,&WWORD[DE]
	XCH	A,&WWORD[B]

	XCH	A,SADDR
	XCH	A,SFR
	XCH	SADDR,SADDR

; 16-bit data transfer
;
	MOVW	AX,#WWORD
	MOVW	BC,#WWORD
	MOVW	RP2,#WWORD
	MOVW	RP3,#WWORD
	MOVW	SADDRP,#WWORD
	MOVW	SFRP,#WWORD
	MOVW	RP0,HL
	MOVW	RP3,AX
	MOVW	AX,SADDRP
	MOVW	SADDRP,AX
	MOVW	AX,SFRP
	MOVW	SFRP,AX
	MOVW	AX,[DE]
	MOVW	[HL],AX
	MOVW	AX,&[DE]
	MOVW	&[HL],AX

; 8-Bit arithmetic
;
	ADD	A,#BBYTE
	ADD	SADDR,#BBYTE
	ADD	SFR,#BBYTE
	ADD	R7,R5
	ADD	A,SADDR
	ADD	A,SFR
	ADD	SADDR,SADDR

	ADD	A,[DE+]
	ADD	A,[HL]

	ADD	A,&[DE+]
	ADD	A,&[HL+]
	ADD	A,&[HL]

	ADD	A,[DE+BBYTE]
	ADD	A,[HL+BBYTE]

	ADD	A,&[DE+BBYTE]

	ADD	A,WWORD[DE]
	ADD	A,WWORD[B]

	ADD	A,&WWORD[DE]
	ADD	A,&WWORD[B]


	CMP	A,#BBYTE
	CMP	SADDR,#BBYTE
	CMP	SFR,#BBYTE
	CMP	R7,R5
	CMP	A,SADDR
	CMP	A,SFR
	CMP	SADDR,SADDR

	CMP	A,[DE+]
	CMP	A,[HL+]
	CMP	A,[DE-]
	CMP	A,[HL-]
	CMP	A,[DE]
	CMP	A,[HL]

	CMP	A,&[DE+]
	CMP	A,&[HL+]
	CMP	A,&[DE-]
	CMP	A,&[HL-]
	CMP	A,&[DE]
	CMP	A,&[HL]

	CMP	A,[DE+BBYTE]
	CMP	A,[SP+BBYTE]
	CMP	A,[HL+BBYTE]

	CMP	A,&[DE+BBYTE]
	CMP	A,&[SP+BBYTE]
	CMP	A,&[HL+BBYTE]

	CMP	A,WWORD[DE]
	CMP	A,WWORD[A]
	CMP	A,WWORD[HL]
	CMP	A,WWORD[B]

	CMP	A,&WWORD[DE]
	CMP	A,&WWORD[A]
	CMP	A,&WWORD[HL]
	CMP	A,&WWORD[B]

; 16-bit arithmetic
;
	ADDW	AX,#WWORD
	ADDW	AX,DE
	ADDW	AX,SADDRP
	ADDW	AX,SFRP


; Multiplication/Division
;
	MULU	R0
	MULU	 A
	MULU	R2
	MULU	R3
	MULU	R4
	MULU	R5
	MULU	R6
	MULU	R7

	DIVUW	R0
	DIVUW	 A
	DIVUW	R2
	DIVUW	R3
	DIVUW	R4
	DIVUW	R5
	DIVUW	R6
	DIVUW	R7

; Increment/Decrement
;
	INC	R0
	INC	 A
	INC	R2
	INC	R3
	INC	R4
	INC	R5
	INC	R6
	INC	R7
	INC	SADDR

	DECW	AX
	DECW	BC
	DECW	DE
	DECW	HL
	DECW	RP0
	DECW	RP1
	DECW	RP2
	DECW	RP3

	ROR	R0,7
	ROR	 A,6
	ROR	R2,5
	ROR	R3,4
	ROR	R4,3
	ROR	R5,2
	ROR	R6,1
	ROR	R7,0

	SHLW	RP0,7
	SHLW	RP1,5
	SHLW	RP2,3
	SHLW	 DE,2
	SHLW	RP3,1

	ROR4	[DE]
	ROR4	[HL]
	ROR4	&[DE]
	ROR4	&[HL]

; BCD adjust
;
	ADJBA
	ADJBS
ADDR16:

; Bit manipulation
;
	MOV1	CY,SADDR.7
	MOV1	CY,SFR.7
	MOV1	CY,A.7
	MOV1	CY,X.7
	MOV1	CY,PSW.7
	MOV1	SADDR.7,CY
	MOV1	SFR.7,CY
	MOV1	A.7,CY
	MOV1	X.7,CY
	MOV1	PSW.7,CY

	AND1	CY,SADDR.7
	AND1	CY,/SADDR.7
	AND1	CY,SFR.7
	AND1	CY,/SFR.7
	AND1	CY,A.7
	AND1	CY,/A.7
	AND1	CY,X.7
	AND1	CY,/X.7
	AND1	CY,PSW.7
	AND1	CY,/PSW.7

	SET1	SADDR.7
	SET1	SFR.7
	SET1	A.7
	SET1	X.7
	SET1	PSW.7

	SET1	CY
	CLR1	CY
	NOT1	CY

; Call/Return
;
	CALL	!ADDR16
	CALL	RP0
	CALL	RP1
	CALL	RP2
	CALL	RP3
	CALL	AX
	CALL	BC
	CALL	DE
	CALL	HL

	CALLF	!ADDR11
	CALLT	[ADDR5]

	BRK
	RET
	RETI
	RETB

; Stack manipulation
;
	PUSH	RP0
	PUSH	RP1
	PUSH	RP2
	PUSH	RP3
	PUSH	AX
	PUSH	BC
	PUSH	DE
	PUSH	HL
	PUSH	PSW
	PUSH	SFR

	POP	RP0
	POP	RP1
	POP	RP2
	POP	RP3
	POP	AX
	POP	BC
	POP	DE
	POP	HL
	POP	PSW
	POP	SFR

	MOVW	SP,#WWORD
	MOVW	SP,AX
	MOVW	AX,SP

	INCW	SP
	DECW	SP

; Unconditional jump
;
	BR	!ADDR16
	BR	RP0
	BR	RP1
	BR	RP2
	BR	RP3
	BR	AX
	BR	BC
	BR	DE
	BR	HL
	BR	$ADDR08

; Conditional jump
;
ADDR08:
	BC	$ADDR08
	BL	$ADDR08
	BNC	$ADDR08
	BNL	$ADDR08
	BZ	$ADDR08
	BE	$ADDR08
	BNZ	$ADDR08
	BNE	$ADDR08

	BT	SADDR.7,$ADDR08
	BT	SFR.7,$ADDR08
	BT	A.7,$ADDR08
	BT	X.7,$ADDR08
	BT	PSW.7,$ADDR08

	BF	SADDR.7,$ADDR08
	BF	SFR.7,$ADDR08
	BF	A.7,$ADDR08
	BF	X.7,$ADDR08
	BF	PSW.7,$ADDR08

	BTCLR	SADDR.7,$ADDR08
	BTCLR	SFR.7,$ADDR08
	BTCLR	A.7,$ADDR08
	BTCLR	X.7,$ADDR08
	BTCLR	PSW.7,$ADDR08

ADDR09:
	DBNZ	C,$ADDR09
	DBNZ	B,$ADDR09
	DBNZ	SADDR,$ADDR09

; CPU control
;
	MOV	STBC,#BBYTE

	SEL	RB0
	SEL	RB1
	SEL	RB2
	SEL	RB3

	NOP
	EI
	DI
ZZZ:
	END
