;***********************************************************
; THIS TABLE SUPPORTS THE MOTOROLA M68HC16 MICROCONTROLLER
; FAMILY, ALSO KNOWN AS CPU16.
;
	CPU	"68HC16.TBL"	;CPU DECLARATION
	HOF	"MOT16" 	;HEX FORMAT (S28)

; NOTE!  LABELS AND WORD DATA SHOULD BEGIN
;	 AT AN EVEN ADDRESS.  TO INSURE THIS,
; USE THE ALIGN DIRECTIVE.
; EXAMPLE:
	ALGN	2		;ALIGN CODE

; NOTE!  THE ASSEMBLER WILL AUTOMATICALLY SELECT THE
;	 SHORTEST FORM POSSIBLE FOR THE EXTENDED,
; INDEXED, AND IMMEDIATE INSTRUCTIONS.	HOWEVER,
; THE USER MAY SPECIFY 8 OR 16-BIT ADDRESSING USING A
; < OR > RESPECTIVELY.
;

; NOTE!  LIKE OTHER 68HC16 ASSEMBLERS, 68HC16.TBL
;	 SUPPORTS A PAGE OPERAND IN THE IMMEDIATE
; ADDRESSING MODE.  THE PAGE OPERAND PLACES BITS 16-19
; OF THE EXPRESSION IN BIT LOCATIONS 0-4 RESPECTIVELY.
; THIS CAN ALSO BE DONE BY SHIFTING THE EXPRESSION
; 16 BITS RIGHT.
; EXAMPLES:
;	ADCA	#PAGE(IMM20)		;7303
;	ADCA	#IMM20>>16		;7303
;	ADCA	#IMM20/$10000		;7303

;***********************************************************
; THIS IS A TABLE OF EQUATES FOR THE 68HC16 REGISTERS
;
; SIM MODULE REGISTERS
;
SIMMCR: EQU	$FA00	;SIM MODULE CONFIGURATION REG
SIMTR:	EQU	$FA02	;SYSTEM INTEGRATION TEST REG
SYNCR:	EQU	$FA04	;CLOCK SYNTHESIZER CONTROL REG
RSR:	EQU	$FA07	;RESET STATUS REG
SIMTRE: EQU	$FA08	;SYSTEM INTEGRATION TEST REG (E CLOCK)
PORTE0: EQU	$FA11	;PORTE DATA REG (SAME DATA AS PORTE1)
PORTE1: EQU	$FA13	;PORTE DATA REG (SAME DATA AS PORTE0)
DDRE:	EQU	$FA15	;PORTE DATA DIRECTION REG
PEPAR:	EQU	$FA17	;PORTE PIN ASSIGNMENT REG
PORTF0: EQU	$FA19	;PORT F DATA REG (SAME DATA AS PORTF1)
PORTF1: EQU	$FA1B	;PORT F DATA REG (SAME DATA AS PORTF0)
DDRF:	EQU	$FA1D	;PORT F DATA DIRECTION REG
PFPAR:	EQU	$FA1F	;PORT F PIN ASSIGNMENT REG
SYPCR:	EQU	$FA21	;SYSTEM PROTECTION CONTROL REG
PICR:	EQU	$FA22	;PERIODIC INTERRUPT CONTROL REG
PITR:	EQU	$FA24	;PERIODIC INTERRUPT TIMING REG
SWSR:	EQU	$FA27	;SOFTWARE SERVICE REG
TSTMSRA: EQU	$FA30	;MASTER SHIFT REG A
TSTMSRB: EQU	$FA32	;MASTER SHIFT REG B
TSTSC:	EQU	$FA34	;TEST MODULE SHIFT COUNT
TSTRC:	EQU	$FA36	;TEST MODULE REPETITION COUNT
CREG:	EQU	$FA38	;TEST SUBMODULE CONTROL REG
DREG:	EQU	$FA3A	;DISTRIBUTED REG
CSPDR:	EQU	$FA41	;PORT C DATA REG
CSPAR0: EQU	$FA44	;CHIP-SELECT PIN ASSIGNMENT REG 0
CSPAR1: EQU	$FA46	;CHIP-SELECT PIN ASSIGNMENT REG 1
CSBARBT: EQU	$FA48	;CHIP-SELECT BOOT BASE ADDRESS REG
CSORBT: EQU	$FA4A	;CHIP-SELECT BOOT OPTION REG
CSBAR0: EQU	$FA4C	;CHIP-SELECT 0 BASE ADDRESS REG
CSOR0:	EQU	$FA4E	;CHIP-SELECT 0 OPTION REG
CSBAR1: EQU	$FA50	;CHIP-SELECT 1 BASE ADDRESS REG
CSOR1:	EQU	$FA52	;CHIP-SELECT 1 OPTION REG
CSBAR2: EQU	$FA54	;CHIP-SELECT 2 BASE ADDRESS REG
CSOR2:	EQU	$FA56	;CHIP-SELECT 2 OPTION REG
CSBAR3: EQU	$FA58	;CHIP-SELECT 3 BASE ADDRESS REG
CSOR3:	EQU	$FA5A	;CHIP-SELECT 3 OPTION REG
CSBAR4: EQU	$FA5C	;CHIP-SELECT 4 BASE ADDRESS REG
CSOR4:	EQU	$FA5E	;CHIP-SELECT 4 OPTION REG
CSBAR5: EQU	$FA60	;CHIP-SELECT 5 BASE ADDRESS REG
CSOR5:	EQU	$FA62	;CHIP-SELECT 5 OPTION REG
CSBAR6: EQU	$FA64	;CHIP-SELECT 6 BASE ADDRESS REG
CSOR6:	EQU	$FA66	;CHIP-SELECT 6 OPTION REG
CSBAR7: EQU	$FA68	;CHIP-SELECT 7 BASE ADDRESS REG
CSOR7:	EQU	$FA6A	;CHIP-SELECT 7 OPTION REG
CSBAR8: EQU	$FA6C	;CHIP-SELECT 8 BASE ADDRESS REG
CSOR8:	EQU	$FA6E	;CHIP-SELECT 8 OPTION REG
CSBAR9: EQU	$FA70	;CHIP-SELECT 9 BASE ADDRESS REG
CSOR9:	EQU	$FA72	;CHIP-SELECT 9 OPTION REG
CSBAR10: EQU	$FA74	;CHIP-SELECT 10 BASE ADDRESS REG
CSOR10: EQU	$FA76	;CHIP-SELECT 10 OPTION REG
;
; SRAM MODULE REGISTERS
;
RAMMCR: EQU	$FB00	;RAM MODULE CONFIGURATION REG
RAMTST: EQU	$FB02	;RAM TEST REG
RAMBAH: EQU	$FB04	;RAM BASE ADDRESS HIGH REG
RAMBAL: EQU	$FB06	;RAM BASE ADDRESS LOW REG
;
; QSM ADDRESS MAP
;
QMCR:	EQU	$FC00	;QSM MODULE CONFIGURATION REG
QTEST:	EQU	$FC02	;QSM TEST REG
QILR:	EQU	$FC04	;QSM INTERRUPT LEVELS REG
QIVR:	EQU	$FC05	;QSM INTERRUPT VECTOR REG
SCCR0:	EQU	$FC08	;SCI CONTROL REG 0
SCCR1:	EQU	$FC0A	;SCI CONTROL REG 1
SCSR:	EQU	$FC0C	;SCI STATUS REG
SCDR:	EQU	$FC0E	;SCI DATA REG (FULL WORD, NOT LAST 8 BITS)
QPDR:	EQU	$FC15	;QSM PORT DATA REG
QPAR:	EQU	$FC16	;QSM PIN ASSIGNMENT REG
QDDR:	EQU	$FC17	;QSM DATA DIRECTION REG
SPCR0:	EQU	$FC18	;QSPI CONTROL REG 0
SPCR1:	EQU	$FC1A	;QSPI CONTROL REG 1
SPCR2:	EQU	$FC1C	;QSPI CONTROL REG 2
SPCR3:	EQU	$FC1E	;QSPI CONTROL REG 3
SPSR:	EQU	$FC1F	;QSPI STATUS REG
RR0:	EQU	$FD00	;SPI REC.RAM 0
RR1:	EQU	$FD02	;SPI REC.RAM 1
RR2:	EQU	$FD04	;SPI REC.RAM 2
RR3:	EQU	$FD06	;SPI REC.RAM 3
RR4:	EQU	$FD08	;SPI REC.RAM 4
RR5:	EQU	$FD0A	;SPI REC.RAM 5
RR6:	EQU	$FD0C	;SPI REC.RAM 6
RR7:	EQU	$FD0E	;SPI REC.RAM 7
RR8:	EQU	$FD00	;SPI REC.RAM 8
RR9:	EQU	$FD02	;SPI REC.RAM 9
RRA:	EQU	$FD04	;SPI REC.RAM A
RRB:	EQU	$FD06	;SPI REC.RAM B
RRC:	EQU	$FD08	;SPI REC.RAM C
RRD:	EQU	$FD0A	;SPI REC.RAM D
RRE:	EQU	$FD0C	;SPI REC.RAM E
RRF:	EQU	$FD0E	;SPI REC.RAM F
TR0:	EQU	$FD20	;SPI TXD.RAM 0
TR1:	EQU	$FD22	;SPI TXD.RAM 1
TR2:	EQU	$FD24	;SPI TXD.RAM 2
TR3:	EQU	$FD26	;SPI TXD.RAM 3
TR4:	EQU	$FD28	;SPI TXD.RAM 4
TR5:	EQU	$FD2A	;SPI TXD.RAM 5
TR6:	EQU	$FD2C	;SPI TXD.RAM 6
TR7:	EQU	$FD2E	;SPI TXD.RAM 7
TR8:	EQU	$FD30	;SPI TXD.RAM 8
TR9:	EQU	$FD32	;SPI TXD.RAM 9
TRA:	EQU	$FD34	;SPI TXD.RAM A
TRB:	EQU	$FD36	;SPI TXD.RAM B
TRC:	EQU	$FD38	;SPI TXD.RAM C
TRD:	EQU	$FD3A	;SPI TXD.RAM D
TRE:	EQU	$FD3C	;SPI TXD.RAM E
TRF:	EQU	$FD3E	;SPI TXD.RAM F
CR0:	EQU	$FD40	;SPI CMD.RAM 0
CR1:	EQU	$FD41	;SPI CMD.RAM 1
CR2:	EQU	$FD42	;SPI CMD.RAM 2
CR3:	EQU	$FD43	;SPI CMD.RAM 3
CR4:	EQU	$FD44	;SPI CMD.RAM 4
CR5:	EQU	$FD45	;SPI CMD.RAM 5
CR6:	EQU	$FD46	;SPI CMD.RAM 6
CR7:	EQU	$FD47	;SPI CMD.RAM 7
CR8:	EQU	$FD48	;SPI CMD.RAM 8
CR9:	EQU	$FD49	;SPI CMD.RAM 9
CRA:	EQU	$FD4A	;SPI CMD.RAM A
CRB:	EQU	$FD4B	;SPI CMD.RAM B
CRC:	EQU	$FD4C	;SPI CMD.RAM C
CRD:	EQU	$FD4D	;SPI CMD.RAM D
CRE:	EQU	$FD4E	;SPI CMD.RAM E
CRF:	EQU	$FD4F	;SPI CMD.RAM F
;
; GPT MODULE REGISTERS
;
GPTMCR: EQU	$F900	;GPT MODULE CONFIGURATION REG
GPTMTR: EQU	$F902	;GPT MODULE TEST REG (RESERVED)
ICR:	EQU	$F904	;GPT INTERRUPT CONFIGURATION REG
PDDR:	EQU	$F906	;PARALLEL DATA DIRECTION REG
GPTPDR: EQU	$F907	;PARALLEL DATA REG
OC1M:	EQU	$F908	;OC1 ACTION MASK REG
OC1D:	EQU	$F909	;OC1 ACTION DATA REG
TCNT:	EQU	$F90A	;TIMER COUNTER REG
PACTL:	EQU	$F90C	;PULSE ACCUMULATOR CONTROL REG
PACNT:	EQU	$F90D	;PULSE ACCUMULATOR COUNTER
TIC1:	EQU	$F90E	;INPUT CAPTURE REG 1
TIC2:	EQU	$F910	;INPUT CAPTURE REG 2
TIC3:	EQU	$F912	;INPUT CAPTURE REG 3
TOC1:	EQU	$F914	;OUTPUT COMPARE REG 1
TOC2:	EQU	$F916	;OUTPUT COMPARE REG 2
TOC3:	EQU	$F918	;OUTPUT COMPARE REG 3
TOC4:	EQU	$F91A	;OUTPUT COMPARE REG 4
TI4O5:	EQU	$F91C	;INPUT CAPTURE 4 OR OUTPUT COMPARE 5
TCTL1:	EQU	$F91E	;TIMER CONTROL REG 1
TCTL2:	EQU	$F91F	;TIMER CONTROL REG 2
TMSK1:	EQU	$F920	;TIMER INTERRUPT MASK REG 1
TMSK2:	EQU	$F921	;TIMER INTERRUPT MASK REG 2
TFLG1:	EQU	$F922	;TIMER INTERRUPT FLAG REG 1
TFLG2:	EQU	$F923	;TIMER INTERRUPT FLAG REG 2
CFORC:	EQU	$F924	;COMPARE FORCE REG
PWMC:	EQU	$F924	;PWM CONTROL REG
PWMA:	EQU	$F926	;PWM REG A
PWMB:	EQU	$F927	;PWM REG B
PWMCNT: EQU	$F928	;PWM COUNTER REG
PWMBUFA: EQU	$F92A	;PWM BUFFER REG A
PWMBUFB: EQU	$F92B	;PWM BUFFER REG B
PRESCL: EQU	$F92C	;GPT PRESCALER
;
; ADC MODULE REGISTERS
;
ADCMCR: EQU	$F700	;ADC MODULE CONFIGURATION REG
ADTEST: EQU	$F702	;ADC TEST REG
ADCPDR: EQU	$F706	;ADC PORT DATA REG
ADCTL0: EQU	$F70A	;A/D CONTROL REG 0
ADCTL1: EQU	$F70C	;A/D CONTROL REG 1
ADSTAT: EQU	$F70E	;ADC STATUS REG
RJURR0: EQU	$F710	;RIGHT JUSTIFIED UNSIGNED RESULT REG 0
RJURR1: EQU	$F712	;RIGHT JUSTIFIED UNSIGNED RESULT REG 1
RJURR2: EQU	$F714	;RIGHT JUSTIFIED UNSIGNED RESULT REG 2
RJURR3: EQU	$F716	;RIGHT JUSTIFIED UNSIGNED RESULT REG 3
RJURR4: EQU	$F718	;RIGHT JUSTIFIED UNSIGNED RESULT REG 4
RJURR5: EQU	$F71A	;RIGHT JUSTIFIED UNSIGNED RESULT REG 5
RJURR6: EQU	$F71C	;RIGHT JUSTIFIED UNSIGNED RESULT REG 6
RJURR7: EQU	$F71E	;RIGHT JUSTIFIED UNSIGNED RESULT REG 7
LJSRR0: EQU	$F720	;LEFT JUSTIFIED SIGNED RESULT REG 0
LJSRR1: EQU	$F722	;LEFT JUSTIFIED SIGNED RESULT REG 1
LJSRR2: EQU	$F724	;LEFT JUSTIFIED SIGNED RESULT REG 2
LJSRR3: EQU	$F726	;LEFT JUSTIFIED SIGNED RESULT REG 3
LJSRR4: EQU	$F728	;LEFT JUSTIFIED SIGNED RESULT REG 4
LJSRR5: EQU	$F72A	;LEFT JUSTIFIED SIGNED RESULT REG 5
LJSRR6: EQU	$F72C	;LEFT JUSTIFIED SIGNED RESULT REG 6
LJSRR7: EQU	$F72E	;LEFT JUSTIFIED SIGNED RESULT REG 7
LJURR0: EQU	$F730	;LEFT JUSTIFIED UNSIGNED RESULT REG 0
LJURR1: EQU	$F732	;LEFT JUSTIFIED UNSIGNED RESULT REG 1
LJURR2: EQU	$F734	;LEFT JUSTIFIED UNSIGNED RESULT REG 2
LJURR3: EQU	$F736	;LEFT JUSTIFIED UNSIGNED RESULT REG 3
LJURR4: EQU	$F738	;LEFT JUSTIFIED UNSIGNED RESULT REG 4
LJURR5: EQU	$F73A	;LEFT JUSTIFIED UNSIGNED RESULT REG 5
LJURR6: EQU	$F73C	;LEFT JUSTIFIED UNSIGNED RESULT REG 6
LJURR7: EQU	$F73E	;LEFT JUSTIFIED UNSIGNED RESULT REG 7
;

;***********************************************************
;
	ORG	$0000	;INITIALIZE THE RESET VECTORS

	DWM	$0010	;ZK=0, SK=1, PK=0
	DWM	$0200	;PC=200 -- INITIAL PROGRAM COUNTER
	DWM	$03FE	;SP=03FE -- INITIAL STACK POINTER
	DWM	$0000	;IZ=0 -- DIRECT PAGE POINTER
;

;***********************************************************
;
	ORG	$0008	;INITIALIZE INTERRUPT/EXCEPTION VECTORS
			;IF AN INTERRUPT OCCURS REQUIRING THE USE OF
; ANY OF THESE VECTORS, PROGRAM FLOW WILL CONTINUE AT THE
; LABEL BDM: WHICH MUST BE ADDED BY THE PROGRAMMER TO
; THEIR CODE TO PUT THE PROGRAM INTO BACKGROUND DEBUG MODE
; OR SOME OTHER APPROPRIATE ROUTINE.
;
	DWM	BDM	;4    BREAKPOINT (BKPT)
	DWM	BDM	;5    BUS ERROR (BERR)
	DWM	BDM	;6    SOFTWARE INTERRUPT (SWI)
	DWM	BDM	;7    ILLEGAL INSTRUCTION
	DWM	BDM	;8    DIVIDE BY ZERO
	DWM	BDM	;9    (UNASSIGNED RESERVED)
	DWM	BDM	;10   (UNASSIGNED RESERVED)
	DWM	BDM	;11   (UNASSIGNED RESERVED)
	DWM	BDM	;12   (UNASSIGNED RESERVED)
	DWM	BDM	;13   (UNASSIGNED RESERVED)
	DWM	BDM	;14   (UNASSIGNED RESERVED)
	DWM	BDM	;15   UNINITIALIZED INTERRUPT
	DWM	BDM	;16   (UNASSIGNED RESERVED)
	DWM	BDM	;17   LEVEL 1 INTERRUPT AUTOVECTOR
	DWM	BDM	;18   LEVEL 2 INTERRUPT AUTOVECTOR
	DWM	BDM	;19   LEVEL 3 INTERRUPT AUTOVECTOR
	DWM	BDM	;20   LEVEL 4 INTERRUPT AUTOVECTOR
	DWM	BDM	;21   LEVEL 5 INTERRUPT AUTOVECTOR
	DWM	BDM	;22   LEVEL 6 INTERRUPT AUTOVECTOR
	DWM	BDM	;23   LEVEL 7 INTERRUPT AUTOVECTOR
	DWM	BDM	;24   SPURIOUS INTERRUPT
	DWM	BDM	;25   (UNASSIGNED RESERVED)
	DWM	BDM	;26   (UNASSIGNED RESERVED)
	DWM	BDM	;27   (UNASSIGNED RESERVED)
	DWM	BDM	;28   (UNASSIGNED RESERVED)
	DWM	BDM	;29   (UNASSIGNED RESERVED)
	DWM	BDM	;30   (UNASSIGNED RESERVED)
	DWM	BDM	;31   (UNASSIGNED RESERVED)
	DWM	BDM	;32   (UNASSIGNED RESERVED)
	DWM	BDM	;33   (UNASSIGNED RESERVED)
	DWM	BDM	;34   (UNASSIGNED RESERVED)
	DWM	BDM	;35   (UNASSIGNED RESERVED)
	DWM	BDM	;36   (UNASSIGNED RESERVED)
	DWM	BDM	;37   (UNASSIGNED RESERVED)
	DWM	BDM	;38   (UNASSIGNED RESERVED)
	DWM	BDM	;39   (UNASSIGNED RESERVED)
	DWM	BDM	;40   (UNASSIGNED RESERVED)
	DWM	BDM	;41   (UNASSIGNED RESERVED)
	DWM	BDM	;42   (UNASSIGNED RESERVED)
	DWM	BDM	;43   (UNASSIGNED RESERVED)
	DWM	BDM	;44   (UNASSIGNED RESERVED)
	DWM	BDM	;45   (UNASSIGNED RESERVED)
	DWM	BDM	;46   (UNASSIGNED RESERVED)
	DWM	BDM	;47   (UNASSIGNED RESERVED)
	DWM	BDM	;48   (UNASSIGNED RESERVED)
	DWM	BDM	;49   (UNASSIGNED RESERVED)
	DWM	BDM	;50   (UNASSIGNED RESERVED)
	DWM	BDM	;51   (UNASSIGNED RESERVED)
	DWM	BDM	;52   (UNASSIGNED RESERVED)
	DWM	BDM	;53   (UNASSIGNED RESERVED)
	DWM	BDM	;54   (UNASSIGNED RESERVED)
	DWM	BDM	;55   (UNASSIGNED RESERVED)
	DWM	BDM	;56   USER DEFINED INRPT VEC 1
	DWM	BDM	;57   USER DEFINED INRPT VEC 2
	DWM	BDM	;58   USER DEFINED INRPT VEC 3
	DWM	BDM	;59   USER DEFINED INRPT VEC 4
	DWM	BDM	;60   USER DEFINED INRPT VEC 5
	DWM	BDM	;61   USER DEFINED INRPT VEC 6
	DWM	BDM	;62   USER DEFINED INRPT VEC 7
	DWM	BDM	;63   USER DEFINED INRPT VEC 8
	DWM	BDM	;64   USER DEFINED INRPT VEC 9
	DWM	BDM	;65   USER DEFINED INRPT VEC 10
	DWM	BDM	;66   USER DEFINED INRPT VEC 11
	DWM	BDM	;67   USER DEFINED INRPT VEC 12
	DWM	BDM	;68   USER DEFINED INRPT VEC 13
	DWM	BDM	;69   USER DEFINED INRPT VEC 14
	DWM	BDM	;70   USER DEFINED INRPT VEC 15
	DWM	BDM	;71   USER DEFINED INRPT VEC 16
	DWM	BDM	;72   USER DEFINED INRPT VEC 17
	DWM	BDM	;73   USER DEFINED INRPT VEC 18
	DWM	BDM	;74   USER DEFINED INRPT VEC 19
	DWM	BDM	;75   USER DEFINED INRPT VEC 20
	DWM	BDM	;76   USER DEFINED INRPT VEC 21
	DWM	BDM	;77   USER DEFINED INRPT VEC 22
	DWM	BDM	;78   USER DEFINED INRPT VEC 23
	DWM	BDM	;79   USER DEFINED INRPT VEC 24
	DWM	BDM	;80   USER DEFINED INRPT VEC 25
	DWM	BDM	;81   USER DEFINED INRPT VEC 26
	DWM	BDM	;82   USER DEFINED INRPT VEC 27
	DWM	BDM	;83   USER DEFINED INRPT VEC 28
	DWM	BDM	;84   USER DEFINED INRPT VEC 29
	DWM	BDM	;85   USER DEFINED INRPT VEC 30
	DWM	BDM	;86   USER DEFINED INRPT VEC 31
	DWM	BDM	;87   USER DEFINED INRPT VEC 32
	DWM	BDM	;88   USER DEFINED INRPT VEC 33
	DWM	BDM	;89   USER DEFINED INRPT VEC 34
	DWM	BDM	;90   USER DEFINED INRPT VEC 35
	DWM	BDM	;91   USER DEFINED INRPT VEC 36
	DWM	BDM	;92   USER DEFINED INRPT VEC 37
	DWM	BDM	;93   USER DEFINED INRPT VEC 38
	DWM	BDM	;94   USER DEFINED INRPT VEC 39
	DWM	BDM	;95   USER DEFINED INRPT VEC 40
	DWM	BDM	;96   USER DEFINED INRPT VEC 41
	DWM	BDM	;97   USER DEFINED INRPT VEC 42
	DWM	BDM	;98   USER DEFINED INRPT VEC 43
	DWM	BDM	;99   USER DEFINED INRPT VEC 44
	DWM	BDM	;100  USER DEFINED INRPT VEC 45
	DWM	BDM	;101  USER DEFINED INRPT VEC 46
	DWM	BDM	;102  USER DEFINED INRPT VEC 47
	DWM	BDM	;103  USER DEFINED INRPT VEC 48
	DWM	BDM	;104  USER DEFINED INRPT VEC 49
	DWM	BDM	;105  USER DEFINED INRPT VEC 50
	DWM	BDM	;106  USER DEFINED INRPT VEC 51
	DWM	BDM	;107  USER DEFINED INRPT VEC 52
	DWM	BDM	;108  USER DEFINED INRPT VEC 53
	DWM	BDM	;109  USER DEFINED INRPT VEC 54
	DWM	BDM	;100  USER DEFINED INRPT VEC 55
	DWM	BDM	;111  USER DEFINED INRPT VEC 56
	DWM	BDM	;112  USER DEFINED INRPT VEC 57
	DWM	BDM	;113  USER DEFINED INRPT VEC 58
	DWM	BDM	;114  USER DEFINED INRPT VEC 59
	DWM	BDM	;115  USER DEFINED INRPT VEC 60
	DWM	BDM	;116  USER DEFINED INRPT VEC 61
	DWM	BDM	;117  USER DEFINED INRPT VEC 62
	DWM	BDM	;118  USER DEFINED INRPT VEC 63
	DWM	BDM	;119  USER DEFINED INRPT VEC 64
	DWM	BDM	;120  USER DEFINED INRPT VEC 65
	DWM	BDM	;121  USER DEFINED INRPT VEC 66
	DWM	BDM	;122  USER DEFINED INRPT VEC 67
	DWM	BDM	;123  USER DEFINED INRPT VEC 68
	DWM	BDM	;124  USER DEFINED INRPT VEC 69
	DWM	BDM	;125  USER DEFINED INRPT VEC 70
	DWM	BDM	;126  USER DEFINED INRPT VEC 71
	DWM	BDM	;127  USER DEFINED INRPT VEC 72
	DWM	BDM	;128  USER DEFINED INRPT VEC 73
	DWM	BDM	;129  USER DEFINED INRPT VEC 74
	DWM	BDM	;130  USER DEFINED INRPT VEC 75
	DWM	BDM	;131  USER DEFINED INRPT VEC 76
	DWM	BDM	;132  USER DEFINED INRPT VEC 77
	DWM	BDM	;133  USER DEFINED INRPT VEC 78
	DWM	BDM	;134  USER DEFINED INRPT VEC 79
	DWM	BDM	;135  USER DEFINED INRPT VEC 80
	DWM	BDM	;136  USER DEFINED INRPT VEC 81
	DWM	BDM	;137  USER DEFINED INRPT VEC 82
	DWM	BDM	;138  USER DEFINED INRPT VEC 83
	DWM	BDM	;139  USER DEFINED INRPT VEC 84
	DWM	BDM	;140  USER DEFINED INRPT VEC 85
	DWM	BDM	;141  USER DEFINED INRPT VEC 86
	DWM	BDM	;142  USER DEFINED INRPT VEC 87
	DWM	BDM	;143  USER DEFINED INRPT VEC 88
	DWM	BDM	;144  USER DEFINED INRPT VEC 89
	DWM	BDM	;145  USER DEFINED INRPT VEC 90
	DWM	BDM	;146  USER DEFINED INRPT VEC 91
	DWM	BDM	;147  USER DEFINED INRPT VEC 92
	DWM	BDM	;148  USER DEFINED INRPT VEC 93
	DWM	BDM	;149  USER DEFINED INRPT VEC 94
	DWM	BDM	;150  USER DEFINED INRPT VEC 95
	DWM	BDM	;151  USER DEFINED INRPT VEC 96
	DWM	BDM	;152  USER DEFINED INRPT VEC 97
	DWM	BDM	;153  USER DEFINED INRPT VEC 98
	DWM	BDM	;154  USER DEFINED INRPT VEC 99
	DWM	BDM	;155  USER DEFINED INRPT VEC 100
	DWM	BDM	;156  USER DEFINED INRPT VEC 101
	DWM	BDM	;157  USER DEFINED INRPT VEC 102
	DWM	BDM	;158  USER DEFINED INRPT VEC 103
	DWM	BDM	;159  USER DEFINED INRPT VEC 104
	DWM	BDM	;160  USER DEFINED INRPT VEC 105
	DWM	BDM	;161  USER DEFINED INRPT VEC 106
	DWM	BDM	;162  USER DEFINED INRPT VEC 107
	DWM	BDM	;163  USER DEFINED INRPT VEC 108
	DWM	BDM	;164  USER DEFINED INRPT VEC 109
	DWM	BDM	;165  USER DEFINED INRPT VEC 110
	DWM	BDM	;166  USER DEFINED INRPT VEC 111
	DWM	BDM	;167  USER DEFINED INRPT VEC 112
	DWM	BDM	;168  USER DEFINED INRPT VEC 113
	DWM	BDM	;169  USER DEFINED INRPT VEC 114
	DWM	BDM	;170  USER DEFINED INRPT VEC 115
	DWM	BDM	;171  USER DEFINED INRPT VEC 116
	DWM	BDM	;172  USER DEFINED INRPT VEC 117
	DWM	BDM	;173  USER DEFINED INRPT VEC 118
	DWM	BDM	;174  USER DEFINED INRPT VEC 119
	DWM	BDM	;175  USER DEFINED INRPT VEC 120
	DWM	BDM	;176  USER DEFINED INRPT VEC 121
	DWM	BDM	;177  USER DEFINED INRPT VEC 122
	DWM	BDM	;178  USER DEFINED INRPT VEC 123
	DWM	BDM	;179  USER DEFINED INRPT VEC 124
	DWM	BDM	;180  USER DEFINED INRPT VEC 125
	DWM	BDM	;181  USER DEFINED INRPT VEC 126
	DWM	BDM	;182  USER DEFINED INRPT VEC 127
	DWM	BDM	;183  USER DEFINED INRPT VEC 128
	DWM	BDM	;184  USER DEFINED INRPT VEC 129
	DWM	BDM	;185  USER DEFINED INRPT VEC 130
	DWM	BDM	;186  USER DEFINED INRPT VEC 131
	DWM	BDM	;187  USER DEFINED INRPT VEC 132
	DWM	BDM	;188  USER DEFINED INRPT VEC 133
	DWM	BDM	;189  USER DEFINED INRPT VEC 134
	DWM	BDM	;190  USER DEFINED INRPT VEC 135
	DWM	BDM	;191  USER DEFINED INRPT VEC 136
	DWM	BDM	;192  USER DEFINED INRPT VEC 137
	DWM	BDM	;193  USER DEFINED INRPT VEC 138
	DWM	BDM	;194  USER DEFINED INRPT VEC 139
	DWM	BDM	;195  USER DEFINED INRPT VEC 140
	DWM	BDM	;196  USER DEFINED INRPT VEC 141
	DWM	BDM	;197  USER DEFINED INRPT VEC 142
	DWM	BDM	;198  USER DEFINED INRPT VEC 143
	DWM	BDM	;199  USER DEFINED INRPT VEC 144
	DWM	BDM	;200  USER DEFINED INRPT VEC 145
	DWM	BDM	;201  USER DEFINED INRPT VEC 146
	DWM	BDM	;202  USER DEFINED INRPT VEC 147
	DWM	BDM	;203  USER DEFINED INRPT VEC 148
	DWM	BDM	;204  USER DEFINED INRPT VEC 149
	DWM	BDM	;205  USER DEFINED INRPT VEC 150
	DWM	BDM	;206  USER DEFINED INRPT VEC 151
	DWM	BDM	;207  USER DEFINED INRPT VEC 152
	DWM	BDM	;208  USER DEFINED INRPT VEC 153
	DWM	BDM	;209  USER DEFINED INRPT VEC 154
	DWM	BDM	;210  USER DEFINED INRPT VEC 155
	DWM	BDM	;211  USER DEFINED INRPT VEC 156
	DWM	BDM	;212  USER DEFINED INRPT VEC 157
	DWM	BDM	;213  USER DEFINED INRPT VEC 158
	DWM	BDM	;214  USER DEFINED INRPT VEC 159
	DWM	BDM	;215  USER DEFINED INRPT VEC 160
	DWM	BDM	;216  USER DEFINED INRPT VEC 161
	DWM	BDM	;217  USER DEFINED INRPT VEC 162
	DWM	BDM	;218  USER DEFINED INRPT VEC 163
	DWM	BDM	;219  USER DEFINED INRPT VEC 164
	DWM	BDM	;220  USER DEFINED INRPT VEC 165
	DWM	BDM	;221  USER DEFINED INRPT VEC 166
	DWM	BDM	;222  USER DEFINED INRPT VEC 167
	DWM	BDM	;223  USER DEFINED INRPT VEC 168
	DWM	BDM	;224  USER DEFINED INRPT VEC 169
	DWM	BDM	;225  USER DEFINED INRPT VEC 170
	DWM	BDM	;226  USER DEFINED INRPT VEC 171
	DWM	BDM	;227  USER DEFINED INRPT VEC 172
	DWM	BDM	;228  USER DEFINED INRPT VEC 173
	DWM	BDM	;229  USER DEFINED INRPT VEC 174
	DWM	BDM	;230  USER DEFINED INRPT VEC 175
	DWM	BDM	;231  USER DEFINED INRPT VEC 176
	DWM	BDM	;232  USER DEFINED INRPT VEC 177
	DWM	BDM	;233  USER DEFINED INRPT VEC 178
	DWM	BDM	;234  USER DEFINED INRPT VEC 179
	DWM	BDM	;235  USER DEFINED INRPT VEC 180
	DWM	BDM	;236  USER DEFINED INRPT VEC 181
	DWM	BDM	;237  USER DEFINED INRPT VEC 182
	DWM	BDM	;238  USER DEFINED INRPT VEC 183
	DWM	BDM	;239  USER DEFINED INRPT VEC 184
	DWM	BDM	;240  USER DEFINED INRPT VEC 185
	DWM	BDM	;241  USER DEFINED INRPT VEC 186
	DWM	BDM	;242  USER DEFINED INRPT VEC 187
	DWM	BDM	;243  USER DEFINED INRPT VEC 188
	DWM	BDM	;244  USER DEFINED INRPT VEC 189
	DWM	BDM	;245  USER DEFINED INRPT VEC 190
	DWM	BDM	;246  USER DEFINED INRPT VEC 191
	DWM	BDM	;247  USER DEFINED INRPT VEC 192
	DWM	BDM	;248  USER DEFINED INRPT VEC 193
	DWM	BDM	;249  USER DEFINED INRPT VEC 194
	DWM	BDM	;250  USER DEFINED INRPT VEC 195
	DWM	BDM	;251  USER DEFINED INRPT VEC 196
	DWM	BDM	;252  USER DEFINED INRPT VEC 197
	DWM	BDM	;253  USER DEFINED INRPT VEC 198
	DWM	BDM	;254  USER DEFINED INRPT VEC 199
	DWM	BDM	;255  USER DEFINED INRPT VEC 200


;***********************************************************
;
	ORG	$0200		;START PROGRAM AFTER INTERRUPT VECTORS
;
START:	LDAB	#$0F
	TBEK			; POINT EK TO BANK F FOR REGISTER ACCESS
	LDAB	#$00
	TBXK			; POINT XK TO BANK 0
	TBYK			; POINT YK TO BANK 0
	TBZK			; POINT ZK TO BANK 0

	LDD	#$0003		; AT RESET, THE CSBOOT BLOCK SIZE IS 512K.
	STD	CSBARBT 	; THIS LINE SETS THE BLOCK SIZE TO 64K SINCE
				; THAT IS WHAT PHYSICALLY COMES WITH THE EVB16

	LDAA	#$7F		; W=0, X=1, Y=111111
	STAA	SYNCR		; SET SYSTEM CLOCK TO 16.78 MHZ

	CLR	SYPCR		; TURN COP (SOFTWARE WATCHDOG) OFF,
				; SINCE COP IS ON AFTER RESET
;***********************************************************
;
;	INITIALIZE THE HC16'S 1K INTERNAL SRAM
; (PUT SRAM IN MEMORY MAP AT $10000, BANK 1)
; AND SET THE STACK INSIDE IT.

INITRAM:			;INITIALIZE INTERNAL SRAM AND STACK
	LDD	#$0001
	STD	RAMBAH		; STORE HIGH RAM ARRAY, BANK 1
	LDD	#$0000
	STD	RAMBAL		; STORE LOW RAM ARRAY
	CLR	RAMMCR		; ENABLE RAM

	LDAB	#$01
	TBSK			; SET SK TO BANK 1 FOR SYSTEM STACK
	LDS	#$03FE		; PUT SP AT TOP OF 1K INTERNAL SRAM

;***********************************************************
;
; START OF MAIN PROGRAM

	LDAB	#$00
	TBZK			; POINT ZK TO BANK 0
	LDZ	#$FFFE		; SET IZ=#$FFFE
OFFSET: EQU	$02		; SET OFFSET = $02
	LDAB	#$01
	TBEK			; POINT EK TO BANK 1
GO:	LDAA	#$00
	STAA	$0000		; WRITE 00 TO $10000 (EXTENDED)
	LDAA	#$FF
	STAA	OFFSET,Z	; WRITE FF TO $10000 (INDEXED)
	BRA	GO

;***********************************************************
;
; EXCEPTIONS/INTERRUPTS
;
BDM:	   BGND 		   ;EXCEPTION VECTORS POINT HERE
				   ;AND PUT THE USER IN BACKGROUND MODE

;***********************************************************
;
; MORE EXAMPLES OF 68HC16 CODE
;
EXT:	EQU	$1234
EXT20:	EQU	$12345
IND8:	EQU	$23			;8-BIT INDEX
IND16:	EQU	$2345			;16-BIT INDEX
IND20:	EQU	$23456			;20-BIT INDEX
IMM8:	EQU	$34
IMM16:	EQU	$3456
IMM20:	EQU	$34567
IXP:	EQU	$45			;OFFSET OPERAND
MSK:	EQU	$55			;MASK

	ABA

	ABX

	ABY

	ABZ

	ACE

	ACED

	ADCA	#IMM8
	ADCA	#<IMM8
	ADCA	#PAGE(IMM20)
	ADCA	       X
	ADCA	      ,X
	ADCA	     0,X
	ADCA	  IND8,X
	ADCA	 <IND8,X
	ADCA	 >IND8,X
	ADCA	 IND16,X
	ADCA	<IND16,X
	ADCA	>IND16,X
	ADCA	       Y
	ADCA	      ,Y
	ADCA	     0,Y
	ADCA	  IND8,Y
	ADCA	 <IND8,Y
	ADCA	 >IND8,Y
	ADCA	 IND16,Y
	ADCA	<IND16,Y
	ADCA	>IND16,Y
	ADCA	       Z
	ADCA	      ,Z
	ADCA	     0,Z
	ADCA	  IND8,Z
	ADCA	 <IND8,Z
	ADCA	 >IND8,Z
	ADCA	 IND16,Z
	ADCA	<IND16,Z
	ADCA	>IND16,Z
	ADCA	E,X
	ADCA	E,Y
	ADCA	E,Z
	ADCA	EXT
	ADCA	<EXT
	ADCA	>EXT

	ADCB	#IMM8
	ADCB	#<IMM8
	ADCB	#PAGE(IMM20)
	ADCB	       X
	ADCB	      ,X
	ADCB	     0,X
	ADCB	  IND8,X
	ADCB	 <IND8,X
	ADCB	 >IND8,X
	ADCB	 IND16,X
	ADCB	<IND16,X
	ADCB	>IND16,X
	ADCB	       Y
	ADCB	      ,Y
	ADCB	     0,Y
	ADCB	  IND8,Y
	ADCB	 <IND8,Y
	ADCB	 >IND8,Y
	ADCB	 IND16,Y
	ADCB	<IND16,Y
	ADCB	>IND16,Y
	ADCB	       Z
	ADCB	      ,Z
	ADCB	     0,Z
	ADCB	  IND8,Z
	ADCB	 <IND8,Z
	ADCB	 >IND8,Z
	ADCB	 IND16,Z
	ADCB	<IND16,Z
	ADCB	>IND16,Z
	ADCB	E,X
	ADCB	E,Y
	ADCB	E,Z
	ADCB	EXT

	ADCD	#IMM16
	ADCD	#<IMM16
	ADCD	#>IMM16
	ADCD	#PAGE(IMM20)
	ADCD	       X
	ADCD	      ,X
	ADCD	     0,X
	ADCD	  IND8,X
	ADCD	 <IND8,X
	ADCD	 >IND8,X
	ADCD	 IND16,X
	ADCD	<IND16,X
	ADCD	>IND16,X
	ADCD	       Y
	ADCD	      ,Y
	ADCD	     0,Y
	ADCD	  IND8,Y
	ADCD	 <IND8,Y
	ADCD	 >IND8,Y
	ADCD	 IND16,Y
	ADCD	<IND16,Y
	ADCD	>IND16,Y
	ADCD	       Z
	ADCD	      ,Z
	ADCD	     0,Z
	ADCD	  IND8,Z
	ADCD	 <IND8,Z
	ADCD	 >IND8,Z
	ADCD	 IND16,Z
	ADCD	<IND16,Z
	ADCD	>IND16,Z
	ADCD	E,X
	ADCD	E,Y
	ADCD	E,Z
	ADCD	EXT

	ADCE	#IMM16
	ADCE	#<IMM16
	ADCE	#>IMM16
	ADCE	#PAGE(IMM20)
	ADCE	       X
	ADCE	      ,X
	ADCE	     0,X
	ADCE	 IND16,X
	ADCE	<IND16,X
	ADCE	>IND16,X
	ADCE	       Y
	ADCE	      ,Y
	ADCE	     0,Y
	ADCE	 IND16,Y
	ADCE	<IND16,Y
	ADCE	>IND16,Y
	ADCE	       Z
	ADCE	      ,Z
	ADCE	     0,Z
	ADCE	 IND16,Z
	ADCE	<IND16,Z
	ADCE	>IND16,Z
	ADCE	EXT

	AIS	#IMM8
	AIS	#<IMM8
	AIS	#>IMM8
	AIS	#IMM16
	AIS	#<IMM16
	AIS	#>IMM16

	ASL	      X
	ASL	     ,X
	ASL	    0,X
	ASL	 IND8,X
	ASL	<IND8,X
	ASL	>IND8,X
	ASL	IND16,X
	ASL    <IND16,X
	ASL    >IND16,X
	ASL	      Y
	ASL	     ,Y
	ASL	    0,Y
	ASL	 IND8,Y
	ASL	<IND8,Y
	ASL	>IND8,Y
	ASL	IND16,Y
	ASL    <IND16,Y
	ASL    >IND16,Y
	ASL	      Z
	ASL	     ,Z
	ASL	    0,Z
	ASL	 IND8,Z
	ASL	<IND8,Z
	ASL	>IND8,Z
	ASL	IND16,Z
	ASL    <IND16,Z
	ASL    >IND16,Z
	ASL    EXT

	ASLA

	ASLB

	ASLD

	ASLE

	ASLM

	ASLW	       X
	ASLW	      ,X
	ASLW	     0,X
	ASLW	 IND16,X
	ASLW	<IND16,X
	ASLW	>IND16,X
	ASLW	       Y
	ASLW	      ,Y
	ASLW	     0,Y
	ASLW	 IND16,Y
	ASLW	<IND16,Y
	ASLW	>IND16,Y
	ASLW	       Z
	ASLW	      ,Z
	ASLW	     0,Z
	ASLW	 IND16,Z
	ASLW	<IND16,Z
	ASLW	>IND16,Z
	ASLW	EXT

 REL8:	BCC	REL8

	BCS	REL8

	BRSET	     0,X,#MSK,REL8
	BRSET	  IND8,X,#MSK,REL8
	BRSET	 <IND8,X,#MSK,REL8
	BRSET	 >IND8,X,#MSK,REL8
	BRSET	 IND16,X,#MSK,REL8
	BRSET	<IND16,X,#MSK,REL8
	BRSET	>IND16,X,#MSK,REL8
	BRSET	     0,Y,#MSK,REL8
	BRSET	  IND8,Y,#MSK,REL8
	BRSET	 <IND8,Y,#MSK,REL8
	BRSET	 >IND8,Y,#MSK,REL8
	BRSET	 IND16,Y,#MSK,REL8
	BRSET	<IND16,Y,#MSK,REL8
	BRSET	>IND16,Y,#MSK,REL8
	BRSET	     0,Z,#MSK,REL8
	BRSET	  IND8,Z,#MSK,REL8
	BRSET	 <IND8,Z,#MSK,REL8
	BRSET	 >IND8,Z,#MSK,REL8
	BRSET	 IND16,Z,#MSK,REL8
	BRSET	<IND16,Z,#MSK,REL8
	BRSET	>IND16,Z,#MSK,REL8
	BRSET	       0,#MSK,REL8
	BRSET	     EXT,#MSK,REL8
	BRSET	    <EXT,#MSK,REL8
	BRSET	    >EXT,#MSK,REL8

	BSET	     0,X,#MSK
	BSET	  IND8,X,#MSK
	BSET	 <IND8,X,#MSK
	BSET	 >IND8,X,#MSK
	BSET	 IND16,X,#MSK
	BSET	<IND16,X,#MSK
	BSET	>IND16,X,#MSK
	BSET	     0,Y,#MSK
	BSET	  IND8,Y,#MSK
	BSET	 <IND8,Y,#MSK
	BSET	 >IND8,Y,#MSK
	BSET	 IND16,Y,#MSK
	BSET	<IND16,Y,#MSK
	BSET	>IND16,Y,#MSK
	BSET	     0,Z,#MSK
	BSET	  IND8,Z,#MSK
	BSET	 <IND8,Z,#MSK
	BSET	 >IND8,Z,#MSK
	BSET	 IND16,Z,#MSK
	BSET	<IND16,Z,#MSK
	BSET	>IND16,Z,#MSK
	BSET	       0,#MSK
	BSET	     EXT,#MSK
	BSET	    <EXT,#MSK
	BSET	    >EXT,#MSK

	BSETW	     0,X,#MSK
	BSETW	 IND16,X,#MSK
	BSETW	<IND16,X,#MSK
	BSETW	>IND16,X,#MSK
	BSETW	     0,Y,#MSK
	BSETW	 IND16,Y,#MSK
	BSETW	<IND16,Y,#MSK
	BSETW	>IND16,Y,#MSK
	BSETW	     0,Z,#MSK
	BSETW	 IND16,Z,#MSK
	BSETW	<IND16,Z,#MSK
	BSETW	>IND16,Z,#MSK
	BSETW	       0,#MSK
	BSETW	     EXT,#MSK
	BSETW	    <EXT,#MSK
	BSETW	    >EXT,#MSK

	EDIV

	EDIVS

	EMUL

	EMULS

	JMP	REL8
	JMP	EXT
	JMP	EXT20
	JMP	       X
	JMP	      ,X
	JMP	     0,X
	JMP	 IND20,X
	JMP	<IND20,X
	JMP	>IND20,X
	JMP	       Y
	JMP	      ,Y
	JMP	     0,Y
	JMP	 IND20,Y
	JMP	<IND20,Y
	JMP	>IND20,Y
	JMP	       Z
	JMP	      ,Z
	JMP	     0,Z
	JMP	 IND20,Z
	JMP	<IND20,Z
	JMP	>IND20,Z

	JSR	REL8
	JSR	EXT
	JSR	EXT20
	JSR	       X
	JSR	      ,X
	JSR	     0,X
	JSR	 IND20,X
	JSR	<IND20,X
	JSR	>IND20,X
	JSR	       Y
	JSR	      ,Y
	JSR	     0,Y
	JSR	 IND20,Y
	JSR	<IND20,Y
	JSR	>IND20,Y
	JSR	       Z
	JSR	      ,Z
	JSR	     0,Z
	JSR	 IND20,Z
	JSR	<IND20,Z
	JSR	>IND20,Z

	LBCC	 REL8

	LBCS	 REL8

	MAC	0,0
	MAC	1,1
	MAC	-1,-1
	MAC	7,7
	MAC	-8,-8

	MOVB	IXP,X,EXT
	MOVB	EXT,IXP,X
	MOVB	EXT,$5678

	MOVW	IXP,X,EXT
	MOVW	EXT,IXP,X
	MOVW	EXT,$5678

	MUL

	PSHA

	PSHB

	PSHM	D
	PSHM	E
	PSHM	X
	PSHM	Y
	PSHM	Z
	PSHM	CCR
	PSHM	K
	PSHM	D,E,X,Y,Z,K,CCR

	PSHMAC

	XGDE

	XGDX

	XGDY

	XGDZ

	XGEX

	XGEY

	XGEZ

	END
