;***********************************************************
; THIS TABLE SUPPORTS THE MOTOROLA 68HC08 MICROCONTROLLER.
;
; THE ASSEMBLER WILL AUTOMATICALLY SELECT THE SHORTEST
; FORM OF THE ABSOLUTE AND INDEXED INSTRUCTIONS.  HOWEVER,
; THE USER MAY SPECIFY 8 OR 16-BIT ADDRESSING USING A 
; < OR > RESPECTIVELY.
;
	CPU	"68HC08.TBL"	;PROCESSOR TABLE
	HOF	"MOT8"		;HEX FORMAT

;
; Some Register Equates
;
PORTE   equ	$08     ;Port E

TSCR    equ	$20     ;Timer Status & Control Register
TDMA    equ	$21     ;Timer DMA Select Register
TCNTH   equ	$22     ;Timer Counter Register Hi
TMCNTL  equ	$23     ;Timer Counter Register Lo
TMODH   equ	$24     ;Timer Counter Modulo Register Hi
TMODL   equ	$25     ;Timer Counter Modulo Register Lo
TSCR0   equ	$26     ;Timer Channel 0 Status & Control Register
CH0RH   equ	$27     ;Timer Channel 0 Register Hi
CH0RL   equ	$28     ;Timer Channel 0 Register Lo
TSCR1   equ	$29     ;Timer Channel 1 Status & Control Register
CH1RH   equ	$2a     ;Timer Channel 1 Register Hi
CH1RL   equ	$2b     ;Timer Channel 1 Register Lo
TSCR2   equ	$2c     ;Timer Channel 2 Status & Control Register
CH2RH   equ	$2d     ;Timer Channel 2 Register Hi
CH2RL   equ	$2e     ;Timer Channel 2 Register Lo
TSCR3   equ	$2f     ;Timer Channel 3 Status & Control  Register
CH3RH   equ	$30     ;Timer Channel 3 Register Hi
CH3RL   equ	$31     ;Timer Channel 3 Register Lo

;
; Some 68HC08 instructions
;
	ORG	$200		;ORIGIN

IMM8:	EQU	$F0
DIRECT: EQU	$56

RESET:	ADC	#00H		;
	ADC	#IMM8		;
	ADC	DIRECT		;
	ADC	<DIRECT 	;
	ADC	EXTND		;
	ADC	>DIRECT 	;
	ADC	>EXTND		;
	ADC	,X		;
	ADC	0,X		;
	ADC	DIRECT,X	;
	ADC	<DIRECT,X	;
	ADC	>DIRECT,X	;
	ADC	EXTND,X 	;
	ADC	>EXTND,X	;

	AIS	#-$80		;
	AIS	#0		;
	AIS	#+$7F		;

	ASLA			;
	ASLX			;
	ASL	,X		;
	ASL	0,X		;
	ASL	DIRECT,X	;
	ASL	<DIRECT,X	;
	ASL	DIRECT,SP	;

	BCC	REL08		;

	BCLR	0,DIRECT	;
	BCLR	1,DIRECT	;
	BCLR	2,DIRECT	;
	BCLR	3,DIRECT	;
	BCLR	4,DIRECT	;
	BCLR	5,DIRECT	;
	BCLR	6,DIRECT	;
	BCLR	7,DIRECT	;

	BCS	REL08		;
	BEQ	REL08		;
	BGE	REL08		;
	BGT	REL08		;
	BHCC	REL08		;
	BHCS	REL08		;
	BHI	REL08		;
	BHS	REL08		;
	BIH	REL08		;
	BIL	REL08		;

	BIT	#00H		;
	BIT	#IMM8		;
	BIT	DIRECT		;
	BIT	<DIRECT 	;
	BIT	EXTND		;
	BIT	>DIRECT 	;
	BIT	>EXTND		;
	BIT	,X		;
	BIT	0,X		;
	BIT	DIRECT,X	;
	BIT	<DIRECT,X	;
	BIT	>DIRECT,X	;
	BIT	EXTND,X 	;
	BIT	>EXTND,X	;
	BIT	DIRECT,SP	;
	BIT	EXTND,SP	;

	BLE	REL08		;
	BLO	REL08		;
	BLS	REL08		;
	BLT	REL08		;
	BMC	REL08		;
	BMI	REL08		;
	BMS	REL08		;
	BNE	REL08		;
	BPL	REL08		;
	BRA	REL08		;

	BRCLR	0,DIRECT,REL08	;
	BRCLR	1,DIRECT,REL08	;
	BRCLR	2,DIRECT,REL08	;
	BRCLR	3,DIRECT,REL08	;
	BRCLR	4,DIRECT,REL08	;
	BRCLR	5,DIRECT,REL08	;
	BRCLR	6,DIRECT,REL08	;
	BRCLR	7,DIRECT,REL08	;

REL08:	BRN	REL08		;

	BRSET	0,DIRECT,REL08	;
	BRSET	1,DIRECT,REL08	;
	BRSET	2,DIRECT,REL08	;
	BRSET	3,DIRECT,REL08	;
	BRSET	4,DIRECT,REL08	;
	BRSET	5,DIRECT,REL08	;
	BRSET	6,DIRECT,REL08	;
	BRSET	7,DIRECT,REL08	;

	BSET	0,DIRECT	;
	BSET	1,DIRECT	;
	BSET	2,DIRECT	;
	BSET	3,DIRECT	;
	BSET	4,DIRECT	;
	BSET	5,DIRECT	;
	BSET	6,DIRECT	;
	BSET	7,DIRECT	;

	BSR	REL08		;

	CBEQ	DIRECT,REL08	;
	CBEQA	#IMM8,REL08	;
	CBEQX	#IMM8,REL08	;
	CBEQ	X+,REL08	;
	CBEQ	DIRECT,X+,REL08 ;
	CBEQ	DIRECT,SP,REL08 ;

	CLC			;

	CLI			;

	CLRA			;
	CLRX			;
	CLR	,X		;
	CLR	0,X		;
	CLR	DIRECT,X	;
	CLR	<DIRECT,X	;
	CLR	DIRECT,SP	;

	CMP	#00H		;
	CMP	#IMM8		;
	CMP	DIRECT		;
	CMP	<DIRECT 	;
	CMP	EXTND		;
	CMP	>DIRECT 	;
	CMP	>EXTND		;
	CMP	,X		;
	CMP	0,X		;
	CMP	DIRECT,X	;
	CMP	<DIRECT,X	;
	CMP	>DIRECT,X	;
	CMP	EXTND,X 	;
	CMP	>EXTND,X	;
	CMP	DIRECT,SP	;
	CMP	EXTND,SP	;

	CPHX	#EXTND		;
	CPHX	DIRECT		;

	CPX	#00H		;
	CPX	#IMM8		;
	CPX	DIRECT		;
	CPX	<DIRECT 	;
	CPX	EXTND		;
	CPX	>DIRECT 	;
	CPX	>EXTND		;
	CPX	,X		;
	CPX	0,X		;
	CPX	DIRECT,X	;
	CPX	<DIRECT,X	;
	CPX	>DIRECT,X	;
	CPX	EXTND,X 	;
	CPX	>EXTND,X	;
	CPX	DIRECT,SP	;
	CPX	EXTND,SP	;

	DAA			;

	DBNZ	DIRECT,REL09	;
	DBNZA	REL09		;
	DBNZX	REL09		;
	DBNZ	X,REL09 	;
	DBNZ	DIRECT,X,REL09	;
REL09:	DBNZ	DIRECT,SP,REL09 ;

	DIV			;

	JMP	DIRECT		;
	JMP	<DIRECT 	;
	JMP	EXTND		;
	JMP	>DIRECT 	;
	JMP	>EXTND		;
	JMP	,X		;
	JMP	0,X		;
	JMP	DIRECT,X	;
	JMP	<DIRECT,X	;
	JMP	>DIRECT,X	;
	JMP	EXTND,X 	;
	JMP	>EXTND,X	;

	JSR	DIRECT		;
	JSR	<DIRECT 	;
	JSR	EXTND		;
	JSR	>DIRECT 	;
	JSR	>EXTND		;
	JSR	,X		;
	JSR	0,X		;
	JSR	DIRECT,X	;
	JSR	<DIRECT,X	;
	JSR	>DIRECT,X	;
	JSR	EXTND,X 	;
	JSR	>EXTND,X	;

	LDA	#00H		;
	LDA	#IMM8		;
	LDA	DIRECT		;
	LDA	<DIRECT 	;
	LDA	EXTND		;
	LDA	>DIRECT 	;
	LDA	>EXTND		;
	LDA	,X		;
	LDA	0,X		;
	LDA	DIRECT,X	;
	LDA	<DIRECT,X	;
	LDA	>DIRECT,X	;
	LDA	EXTND,X 	;
	LDA	>EXTND,X	;
	LDA	DIRECT,SP	;
	LDA	EXTND,SP	;

	LDHX	#00H		;
	LDHX	#IMM8		;
	LDHX	DIRECT		;

	MOV	#IMM8,DIRECT	;
	MOV	DIRECT,DIRECT+1 ;
	MOV	X+,DIRECT	;
	MOV	DIRECT,X+	;

	MUL			;

	NOP			;

	NSA			;

	PSHA			;

	PSHH			;

	PSHX			;

	PULA			;

	PULH			;

	PULX			;

	RSP			;

	RTI			;

	RTS			;

	SEC			;

	SEI			;

	STA	DIRECT		;
	STA	<DIRECT 	;
	STA	EXTND		;
	STA	>DIRECT 	;
	STA	>EXTND		;
	STA	,X		;
	STA	0,X		;
	STA	DIRECT,X	;
	STA	<DIRECT,X	;
	STA	>DIRECT,X	;
	STA	EXTND,X 	;
	STA	>EXTND,X	;
	STA	DIRECT,SP	;
	STA	EXTND,SP	;

	STHX	DIRECT		;

	STOP			;

	STX	DIRECT		;
	STX	<DIRECT 	;
	STX	EXTND		;
	STX	>DIRECT 	;
	STX	>EXTND		;
	STX	,X		;
	STX	0,X		;
	STX	DIRECT,X	;
	STX	<DIRECT,X	;
	STX	>DIRECT,X	;
	STX	EXTND,X 	;
	STX	>EXTND,X	;
	STX	DIRECT,SP	;
	STX	EXTND,SP	;

	SWI			;

	TAP			;

	TAX			;

	TPA			;

	TSX			;

	TXA			;

	TXS			;

	WAIT			;
EXTND:

;
;Some HC08 Vectors
;
        ORG	$FFF0
;
	DWM	RESET		;INT 5 - Priority 8
	DWM	RESET		;INT 4 - Priority 7
	DWM	RESET		;INT 3 - Priority 6
	DWM	RESET		;INT 2 - Priority 5
	DWM	RESET		;INT 1 - Priority 4
	DWM	RESET		;INT 0 - Priority 3
	DWM	RESET		;SWI   - Priority 2
	DWM	RESET		;RESET - Priority 1

	END
