;***********************************************************
;
; THIS IS AN EXAMPLE PROGRAM FOR THE 6809 PROCESSOR.
; IT IS TAKEN FROM PAGE 117 OF THE MARCH 1982 ISSUE
; OF BYTE, AND AFTER ONLY FORMAT MODIFICATIONS,
; IT IS PASSED ON AS AN EXAMPLE, FREE OF CHARGE ,BY
; UNIVERSAL CROSS-ASSEMBLERS.

; NOTE! THE USER NEED NOT SPECIFY DIRECT OR EXTENDED
;	AND INDEXED 8-BIT OR INDEXED 16-BIT ADDRESSING.
; THE ASSEMBLER WILL AUTOMATICALLY SELECT THE SHORTEST
; FORM OF THE INSTRUCTION.

; NOTE! THE 6809 TABLE DOES NOT CONTAIN TRANSLATIONS FOR
;	6800 INSTRUCTIONS SUCH AS TSX, BUT THESE CAN BE
; ADDED BY THE USER.

; NOTE! MULTIBLE REGISTERS IN THE PSHS/PSHU/PULS/PULU
;	INSTRUCTIONS ARE SUPPORTED BUT USE "A,B" TO
; REPRESENT "D".
; I.E.	PULU	A,B,S,DP

	CPU	"6809.TBL"
	HOF	"MOT8"

;***********************************************************
;
; HALF YEAR CLOCK FOR THE THE COLOR COMPUTER
;
;		 WILLIAM BARDEN JR.
;		   28122 ORSOLA
;	      MISSION VIEJO, CA 92692

; CLOCK I/O HANDLER.  READS IN 3 CLOCK COUNTS

	ORG	3F00H
BUFFER: EQU	3FF0H

CLOCK:	LDY	#3		;SCAN #
	LDU	#BUFFER
CLK010: LDA	#2		;2 TO A
	STA	0FF20H		;STROBE IN NEXT COUNT
	LDA	#38		;1.9 CYCLE COUNT
	BSR	DELAY		;1.9 60 HZ CYCLES
	STA	0FF20H		;START SERIAL
	BSR	GETSER		;GET SERIAL IN
	BNE	CLK010		;GO IF INVALID
	LDA	#2		;DELAY COUNT
	BSR	DELAY		;DELAY 1/10 CYCLE
	BSR	GETSER		;GET SERIAL IN BIT
	BNE	CLK010		;GO IF INVALID
CLK020: BSR	GETSER		;GET SERIAL IN BIT
	BEQ	CLK020		;GO IF 0
	LDA	#30		;1+1/2 CYCLE COUNT
	BSR	DELAY		;DELAY 1+1/2 CYCLE
	BSR	INPUT		;READ CLOCK COUNT
	LEAU	-2,U		;RESET PNTR
	TFR	Y,D		;SCN # NOW IN B
	EORB	1,U		;TEST SCN #
	ANDB	#3		;MASK OUT DIGIT
	BNE	CLK010		;GO IF NOT PROPER SCN #
	LEAU	2,U		;POINT TO NEXT TWO BYTES
	LEAY	-1,Y		;DECREMENT SCN #
	BNE	CLK010		;GO IF NOT DONE
	RTS			;RETURN
GETSER: LDA    0FF22H		;GET SERIAL BIT
	ANDA   #1		;TEST
	RTS
;
; INPUT. INPUTS 14 BITS AND STORES IN TWO BYTES
;  ENTRY:  BUFFER ADDRESS IN U
;  EXIT:   2 BYTES STORED IN BUFFER, U UPDATED
;
INPUT:	BSR	INPUA		;GO TWICE
INPUA:	CLRA			;0 TO A
	STA	,U		;CLEAR BYTE
	LDB	#8		;FOR 8 BITS
INP010: LDA	0FF22H		;GET BIT
	LSRA			;OUT TO C
	ROR	,U		;MERGE IN USER STACK
	LDA	#20		;1 CYCLE COUNT
	BSR	DELAY		;DELAY 1 CYCLE
	DECB			;DECREMENT ITERATION COUNT
	BNE	INP010		;GO IF NOT 8
	LEAU	1,U		;POINT TO NEXT STACK BYTE
	RTS			;RETURN (AGAIN OR CLOCK)
;
; DELAY. DELAYS IN MULTIPLES OF .8333 MS
; ENTRY:  COUNT IN A
; EXIT:   AFTER DELAY
;
DELAY:	LDX	#92		;FINAGLE FACTOR
DEL010: LEAX	-1,X		;DECREMENT X
	BNE	DEL010		;GO IF NOT 0
	DECA			;DECREMENT MAJOR COUNT
	BNE	DELAY		;GO IF NOT 0
	RTS			;RETURN
	END
