;***********************************************************
; THIS TABLE SUPPORTS THE MOTOROLA MC6805 AND THE HITACHI
; HD6305 AND HD63L05 MICROCONTROLLERS.	THE EXTRA
; INSTRUCTIONS FOR HD6305 AND MC68HC05 ARE CLEARLY MARKED AT
; THE END OF 6805.TBL, AND MAY BE REMOVED BY THE USER.

; THE ASSEMBLER WILL AUTOMATICALLY SELECT THE SHORTEST
; FORM OF THE ABSOLUTE AND INDEXED INSTRUCTIONS.  HOWEVER,
; THE USER MAY SPECIFY 8 OR 16-BIT ADDRESSING USING A
; < OR > RESPECTIVELY.
;
	CPU	"6805.TBL"	; CPU TABLE
	HOF	"MOT8"		; HEX OUTPUT FORMAT (S19)

; EXAMPLES OF 6805 INSTRUCTIONS FOLLOW:
;
IMM8:	EQU	-10H
DIRECT: EQU	56H
	ORG	$1000

	ADC	#$F0		
	ADC	56H		
	ADC	0123H		
	ADC	0,X 		
	ADC	56H,X 		
	ADC	0123H,X 	
	ADC	<56H		
	ADC	>0123H		
	ADC	<56H,X 		
	ADC	>0123H,X 	

REL08:	BCS	REL08		
	BEQ	REL08		
	BHCC	REL08		
	BHCS	REL08		
	BHI	REL08		
	BHS	REL08		
	BIH	REL08		
	BIL	REL08		

	BIT	#IMM8		
	BIT	DIRECT		
	BIT	EXTND		
	BIT	0,X		
	BIT	DIRECT,X	
	BIT	EXTND,X 	

	BLO	REL08		
	BLS	REL08		
	BMC	REL08		
	BMI	REL08		
	BMS	REL08		
	BNE	REL08		
	BPL	REL08		
	BRA	REL08		

	BRCLR	0,DIRECT,REL08	
	BRCLR	1,DIRECT,REL08	
	BRCLR	2,DIRECT,REL08	
	BRCLR	3,DIRECT,REL08	
	BRCLR	4,DIRECT,REL08	
	BRCLR	5,DIRECT,REL08	
	BRCLR	6,DIRECT,REL08	
	BRCLR	7,DIRECT,REL08	

	BRN	REL08		

	BRSET	0,DIRECT,REL08	
	BRSET	1,DIRECT,REL08	
	BRSET	2,DIRECT,REL08	
	BRSET	3,DIRECT,REL08	
	BRSET	4,DIRECT,REL08	
	BRSET	5,DIRECT,REL08	
	BRSET	6,DIRECT,REL08	
	BRSET	7,DIRECT,REL08	

	BSET	0,DIRECT	
	BSET	1,DIRECT	
	BSET	2,DIRECT	
	BSET	3,DIRECT	
	BSET	4,DIRECT	
	BSET	5,DIRECT	
	BSET	6,DIRECT	
	BSET	7,DIRECT	

	BSR	REL08		

	CLRA			
	CLR	A		
	CLRX			
	CLR	X		
	CLR	56H		
	CLR	0,X		
	CLR	56H,X		

	JMP	DIRECT		
	JMP	LABEL		
	JMP	0,X		
	JMP	DIRECT,X	
	JMP	EXTND,X 	

	JSR	DIRECT		
	JSR	LABEL		
	JSR	0,X		
	JSR	DIRECT,X	
	JSR	EXTND,X 	

	LDA	#IMM8		
	LDA	DIRECT		
	LDA	EXTND		
	LDA	0,X		
	LDA	DIRECT,X	
	LDA	EXTND,X 	

	LDX	#IMM8		
	LDX	DIRECT		
	LDX	EXTND		
	LDX	0,X		
	LDX	DIRECT,X	
	LDX	EXTND,X 	

	LSL	A		
	LSL	X		
	LSLA			
	LSLX			
	LSL	DIRECT		
	LSL	0,X		
	LSL	DIRECT,X	

	LSR	A		
	LSR	X		
	LSRA			
	LSRX			
	LSR	DIRECT		
	LSR	0,X		
	LSR	DIRECT,X	

	MUL			

	NEG	A		
	NEG	X		
	NEGA			
	NEGX			
	NEG	DIRECT		
	NEG	0,X		
	NEG	DIRECT,X	

EXTND:	TXA			

LABEL:	WAIT			

;***********************************************************
; THIS IS AN EXAMPLE PROGRAM FOR THE 6805 PROCESSOR.
; IT IS TAKEN FROM PAGE 289 OF THE SEPTEMBER 20, 1984 ISSUE
; OF EDN, AND AFTER ONLY FORMAT MODIFICATIONS FOR THIS
; ASSEMBLER, IT IS PASSED ON AS AN EXAMPLE, FREE OF CHARGE
; BY UNIVERSAL CROSS-ASSEMBLERS.

; INTERFACE FOR A BARGRAPH DISPLAY
; USING A MC68705R3 MICROCOMPUTER
;	BY: D. ARTUSI	06/27/84
;
; I/O PORTS ALLOCATION
;
PORTA:	EQU	00H
DDRA:	EQU	04H
ADCR:	EQU	0EH		; A/D CONTROL REGISTER
ADRE:	EQU	0FH		; A/D RESULT REGISTER

; RAM ALLOCATION
;
	ORG	10H
VALUE:	DFS	1
ZEROS:	DFS	1

; CONNECTIONS BETWEEN THE 68705R3 AND THE DRIVER
;
;	PA0---> CLOCK	(PIN 19 OF DRIVER)
;	PA1---> DATA	(PIN 21 OF DRIVER)
;	PA2---> ENABLE	(PIN 20 OF DRIVER)

; INITIALIZATION OF I/O PORTS
;
	ORG	0100H
	LDA	#0FFH		; MAKE ALL OUTPUTS
	STA	DDRA

; A/D CONVERSION ROUTINE
;
ADCONV:	LDA	#00H		; LOAD CHANNEL SELECTION (AN0)
	STA	ADCR		; SELECT CHANNEL & START CONV.
	BRCLR	7,ADCR,$	; CHECK FOR END OF CONV. FLAG
	LDA	ADRE		; READ RESULT OF A/D CONV.

	BCLR	2,PORTA		; ENABLE DISPLAY DRIVER
	LSR	A
	LSR	A
	LSR	A		; SCALE RESULT (DIVIDE BY 8)
	STA	VALUE		; SAVE RESULT
	BEQ	ALZERO		; IF RESULT IS ALL ZEROS
	CMP	#1FH		; IS RESULT = FULL SCALE?
	BEQ	ONES		; FULL SCALE DISPLAY
	SUB	VALUE
	STA	ZEROS		; # OF SEGMENTS OFF AT THE TOP
	BRA	DISPLY		; GO TO DISPLAY OUTPUT ROUTINE

ALZERO:	LDA	#20H		; # OF ELEMENTS IN BARGRAPH
	BCLR	1,PORTA		; CLEAR DATA OUTPUT LINE
	BSR	CLOCK		; CLOCK IT IN
	BSET	2,PORTA		; DISABLE DISPLAY DRIVER
	BRA	ADCONV		; GO FOR ANOTHER CONVERSION

ONES:	INC	A		; ENTER HERE WHEN IS FULL SCALE
				; AND ALL ELEMENTS ARE "ON"
	BSET	1,PORTA		; SET DATA OUTPUT LINE
	BSR	CLOCK		; CLOCK IN
	BSET	2,PORTA		; DISABLE DISPLAY DRIVER
	BRA	ADCONV		; GO FOR ANOTHER CONVERSION

DISPLY:	LDA	ZEROS		; LOAD ZEROS (SEGMENTS "OFF")
	BCLR	1,PORTA		; CLEAR DATA LINE
	BSR	CLOCK		; CLOCK IN
	LDA	VALUE		; LOAD ONES (SEGMENTS "OFF")
	BSET	1,PORTA		; SET DATA LINE
	BSR	CLOCK		; CLOCK ONES IN
	BSET	2,PORTA		; DISABLE DISPLAY DRIVER
	BRA	ADCONV		; RETURN FOR ANOTHER CONVERSION

; CLOCKING ROUTINE:	ENTER WITH NUMBER
;			OF CLOCK PULSES IN ACCUMULATOR
;
CLOCK:	BCLR	0,PORTA		; CLOCK LINE LOW
	BSET	0,PORTA		; BRING IT HIGH
	DEC	A		; DECREMENT COUNTER
	BNE	CLOCK		; ONCE MORE
	RTS			; RETURN

	END
