;******************************************************
;
; THE 68000 TABLE CONTAINS THE INSTRUCTIONS USED BY THE
; 68000, 68008 AND 68010, USING THE SYNTAX DEFINED IN
; THE "M68000 16/32-BIT MICROPROCESSOR PROGRAMMER'S
; REFERENCE MANUAL".  THE EXTRA INSTRUCTIONS USED BY
; THE 68010 ARE CLEARLY MARKED AT THE END OF THE TABLE,
; AND THE USER MAY DELETE THEM FOR THE 68000 AND 68008.
;

; NOTE!  THE 68000 IS A SIGNED PROCESSOR. JUST MOVING
;	 A SIGNED VALUE WILL TOGGLE THE NEGATIVE (N)
; BIT.	THE TABLE LIMITS MANY OPERANDS TO SIGNED VALUES.
; THEREFORE, BYTE VALUES ARE LIMITED TO A RANGE OF
; -128 TO 127.	THE USER MAY REPRESENT 80H WITH A -128,
; OR CHANGE THE LIMITS IN THE TABLE.  WORD AND LONG
; OPERANDS BEHAVE IN A SIMILAR MANNER.

; NOTE!  SP (STACK POINTER)
;	 MAY BE USED TO REPRESENT ADDRESS REGISTER 7 (A7)
; FOR ALL INSTRUCTIONS EXCEPT THE MOVEM REGISTER LIST.

; NOTE!  THE REGISTER LIST USED IN THE MOVEM INSTRUCTION
;	 ACCEPTS INDIVIDUAL REGISTERS SEPARATED BY A COMMA,
; BUT NOT A RANGE OF REGISTERS SUCH AS D0-D4.
;
; I.E.
	MOVEM.W A7,(A5) 		;48958000
	MOVEM.W D0,D1,D2,D3,D4,D5,D6,D7,A0,A1,A2,A3,A4,A5,A6,A7,(A5)	;4895FFFF
	MOVEM.W d1,a1,-(A5)		;48A54040
;

; WARNING!!!  ALTHOUGH THIS PRODUCT SUPPORTS LABELS
;	      WITH A PERIOD ".", THEY ARE NOT RECOMMENDED
; FOR USE WITH THE 68000 DUE TO THE PERIODS
; IN ITS OPCODES.

;******************************************************
; THIS IS AN EXAMPLE FOR THE 68000 MICROPROCESSOR.
; IT IS TAKEN FROM PAGE 193 OF THE AUGUST 21, 1986
; ISSUE OF EDN, AND AFTER ONLY FORMAT MODIFICATIONS,
; IT IS PASSED ON AS AN EXAMPLE, FREE OF CHARGE,
; BY UNIVERSAL CROSS-ASSEMBLERS.
;
	CPU	"68000.TBL"	;CPU TABLE
	HOF	"MOT16" 	;HEX OUTPUT FORMAT
;
;******************************************************
;
; THE FOLLOWING COMPRESSION SUBROUTINE IN TANDEM WITH
; THE EXPANSION ROUTINE MAY BE USED TO INCREASE CHANNEL
; BANDWIDTH IN A SPEECH PROCESSING SYSTEM.

; AUTHORS:  R. GARRICK & K. SIIL
;	    THE LOGISTIC SOFTWARE GROUP
;	    SUNNYSIDE, NY, USA


;	REGISTER CONTENTS INITIALIZED BY EXECUTIVE
;
;	D4 = 1FFFH     COMPLEMENT OF SIGN MASK
;	D5 =   0DH     SIGN BIT LOC IN INPUT WORD
;	D6 = 2000H     SIGN MASK
;	D7 =   21H     BIAS
;
;  INPUT:  14 BIT SIGN-MAGNITUDE DATA AT LOCATION IN_DAT
;
;  OUTPUT:  8 BIT COMPRESSED SIGN-EXPONENT-MANTISSA DATA IN REGESTER DO
;

	ORG	080000H 	;STARTING ADDRESS

EXPTABL:
	DFB	000H		;EXPONENT TABLE
	DFB	0F0H
	DFB	000H
	DFB	010H
	DFB	020H
	DFB	030H
	DFB	040H
	DFB	050H
	DFB	060H

SHFTTBL:
	DFB	 1		;MANTISSA SHIFT TABLE
	DFB	 2
	DFB	 2, 3
	DFB	 4, 4
	DFB	 8, 5
	DFB	16, 6
	DFB	32, 7
	DFB	68, 8

IN_DAT: DFS	2		;INPUT DATA STORAGE

COMPRESS:
	MOVE.W	IN_DAT.L,D0	;GET DATA FOR COMPRESSION
	MOVE.W	 D0,D1		;COPY DATA FOR SIGN MASKING
	AND.W	 D6,D1		;MASK SIGN
	LSR.W	 #6,D1		;POSITION SIGN IN OUTPUT
	AND.W	 D4,D0		;STRIP SIGN FROM INPUT DATA
	ADD.W	 D7,D0		;ADD BIAS
	BCLR.L	 D5,D0		;OVERFLOW ?
	BNE.S	 OVERFLOW	;YES, GO FETCH MAX EXP-MANTISSA
	MOVE.W	 D0, D2 	;NO, MAKE COPY OF DATA
	LSR.W	 #6,D2		;CALCULATE TABLE OFFSET
	MOVE.B	 SHFTTBL(PC,D2.W),D2	;FETCH SHIFT COUNT
	LSR.W	 D2,D0		;SHIFT MANTISSA TO LOW FOUR BITS
	ADD.B	 EXPTABL(PC,D2.W),D2	;COMBINE EXP & MANTISSA
ADDSIGN:
	OR.B	 D1,D0		;ADD SIGN TO EXP-MANTISSA
	RTS			;RETURN COMPRESSED DATA
OVERFLOW:
	MOVEQ.L #7FH,D0 	;LOAD MAXIMUM EXP-MANTISSA
	BRA.S	 ADDSIGN	;GO ADD SIGN

;  INPUT:   8 BIT COMPRESSED SIGN-EXP-MANTISSA DATA AT LOCATION COMP_DAT
;
;  OUTPUT: 14 BIT SIGN-MAGNITUDE DATA IN REGISTER D2
;

COM_DAT:
	DFS	2		;COMPRESSED DATA STORAGE

EXPAND: CLR.W	D0		;INIT OUTPUT WORD
	MOVE.B	COM_DAT.L,D0	;GET COMPRESSED DATA
	MOVE.W	D0,D1		;COPY DATA FOR SIGN EXTRACTION
	ANDI.W	#80H,D1 	;MASK AND STORE SIGN
	LSL.W	#6,D1		;POSITION SIGN IN OUTPUT
	MOVE.W	D0,D2		;COPY INPUT FOR MANTISSA MASKING
	ANDI.W	#0FH,D2 	;MASK AND STORE MANTISSA
	LSL.W	#1,D2		;PREPARE MANTISSA FOR PACKING W/ 1'S
	ORI.W	#21H,D2 	;ADD LEADING AND TRAILING 1'S
	ANDI.W	#70H,D0 	;MASK EXPONENT
	LSR.W	#4,D0		;RIGHT JUSTIFY EXPONENT
	LSL.W	D0,D2		;EXPNENT MANTISSA
	SUB.W	#33,D2		;REMOVE BIAS
	OR.W	D1,D2		;ADD SIGN TO EXPANDED DATA
	RTS			;RETURN EXPANDED DATA

	END
