;******************************************************
;
; THE 6800 TABLE CONTAINS THE INSTRUCTION SET FOR
;   THE MOTOROLA 6800/2/8
;   THE MOTOROLA 6801/3
;   AND THE HITACHI HD6301V1 & HD6303R
; FAMILIES OF MICROPROCESSORS.
; THE HITACHI 6301/3 INSTRUCTION SET IS A SUPERSET OF
; THE MOTOROLA 6801/3 WHICH IS A SUPER SET OF
; THE MOTOROLA 6800/2/8 FAMILY.
; THE EXTRA INSTRUCTIONS FOR THE 6801/3 AND 6301/3
; ARE CLEARLY MARKED AND MAY BE REMOVED BY THE USER.
;
; THE ASSEMBLER WILL AUTOMATICALLY SELECT THE SHORTEST
; FORM OF THE ABSOLUTE AND INDEXED INSTRUCTIONS.  HOWEVER,
; THE USER MAY SPECIFY 8 OR 16-BIT ADDRESSING USING A
; < OR > RESPECTIVELY.
;
;******************************************************
;
; THIS IS AN EXAMPLE PROGRAM FOR THE 6800 PROCESSOR.
; IT IS TAKEN FROM PAGES 74-80 OF THE FEBRUARY 1980
; ISSUE OF BYTE MAGAZINE, AND AFTER ONLY FORMAT
; MODIFICATIONS, IT IS PASSED ON AS AN EXAMPLE,
; FREE OF CHARGE, BY UNIVERSAL CROSS-ASSEMBLERS.
;
	CPU	"6800.TBL"
	HOF	"MOT8"
;
; FADER2    BY: JOHN H GIBSON
;		PHYSICS DEPARTMENT
;		ALMA COLLEGE
;		ALMA MI 48801

	ORG	0

MINDLY: DFS	1		;PRESET MINIMUM DELAY

RATE1:	DFS	1		;PRESET FADING RATE 1
RATE2:	DFS	1		;PRESET FADING RATE 2
RATE3:	DFS	1		;PRESET FADING RATE 3

FINAL1: DFS	1
FINAL2: DFS	1
FINAL3: DFS	1

DELAY1: DFS	1
DELAY2: DFS	1
DELAY3: DFS	1

INTER1: DFS	1
INTER2: DFS	1
INTER3: DFS	1

UIRQ:	EQU	00F7H		;MONITOR VECTORS HERE ON IRQ


; ADDRESSES IN PROGRAMMABLE TIMING MODULE

CR1:	EQU	8000H
CR2:	EQU	CR1+1
CR3:	EQU	CR1

M1:	EQU	CR1+2		;MSB OF LATCH 1
L1:	EQU	CR1+3		;LSB OF LATCH 1

M2:	EQU	CR1+4		;MSB OF LATCH 2
L2:	EQU	CR1+5		;LSB OF LATCH 2

M3:	EQU	CR1+6		;MSB OF LATCH 3
L3:	EQU	CR1+7		;LSB OF LATCH 3


; THESE ET-3400 MONITOR SUBROUTINES ARE USED

RESET:	EQU	0FC00H		;RETURN TO MONITOR
INCH:	EQU	0FDF4H		;INPUT CHAR FROM KEYBOARD
REDIS:	EQU	0FCBCH		;RESET DISPLAY TO 1ST LED
DSPLAY: EQU	0FD7BH		;DISPLAY ROUTINE

; MAKE A COLD START FROM THIS ADDRESS - 0100H

	ORG	100H

; INITIALIZE DELAYS SO ALL LAMPS ARE OFF

CLDSTR: LDAA	#0FFH		;MAXIMUM DELAY VALUE
	LDX	#FINAL1 	;INITIALIZE POINTER

INITIA: STAA	0,X		;STORE #0FFH HERE
	INX			;POINT TO NEXT VARIABLE
	CPX	#INTER3+1	;LAST VARIABLE?
	BNE	INITIA		;RETURN IF NOT DONE

	NOP
	NOP
	NOP

; MAKE A WARM START FROM THIS ADDRESS - 0110H

WRMSTR: SEI			;MASK IRQ WHILE INITIALIZING

; THESE STEPS CONFIGURE THE TIMERS FOR SINGLE-SHOT
; OPERATION WITH TURN ON DELAY M(L+1)T AND OUTPUT
; PULSE WIDTH LT.

	LDAA	#0B6H		;CONTROL WORD FOR CR3, CR1
	LDAB	#0B7H		;CONTROL WORD FOR CR2

	STAA	CR3		;CONFIGURE TIMER 3
	STAB	CR2		;CONFIGURE TIMER 2
	STAA	CR1		;CONFIGURE TIMER 1

; ON IRQ, THE ET-3400 VECTORS TO LOCATION
; UIRQ.  WE MUST PROVIDE A JUMP INSTRUCTION
; AND A VECTOR TO TRANSFER OUR PROGRAM'S
; IRQ SERVICE ROUTINE AT LOCATION #CYCLE.

	LDAA	#7EH		;LDAA  WITH JUMP COMMAND
	STAA	UIRQ		;STORE JUMP COMMAND AT UIRQ

	LDX	#CYCLE		;JUMP TO THIS LOCATION
	STX	UIRQ+1		;STORE #CYCLE AT UIRQ VECTOR

	CLI			;CLEAR IRQ MASK

; MAIN PROGRAM LOOP

KEY:	JSR	INCH		;GET HEX VALUE OF KEY PUSHED

	CMPA	#09H		;IS IT "BREAK" KEY?
	BNE	CONT		;BRANCH IF NOT "BREAK"

	SEI			;SET IRQ MASK
	JMP	RESET		;GO TO ET-3400 MONITOR RESET

CONT:	BSR	NEWFN		;SET FINAL VALUES
	BRA	KEY		;GET NEXT CLOSED KEY VALUE

; IRQ INTERRUP SUBROUTINE

CYCLE:	BSR	CHANGE		;CHANGE DELAY VALUES
	BSR	LOAD		;LOAD TIMERS WITH NEW DELAYS
	BSR	SHOW		;DISPLAY DELAY VALUES
	RTI

; SUBROUTINE TO CHANGE FINAL VALUES

NEWFN:	CMPA	#07H		;VALID HEX VALUE?
	BHI	NEWFN4		;BRANCH IF NOT VALID

	LDX	#FINAL1 	;POINT TO FINAL1

NEWFN1: RORA			;SHIFT LAMP(X) BIT INTO C
	BCC	NEWFN2		;BRANCH TO DIM LAMP

	LDAB	MINDLY		;LDAB  WITH MIN DELAY
	BRA	NEWFN3

NEWFN2: LDAB	#0FFH		;LDAB  WITH MAX DELAY

NEWFN3: STAB	0,X		;STAB  FINAL(X)

	INX			;POINT TO NEXT LAMP
	CPX	#FINAL3+1	;LAST LAMP DONE
	BNE	NEWFN1		;RETURN IF NOT DONE

NEWFN4: RTS

; ROUTINE FOR CHANGING DELAY NUMBERS

CHANGE: LDX	#RATE1		;POINT TO LAMP 1

CHNG1:	LDAB	9,X		;LDAB  INTER(X)
	LDAA	6,X		;LDAA  DELAY(X)

	CMPA	3,X		;CMP DELAY(X) WITH FINAL(X)
	BHI	BRITER		;BRANCH IF DELAY(X)>FINAL(X)
	BEQ	RESTOR		;BRANCH IF DELAY(X)=FINAL(X)

DIMMER: ADDB	0,X		;B = INTER(X) + RATE(X)
	ADCA	#00H		;A = DELAY(X) + CARRY
	BRA	RESTOR

BRITER: SUBB	0,X		;B = INTER(X) - RATE(X)
	SBCA	#00H		;A = DELAY(X) - BORROW

RESTOR: STAB	9,X		;STAB  INTER(X)
	STAA	6,X		;STAA  DELAY(X)

	INX			;POINT TO NEXT LAMP
	CPX	#RATE3+1	;DONE WITH ALL 3 LAMPS?
	BNE	CHNG1		;RETURN TO DO NEXT LAMP

	RTS

; THIS ROUTINE LOADS THE TIMER LATCHES

LOAD:	LDX	#M1		;POINT TO M1

	LDAA	DELAY1
	LDAB	#1EH		;OUTPUT PULSE WIDTH
	STAA	0,X		;LOAD M1 WITH DELAY1
	STAB	1,X		;LOAD L1 WITH PULSE WIDTH

	LDAA	DELAY2
	STAA	2,X		;LOAD M2 WITH DELAY2
	STAB	3,X		;LOAD L2 WITH PULSE WIDTH

	LDAA	DELAY3
	STAA	4,X		;LOAD M3 WITH DELAY3
	STAB	5,X		;LOAD L3 WITH PULSE WIDTH

	RTS

; THIS ROUTINE SHOWS THE THREE DELAY VALUES ON
; THE ET-3400'S SIX 7-SEGMENT READOUTS.

SHOW:	JSR	REDIS		;RESET DISPLAY TO 1ST LED
	LDX	#DELAY1 	;START DISPLAY WITH DELAY1
	LDAB	#03		;DISPLAY 3 BYTES
	JSR	DSPLAY		;DISPLAY DELAY1, 2 AND 3

	RTS

	END
