;******************************************************
;
         TITL    "65816/65802 EXAMPLE PROGRAM"
         PAGE     56
         CPU     "65816.TBL"     ; CPU TABLE
         HOF     "MOT16"         ; HEX FORMAT

; NOTE!  THE 65816 TABLE IS WRITTEN WITH THE PROCESSOR 
;        IN NATIVE MODE WITH M = 0.  THEREFORE, MOST 
; OF THE OPERANDS IN THE IMMEDIATE ADDRESSING 
; INSTRUCTIONS ARE TWO BYTES LONG.  TO SPECIFY AN
; IMMEDIATE INSTRUCTION IN EMULATION MODE WITH A
; ONE BYTE OPERAND PLEASE USE A < SIGN.
; I.E.
	ADC	#<33		;EMULATION
	ADC	#33		;NATIVE


; NOTE!  THE ASSEMBLER ACCEPTS THE FOLLOWING ALTERNATE
;	 MNEMONICS, AS RECOMMENDED BY THE WESTERN DESIGN
; CENTER
;	STANDARD	ALIAS
;-----------------------------
;	BCC		BLT
;	BCS		BGE
;	CMP		CMA
;	DEC A		DEA
;	INC A		INA
;	JSL		JSR
;	JML		JMP
;	TCD		TAD
;	TCS		TAS
;	TDC		TDA
;	TSC		TSA
;	XBA		SWA


; NOTE!  WHERE THERE IS A CHOICE, THIS ASSEMBLER WILL
;        AUTOMATICALLY CHOOSE THE SHORTEST ADDRESSING
; MODE (DIRECT, ABSOLUTE OR LONG), BASED ON OPERAND
; SIZE.  THE USER MAY OVERRIDE THIS BY SELECTION USING
; THE < | AND > CHARACTERS TO FORCE DIRECT, ABSOLUTE OR
; LONG ADDRESSING RESPECTIVELY.
; I.E.
;
IMM16:	EQU	-1024
DIRECT: EQU	80H
ABSOL:	EQU	3412H
LONG:	EQU	563412H
;
	ADC	#<255		;69FF
	ADC	#IMM16		;6900FC
	ADC	DIRECT		;6580
	ADC	ABSOL		;6D1234
	ADC	LONG		;6F123456
	ADC	<DIRECT		;6580
	ADC	|ABSOL		;6D1234
	ADC	>LONG		;6F123456
	ADC	(DIRECT),Y	;7180
	ADC	[DIRECT],Y	;7780
	ADC	(DIRECT,X)	;6180
	ADC	DIRECT,X	;7580
	ADC	ABSOL,X 	;7D1234
	ADC	LONG,X		;7F123456
	ADC	<DIRECT,X	;7580
	ADC	|ABSOL,X 	;7D1234
	ADC	>LONG,X		;7F123456
	ADC	ABSOL,Y 	;791234
	ADC	(DIRECT)	;7280
	ADC	[DIRECT]	;6780
	ADC	DIRECT,S	;6380
	ADC	(DIRECT,S),Y	;7380



; NOTE!  THE MVN AND MVP INSTRUCTIONS WILL ACCEPT
;        BOTH IMMEDIATE MEMORY BANKS AND LONG ABSOLUTE 
; ADDRESSES.  THE USE OF IMMEDIATE MEMORY BANKS 
; REQUIRES AN #.
;.I.E.
;
SORC:	EQU	$123456		;SOURCE ADDRESS
DEST:	EQU	$234567		;DESTINATION ADDRESS
COUNT:	EQU	25		;NUMBER OF BYTES MOVED
;
	LDX	#SORC & $FFFF	;LOAD SOURCE ADDRESS
	LDY	#DEST & $FFFF	;LOAD DESTINATION ADDRESS
	LDA	#COUNT-1	;LOAD COUNT
;
	MVP	SORC,DEST	;LONG ABSOLUTE ADDRESSES
				;OR 
	MVP	#$12,#$23	;IMMEDIATE MEMORY BANKS
				;OR
	MVP	#$12,#$23	;BOTH


;******************************************************
;
; THIS IS AN EXAMPLE PROGRAM FOR THE 65816 PROCESSOR.
; IT IS TAKEN FROM PAGE 355 OF THE BOOK:
;
;        65816/65802 ASSEMBLY LANGUAGE PROGRAMMING
;        BY MICHAEL FISCHER
;        ISBN 0-07-881235-6
;
;        PUBLISHED BY: OSBORNE McGRAW-HILL
;                      2600 TENTH STREET
;                      BERKELEY, CA, USA
;                      94710
;
; AND AFTER ONLY FORMAT CHANGES FOR THIS ASSEMBLER
; IT IS PASSED ON AS AN EXAMPLE, FREE OF CHARGE,
; BY UNIVERSAL CROSS-ASSEMBLERS.

;Program to multily two multiple precision unsigned
;values in 16 bit and binary mode.  Maximum multiplier
;and multiplicand size is 4096 words.  Maximum product
;size is 8192 words.
           ORG   002000H
Mplier:    EQU   003000H      ;Multiplier Low first
Mpcand:    EQU   003100H      ;Multiplicand Low first
Product:   EQU   003200H
Size:      EQU   000300H      ;# of words in values
Pindex:    EQU   000302H
Numbits:   EQU   000304H
           CLC
           XCE                ;Native mode
           CLD                ;Binary mode
           REP   #30H         ;16 bit mode
           ASL   Size         ;Convert to bytes
           BEQ   Done         ;If n #s, no change
           LDA   Size
;Double number of bytes in multplier
           ASL   A
           TAX                ;Store as product index
           ASL   A
           ASL   A
           STA   Numbits      ;Bytes * 8 (2^3) = bits
           DEC   Size
           DEC   Size         ;Adjust as 16 bit index
           DEX
           DEX                ;Adjust as 16 bit index
           STX   Pindex
;Zero out product just to be sure
Clrprdct:  STZ   Product,X
           DEX
           DEX
           BNE   Clrprdct
           STZ   Product
Multloop:  LDX   Size
;Bet least significant bit of multiplier
MPShift:   ROR   Mplier,X
           DEX
           DEX
           BNE   MPShift
           ROR   Mplier
           BCC   NoAdd        ;If zero, get again
;Add multiplicand to product
           CLC
           LDX   Size
           LDY   Pindex
AddMpcnd:  LDA   Product,Y
           ADC   Mpcand, X
           STA   Product,Y
           DEY
           DEY
           DEX
           DEX
           BNE   AddMpcnd
           LDA   Product, Y
           ADC   Mpcand,X
           STA   Product, Y
NoAdd:     LDX   Pindex       ;Shift product right
           CLC
Prodshft:  ROR   Product,X
           DEX
           DEX
           BNE   Prodshft
           ROR   Product
           DEC   Numbits
           BNE   Multloop
Done:      SEC
           XCE
           RTS

           END
