;************************************************************
; THE 50740 TABLE CONTAINS THE INSTRUCTION SET FOR THE
; MITSUBISHI SERIES 740 MICROCONTROLLERS AND M37450
; MICROCOMPUTERS.  THE INSTRUCTION SET IS SIMILAR BUT
; NOT IDENTICAL TO THE 6502 FAMILY.

	HOF	"MOT8"		;HEX FORMAT
	CPU	"50740.TBL"	;PROCESSOR TABLE

; NOTE: THE DIV AND MUL INSTRUCTIONS FOR THE M37450
;	ARE CLEARLY MARKED AT THE END OF THE 50740
;	TABLE.  THE USER MAY REMOVE THEM IF THEY ARE
;	NOT SUPPORTED BY THE TARGET PROCESSOR.

; NOTE: THE ASSEMBLER WILL AUTOMATICALLY CHOOSE THE
;	SHORTEST FORM POSSIBLE INSTRUCTION FROM THE
;	ZERO PAGE AND ABSOLUTE ADDRESSING TYPES.

; NOTE: THE MITSUBISHI ASSEMBLER ALLOWS BITS IN PAGE 0
;	TO BE ASSIGNED A LABEL AND USED IN THE BBC, BBS,
;	CLB AND SEB INSTRUCTIONS.  EXAMPLES:
;
LABEL:  BBC	P30, LABEL
	BBS	P30, LABEL
	CLB	P30
	SEB	P30

;************************************************************
; THIS IS AN EXAMPLE INITIALIZATION PROGRAM FOR THE M50747
; MICROCOMPUTER.  IT IS TAKEN FROM PAGE 4-49 OF THE
; MITSUBISHI SEMICONDUCTORS SERIES 740 SOFTWARE USER'S
; MANUAL, AND AFTER ONLY FORMAT MODIFICATIONS FOR OUR
; ASSEMBLER, IT IS PASSED ON, FREE OF CHARGE, BY
; UNIVERSAL CROSS-ASSEMBLERS.

	ORG	$E000		;ORIGIN
;************************************************************
;	INITIAL ROUTINE
;************************************************************
;
; THE SPECIAL FUNCTION REGISTERS IN THIS FAMILY VARY
; FROM CHIP TO CHIP, SO DO NOT USE THE FOLLOWING DECLARATIONS
; WITHOUT CHECKING THEIR ACCURACY FOR YOUR CHIP.
;
PORT0:	EQU	$E0		;PORT 0
P00:	EQU	{0<<13}+PORT0	;PORT 0, BIT 0
P01:	EQU	{1<<13}+PORT0	;PORT 0, BIT 1
P02:	EQU	{2<<13}+PORT0	;PORT 0, BIT 2
P03:	EQU	{3<<13}+PORT0	;PORT 0, BIT 3
P04:	EQU	{4<<13}+PORT0	;PORT 0, BIT 4
P05:	EQU	{5<<13}+PORT0	;PORT 0, BIT 5
P06:	EQU	{6<<13}+PORT0	;PORT 0, BIT 6
P07:	EQU	{7<<13}+PORT0	;PORT 0, BIT 7
PORT0D:	EQU	$E1		;PORT 0 DIRECTIONAL REGISTER

PORT1:	EQU	$E2		;PORT 1
P10:	EQU	{0<<13}+PORT1	;PORT 1, BIT 0
P11:	EQU	{1<<13}+PORT1	;PORT 1, BIT 1
P12:	EQU	{2<<13}+PORT1	;PORT 1, BIT 2
P13:	EQU	{3<<13}+PORT1	;PORT 1, BIT 3
P14:	EQU	{4<<13}+PORT1	;PORT 1, BIT 4
P15:	EQU	{5<<13}+PORT1	;PORT 1, BIT 5
P16:	EQU	{6<<13}+PORT1	;PORT 1, BIT 6
P17:	EQU	{7<<13}+PORT1	;PORT 1, BIT 7
PORT1D:	EQU	$E3		;PORT 1 DIRECTIONAL REGISTER

PORT2:	EQU	$E4		;PORT 2
P20:	EQU	{0<<13}+PORT2	;PORT 2, BIT 0
P21:	EQU	{1<<13}+PORT2	;PORT 2, BIT 1
P22:	EQU	{2<<13}+PORT2	;PORT 2, BIT 2
P23:	EQU	{3<<13}+PORT2	;PORT 2, BIT 3
P24:	EQU	{4<<13}+PORT2	;PORT 2, BIT 4
P25:	EQU	{5<<13}+PORT2	;PORT 2, BIT 5
P26:	EQU	{6<<13}+PORT2	;PORT 2, BIT 6
P27:	EQU	{7<<13}+PORT2	;PORT 2, BIT 7
PORT2D:	EQU	$E5		;PORT 2 DIRECTIONAL REGISTER

PORT3:	EQU	$E8		;PORT 3
P30:	EQU	{0<<13}+PORT3	;PORT 3, BIT 0
P31:	EQU	{1<<13}+PORT3	;PORT 3, BIT 1
P32:	EQU	{2<<13}+PORT3	;PORT 3, BIT 2
P33:	EQU	{3<<13}+PORT3	;PORT 3, BIT 3
P34:	EQU	{4<<13}+PORT3	;PORT 3, BIT 4
P35:	EQU	{5<<13}+PORT3	;PORT 3, BIT 5
P36:	EQU	{6<<13}+PORT3	;PORT 3, BIT 6
P37:	EQU	{7<<13}+PORT3	;PORT 3, BIT 7
PORT3D:	EQU	$E9		;PORT 3 DIRECTIONAL REGISTER

PORT4:	EQU	$EA		;PORT 4
P40:	EQU	{0<<13}+PORT4	;PORT 4, BIT 0
P41:	EQU	{1<<13}+PORT4	;PORT 4, BIT 1
P42:	EQU	{2<<13}+PORT4	;PORT 4, BIT 2
P43:	EQU	{3<<13}+PORT4	;PORT 4, BIT 3
P44:	EQU	{4<<13}+PORT4	;PORT 4, BIT 4
P45:	EQU	{5<<13}+PORT4	;PORT 4, BIT 5
P46:	EQU	{6<<13}+PORT4	;PORT 4, BIT 6
P47:	EQU	{7<<13}+PORT4	;PORT 4, BIT 7
PORT4D:	EQU	$EB		;PORT 4 DIRECTIONAL REGISTER

PORT5:	EQU	$EC		;PORT 5
P50:	EQU	{0<<13}+PORT5	;PORT 5, BIT 0
P51:	EQU	{1<<13}+PORT5	;PORT 5, BIT 1
P52:	EQU	{2<<13}+PORT5	;PORT 5, BIT 2
P53:	EQU	{3<<13}+PORT5	;PORT 5, BIT 3
P54:	EQU	{4<<13}+PORT5	;PORT 5, BIT 4
P55:	EQU	{5<<13}+PORT5	;PORT 5, BIT 5
P56:	EQU	{6<<13}+PORT5	;PORT 5, BIT 6
P57:	EQU	{7<<13}+PORT5	;PORT 5, BIT 7

PORT6:	EQU	$EE		;PORT 6
P60:	EQU	{0<<13}+PORT6	;PORT 6, BIT 0
P61:	EQU	{1<<13}+PORT6	;PORT 6, BIT 1
P62:	EQU	{2<<13}+PORT6	;PORT 6, BIT 2
P63:	EQU	{3<<13}+PORT6	;PORT 6, BIT 3
P64:	EQU	{4<<13}+PORT6	;PORT 6, BIT 4
P65:	EQU	{5<<13}+PORT6	;PORT 6, BIT 5
P66:	EQU	{6<<13}+PORT6	;PORT 6, BIT 6
P67:	EQU	{7<<13}+PORT6	;PORT 6, BIT 7

SMODE:	EQU	$F4		;TRANSMIT-RECEIVE MODE BITS
SM0:	EQU	{0<<13}+SMODE	;CLOCK SOURCE SELECT
SM1:	EQU	{1<<13}+SMODE	;CLOCK SOURCE SELECT
SM2:	EQU	{2<<13}+SMODE	;METHOD SELECT
SM3:	EQU	{3<<13}+SMODE	;METHOD SELECT
SM4:	EQU	{4<<13}+SMODE	;SLEEP MODE SELECT

SCON:	EQU	$F5		;TRANSMIT-RECEIVE CONTROL BITS
TE:	EQU	{0<<13}+SCON	;TRANSMIT ENABLE
TI:	EQU	{1<<13}+SCON	;TRANSMIT COMPLETE
RE:	EQU	{2<<13}+SCON	;RECEIVE ENABLE
RI:	EQU	{3<<13}+SCON	;RECEIVE COMPLETE
OFR:	EQU	{4<<13}+SCON	;OVERRUN FRAMING ERROR
PER:	EQU	{5<<13}+SCON	;RECEIVE PARITY ERROR
T8:	EQU	{6<<13}+SCON	;TRANSMIT DATA
R8:	EQU	{7<<13}+SCON	;RECEIVE DATA

XREG:	EQU	$F6		;TRANSMIT REGISTER
RREG:	EQU	$F7		;RECEIVE REGISTER

PRE12:	EQU	$F9		;PRESCALER FOR TIMER 1.2
T1:	EQU	$FA		;TIMER 1
T2:	EQU	$FB		;TIMER 2
PREX:	EQU	$FC		;PRESCALER FOR TIMER X
TX:	EQU	$FD		;TIMER X

ICON:	EQU	$FE		;INTERRUPT CONTROL REGISTER
E2E:	EQU	{0<<13}+ICON	;INTERRUPT 2 ENABLE
E2R:	EQU	{1<<13}+ICON	;INTERRUPT 2 REQUEST
T2E:	EQU	{2<<13}+ICON	;TIMER 1 ENABLE
T2R:	EQU	{3<<13}+ICON	;TIMER 1 REQUEST
T1E:	EQU	{4<<13}+ICON	;TIMER 2 ENABLE
T1R:	EQU	{5<<13}+ICON	;TIMER 2 REQUEST
E1E:	EQU	{6<<13}+ICON	;INTERRUPT 1 ENABLE
E1R:	EQU	{7<<13}+ICON	;INTERRUPT 1 REQUEST

TCON:	EQU	$FF		;TIMER CONTROL REGISTER
CM0:	EQU	{0<<13}+TCON	;PROCESSOR MODE
CM1:	EQU	{1<<13}+TCON	;PROCESSOR MODE
XM0:	EQU	{2<<13}+TCON	;TIMER X MODE
XM1:	EQU	{3<<13}+TCON	;TIMER X MODE
SPS:	EQU	{4<<13}+TCON	;STACK PAGE
TXG:	EQU	{5<<13}+TCON	;TIMER X COUNT STOP
TXE:	EQU	{6<<13}+TCON	;TIMER X INTERRUPT ENABLE
TXR:	EQU	{7<<13}+TCON	;TIMER X INTERRUPT REQUEST

;------------------------------------------------------------
INIT: 	NOP
	CLT			;CLEAR TRANSFER FLAG
	CLD			;CLEAR DECIMAL FLAG
;------------------------------------------------------------
	LDA	#$00		;CLEAR  ACCUMULATOR
	TAX			;CLEAR  X REGISTER
	TAY			;CLEAR  Y REGISTER
;------------------------------------------------------------
CLEAR:	STA	$00,X		;RAM CLEAR ($00 TO $FF)
	DEX
	BNE	CLEAR
;------------------------------------------------------------
STACK:	LDM	#$10,TCON	;SET STACK POINTER TO $013F
	LDX	#$3F
	TXS
;------------------------------------------------------------
	LDM	#$FF,PORT0D	;SET OUTPUT MODE TO PORT0
	LDM	#$00,PORT1D	;SET INPUT MODE TO PORT1
	LDM	#$00,PORT2D	;SET INPUT MODE TO PORT2
;
	END
