;******************************************************
;
; THIS IS AN EXAMPLE PROGRAM FOR THE 3870 FAMILY OF
; PROCESSORS.  IT IS TAKEN FROM PAGE 4-1 OF THE "F8 AND
; F3870 GUIDE TO PROGRAMMING" MANUAL, AND AFTER ONLY
; FORMAT MODIFICATIONS THIS ASSEMBLER, IT IS PASSED ON
; AS AN EXAMPLE, FREE OF CHARGE, BY UNIVERSAL
; CROSS-ASSEMBLERS.

; F8 REGISTERS MAY BE REPRESENTED USING DECIMAL
; NUMBERS (0-11) AND FAIRCHILD'S HEX FORMAT (H'0'-H'B')
; AND S, I, AND D.
; 
         CPU     "3870.TBL"    ; CPU TABLE
         HOF     "INT8"        ; HEX OUTPUT FORMAT

;******************************************************
;
BUFA:    EQU     0800H   ; SET THE VALUE OF SYMBOL BUFA
BUFB:    EQU     08A0H   ; SET THE VALUE OF SYMBOL BUFB
         ORG     0100H
;
; THE FOLLOWING PROGRAM MOVES DATA FROM ONE 128 BYTE
; BUFFER TO ANOTHER 128 BYTE BUFFER
;

ONE:     DCI     BUFA    ; SET DC0 TO BUFA STARTING
                         ; ADDRESS
TWO:     XDC             ; STORE INTO DC1
THREE:   DCI     BUFB    ; SET DC0 TO BUFB STARTING
                         ; ADDRESS
FOUR:    LI      80H     ; LOAD BUFFER LENGTH INTO
                         ; ACCUMULATOR
FIVE:    LR      1,A     ; SAVE BUFFER LENGTH IN
                         ; SCRATCHPAD BYTE 1
LOOP:    LM              ; LOAD CONTENTS OF MEMORY BYTE
                         ; ADDRESSED BY DC0
SIX:     XDC             ; EXCHANGE DC0 AND DC1
SEVEN:   ST              ; STORE ACCUMULATOR IN MEMORY
                         ; BYTE ADDRESSED BY DC0
EIGHT:   XDC             ; EXCHANGE DC0 AND DC1
NINE:    DS      1       ; DECREMENT SCRATCHPAD BYTE 1
         BNZ     LOOP    ; IF SCRATCHPAD BYTE 1 IS NOT
                         ; ZERO, RETURN TO LOOP


; SOME OTHER F8 INSTRUCTIONS FOLLOW:

	ASD	H'0'		;D0
	ASD	H'1'		;D1
	ASD	H'2'		;D2
	ASD	H'3'		;D3
	ASD	H'4'		;D4
	ASD	H'5'		;D5
	ASD	H'6'		;D6
	ASD	H'7'		;D7
	ASD	H'8'		;D8
	ASD	H'9'		;D9
	ASD	H'A'		;DA
	ASD	H'B'		;DB
	ASD	I 		;DD
	ASD	S 		;DC

	AS	 0		;C0
	AS	 1		;C1
	AS	 2		;C2
	AS	 3		;C3
	AS	 4		;C4
	AS	 5		;C5
	AS	 6		;C6
	AS	 7		;C7
	AS	 8		;C8
	AS	 9		;C9
	AS	10		;CA
	AS	11		;CB
	AS	D 		;CE
	AS	I 		;CD
	AS	S 		;CC

	LR	 4,A		;54
	LR	 5,A		;55
	LR	 6,A		;56
	LR	 7,A		;57
	LR	A, 5		;45
	LR	A, 6		;46
	LR	A, 7		;47
	LR	A,QL		;03
	LR	A,QU		;02
	LR	A,S 		;4C
	LR	D ,A		;5E
	LR	DC,H		;10
	LR	DC,Q		;0F
	LR	H,DC		;11
	LR	I ,A		;5D
	LR	IS,A		;0B
	LR	J,W		;1E
	LR	K,P		;08
	LR	KL,A		;05
	LR	KU,A		;04
	LR	P,K		;09
	LR	P0,Q		;0D
	LR	Q,DC		;0E
	LR	QL,A		;07
	LR	QU,A		;06
	LR	S ,A		;5C
	LR	W,J		;1D
	NM			;8A
	NOP			;2B
	NS	 0		;F0
	NS	 1		;F1
	NS	D 		;FE
	NS	I 		;FD
	NS	S 		;FC

	END
