;******************************************************
; THE 37700 TABLE (37700.TBL) CONTAINS THE INSTRUCTION
; SET FOR THE MITSUBISHI 7700 FAMILY OF SINGLE-CHIP
; 16-BIT MICROCOMPUTERS.  THIS IS A SUPERSET OF THE
; 6502 INSTRUCTION SET.  PLEASE READ THIS FILE
; CAREFULLY.

	  CPU  "37700.TBL"	;PROCESSOR TABLE
	  HOF  "INT16"		;HEX FORMAT

; THE ASSEMBLER WILL AUTOMATICALLY CHOOSE THE SHORTEST
; FORM POSSIBLE, FROM THE  DIRECT AND ABSOLUTE
; ADDRESSING TYPES.

; SOME TYPICAL CONSTANTS:
;
IMM8:	EQU	12H
IMM16:	EQU	-1024
DIRECT:	EQU	80H
ABSOL:	EQU	3412H
LONG:	EQU	563412H

; THE 37700 TABLE HAS BEEN SET UP ASSUMING THAT THE
; STATUS FLAGS ARE m=0 AND x=0.  THIS MEANS THAT
; IMMEDIATE MODES WILL DEFAULT TO 16-BIT VALUES.
; THE SIZE EXTENTION (.B OR .W) MAY BE USED TO
; CHANGE THE DEFAULT, I.E. ADC...

	ADC.B	A,#IMM8		;6912
	ADC.W	A,#IMM16	;6900FC
	ADC	A,#IMM16	;6900FC
	ADC	A,DIRECT	;6580
	ADC	A,DIRECT,X	;7580
	ADC	A,(DIRECT)	;7280
	ADC	A,(DIRECT,X)	;6180
	ADC	A,(DIRECT),Y	;7180
	ADCL	A,(DIRECT)	;6780
	ADCL	A,(DIRECT),Y	;7780
	ADC	A,ABSOL		;6D1234
	ADC	A,ABSOL,X	;7D1234
	ADC	A,ABSOL,Y	;791234
	ADC	A,LONG		;6F123456
	ADC	A,LONG,X	;7F123456
	ADC	A,DIRECT,S	;6380
	ADC	A,(DIRECT,S),Y	;7380

	ADC.B	B,#IMM8		;426912
	ADC.W	B,#IMM16	;426900FC
	ADC	B,#IMM16	;426900FC
	ADC	B,DIRECT	;426580
	ADC	B,DIRECT,X	;427580
	ADC	B,(DIRECT)	;427280
	ADC	B,(DIRECT,X)	;426180
	ADC	B,(DIRECT),Y	;427180
	ADCL	B,(DIRECT)	;426780
	ADCL	B,(DIRECT),Y	;427780
	ADC	B,ABSOL		;426D1234
	ADC	B,ABSOL,X	;427D1234
	ADC	B,ABSOL,Y	;42791234
	ADC	B,LONG		;426F123456
	ADC	B,LONG,X	;427F123456
	ADC	B,DIRECT,S	;426380
	ADC	B,(DIRECT,S),Y	;427380

; THE FOLLOWING FLAG VALUES MUST BE SPECIFIED TO
; USE THE FLAG MODES OF THE CLP AND SEB INSTRUTIONS.
; NOTE THAT THE INDEX REGISTER LENGTH FLAG IS
; REPRESENTED AS XF TO AVOID CONFUSION WITH THE
; INDEX REGISTERS (XR AND YR).
;
C:	EQU	00000001B
Z:	EQU	00000010B
I:	EQU	00000100B
D:	EQU	00001000B
XF:	EQU	00010000B	;INDEX REGISTER LENGTH FLAG (XF)
M:	EQU	00100000B
V:	EQU	01000000B
N:	EQU	10000000B
;
	CLP	#0FFH			;C2FF
	CLP	C,Z,I,D,XF,M,V,N	;C2FF
	CLP	C,Z,I,D,XF,M,V		;C27F
	CLP	C,Z,I,D,XF,M		;C23F
	CLP	C,Z,I,D,XF		;C21F
	CLP	C,Z,I,D			;C20F
	CLP	C,Z,I			;C207
	CLP	C,Z			;C203
	CLP	C			;C201
	CLP	C,D,XF,N		;C299

; THE FOLLOWING REGISTER VALUES MUST BE SPECIFIED TO
; USE THE REGISTER MODES OF THE PSH AND PUL INSTRUCTIONS.
; NOTE THAT THE INDEX REGISTERS ARE REPRESENTED AS
; XR AND YR TO AVOID CONFUSION WITH THE INDEX REGISTER
; LENGTH FLAG XF.
;
A:	EQU	00000001B
B:	EQU	00000010B
XR:	EQU	00000100B	;X REGISTER (XR)
YR:	EQU	00001000B	;Y REGISTER (YR)
DPR:	EQU	00010000B
PBR:	EQU	00100000B
DBR:	EQU	01000000B
PSR:	EQU	10000000B
;
	PUL	#055H				;FB55
	PUL	PSR,DBR,PBR,DPR,YR,XR,B,A	;FBFF
	PUL	    DBR,PBR,DPR,YR,XR,B,A	;FB7F
	PUL	        PBR,DPR,YR,XR,B,A	;FB3F
	PUL	            DPR,YR,XR,B,A	;FB1F
	PUL	                YR,XR,B,A	;FB0F
	PUL	                   XR,B,A	;FB07
	PUL	                      B,A	;FB03
	PUL	                        A	;FB01

; SOME OTHER 37700 INSTRUCTION ARE:
;

	ASL	B		;420A
	ASL	DIRECT		;0680
	ASL	DIRECT,X	;1680
	ASL	ABSOL		;0E1234
	ASL	ABSOL,X		;1E1234

	BBC.B	#IMM8,DIRECT,$+66	;3480123E
	BBC.B	#IMM8,ABSOL,$+66	;3C1234123D
	BBC.W	#IMM16,DIRECT,$+66	;348000FC3D
	BBC.W	#IMM16,ABSOL,$+66	;3C123400FC3C
	BBC	#IMM16,DIRECT,$+66	;348000FC3D
	BBC	#IMM16,ABSOL,$+66	;3C123400FC3C

	BCC	$+66		;9040
	BCS	$+66		;B040
	BEQ	$+66		;F040
	BMI	$+66		;3040
	BNE	$+66		;D040
	BPL	$+66		;1040
	BRA	$+66		;8040
	BRAL	$+3415H		;821234
	BRK	#IMM8		;0012

	BVC	$+66		;5040
	BVS	$+66		;7040

	CLV			;B8

	CPY.B	#IMM8		;C012
	CPY.W	#IMM16		;C000FC
	CPY	#IMM16		;C000FC
	CPY	DIRECT		;C480
	CPY	ABSOL		;CC1234

	DEC	A		;1A
	DEC	B		;421A
	DEC	DIRECT		;C680
	DEC	DIRECT,X	;D680
	DEC	ABSOL		;CE1234
	DEC	ABSOL,X		;DE1234

	JMP	ABSOL		;4C1234
	JMPL	LONG		;5C123456
	JMP	(ABSOL)		;6C1234
	JMPL	(ABSOL)		;DC1234
	JMP	(ABSOL,X)	;7C1234

	JSR	ABSOL		;201234
	JSRL	LONG		;22123456
	JSR	(ABSOL,X)	;FC1234

	MVN	0E2H, 0E5H	;54E2E5
	MVP	0E5H, 0E2H	;44E5E2

	PEA	#IMM16		;F400FC
	PEI	#IMM8           ;D412
	PER	#IMM16		;6200FC
ZZZ:
	END
