;******************************************************
;
        CPU     "34010.TBL"     ;PROCESSOR TABLE
        HOF     "BIN16"         ;HEX FORMAT
        WDLN    2               ;WORD LENGTH IS 2 BYTES

; NOTE!!!
; THE TMS34010 USES A BIT ADDRESSING SCHEME, WHERE THE
; LAST FOUR BITS OF AN ADDRESS, POINT TO THE 16 BITS OF
; ITS TWO BYTE WORD.  THIS ASSEMBLER'S LISTING WILL NOT
; SHOW THE LAST NIBBLE OF THE ADDRESS.  HOWEVER, THE
; CORRECT VALUES WILL BE GENERATED FOR ALL JUMPS AND CALLS.
; DIRECT ADDRESSES, SPECIFIED BY @, EXPECT THE USER
; TO SPECIFY THE FINAL NIBBLE OF THE ADDRESS IN THE SOURCE FILE.

; NOTE!!!
; THE FOLLOWING REGISTER VALUES MUST BE SPECIFIED IN
; IN ALL PROGRAMS, FOR 34010.TBL TO WORK PROPERLY.
;
A0:	EQU	$C0000A00
A1:	EQU	$C0000A10
A2:	EQU	$C0000A20
A3:	EQU	$C0000A30
A4:	EQU	$C0000A40
A5:	EQU	$C0000A50
A6:	EQU	$C0000A60
A7:	EQU	$C0000A70
A8:	EQU	$C0000A80
A9:	EQU	$C0000A90
A10:	EQU	$C0000AA0
A11:	EQU	$C0000AB0
A12:	EQU	$C0000AC0
A13:	EQU	$C0000AD0
A14:	EQU	$C0000AE0
A15:	EQU	$C0000AF0

SP:	EQU	$C0001AF0	;SAME AS A15 & B15

B0:	EQU	$C0001B00
B1:	EQU	$C0001B10
B2:	EQU	$C0001B20
B3:	EQU	$C0001B30
B4:	EQU	$C0001B40
B5:	EQU	$C0001B50
B6:	EQU	$C0001B60
B7:	EQU	$C0001B70
B8:	EQU	$C0001B80
B9:	EQU	$C0001B90
B10:	EQU	$C0001BA0
B11:	EQU	$C0001BB0
B12:	EQU	$C0001BC0
B13:	EQU	$C0001BD0
B14:	EQU	$C0001BE0
B15:	EQU	$C0001BF0
;
; NOTE!!!
; OTHER NAMES MAY BE USED FOR THESE REGISTERS BY EQUATING
; THEM TO THE NEW NAMES
; EXAMPLES:
;
SADDR:	EQU	B0      	;SOURCE ADDRESS
SPTCH:	EQU	B1		;SOURCE PITCH
DADDR:	EQU	B2		;DESTINATION ADDRESS
DPTCH:	EQU	B3		;DESTINATION PITCH
OFFSET:	EQU	B4		;OFFSET
WSTART:	EQU	B5		;WINDOW START
WEND:	EQU	B6		;WINDOW END
DYDX:	EQU	B7		;DELTA Y / DELTA X
COLOR0:	EQU	B8		;COLOR 0
COLOR1:	EQU	B9		;COLOR 1

	ABS	SADDR		;0390

; I/O REGISTERS
;
REFCNT:		EQU	$C00001F0	;DRAM REFRESH COUNT
DRYADR:		EQU	$C00001E0	;DISPLAY ADDRESS
VCOUNT:		EQU	$C00001D0	;VERTICAL COUNT
HCOUNT:		EQU	$C00001C0	;HORIZONTAL COUNT
DRYTAP:		EQU	$C00001B0	;DISPLAY TAP POINT
PMASK:		EQU	$C0000160	;PLANE MASK
PSIZE:		EQU	$C0000150	;PIXEL SIZE
CONVDP:		EQU	$C0000140	;CONVERSION (DESTINATION PITCH)
CONVSP:		EQU	$C0000130	;CONVERSION (SOURCE PITCH)
INTPEND:	EQU	$C0000120	;INTERRUPT PENDING
INTENB:		EQU	$C0000110	;INTERRUPT ENABLE
HSTCTLH:	EQU	$C0000100	;HOST CONTROL HIGH (8 MSBs)
HSTCTLL:	EQU	$C00000F0	;HOST CONTROL LOW (8 LSBs)
HSTADRH:	EQU	$C00000E0	;HOST ADDRESS HIGH (16 MSBs)
HSTADRL:	EQU	$C00000D0	;HOST ADDRESS LOW (16 LSBs)
HSTDATA:	EQU	$C00000C0	;HOST DATA
CONTROL:	EQU	$C00000B0	;I/O CONTROL
DPYINT:		EQU	$C00000A0	;DISPLAY INTERRUPT
DPYSTRT:	EQU	$C0000090	;DISPLAY START
DPYCTL:		EQU	$C0000080	;DISPLAY CONTROL
VTOTAL:		EQU	$C0000070	;VERTICAL TOTAL
VSBLNK:		EQU	$C0000060	;VERTICAL START BLANK
VEBLNK:		EQU	$C0000050	;VERTICAL END BLANK
VESYNC:		EQU	$C0000040	;VERTICAL END SYNC
HTOTAL:		EQU	$C0000030	;HORIZONTAL TOTAL
HSBLNK:		EQU	$C0000020	;HORIZONTAL START BLANK
HEBLNK:		EQU	$C0000010	;HORIZONTAL END BLANK
HESYNC:		EQU	$C0000000	;HORIZONTAL END SYNC

;********************************************************************
;
;   THIS IS AN EXAMPLE FOR THE TMS34010 GRAPHICS
; SYSTEM PROCESSOR.  IT IS LOCATED ON PAGE 12-105
; OF THE 1988 TMS34010 USER'S GUIDE AND SHOWS THE
; SETUP AND EXECUTION OF THE LINE INSTRUCTION.
; AFTER ONLY FORMAT MODIFICATIONS, IT IS PASSED ON
; AS AN EXAMPLE, FREE OF CHARGE, BY UNIVERSAL CROSS-ASSEMBLERS.
;
;********************************************************************
; Draw a line from point (xs,ys) to point (xe,ye) using Bresenham's *
; algorithm. When _draw_line is called, xs is in the 16 LSBs of B2, *
; ys is in the 16 MSBs of B2, xe is in the 16 LSBs of B0, and ye is *
; in the 16 MSBs of B0.                                             *
;********************************************************************

_draw_line:
	  SUBXY    B2, B0      ; Calculate a and b

; Now set up B7 = (a,b) and B11 = (dx_diag,dy_diag). Assume that
; a < 0 and b < 0; if a >= 0 or b >= 0, make corrections later.
; Register B11 (INC1) contains dy_diag::dx_diag
; Register B12 (INC2) contains dy_nondiag::dx_nondiag

	  MOVI     -1, B11     ; dx_diag = dy_diag - 1
	  MOVK     1, B12      ; Constant = 1
	  CLR      B7
	  SUBXY    B0, B7      ; B7 = (-a,-b)
	  JRNC     L1          ; Jump if b < 0
; Handle case where b >= 0:
	  MOVY     B0, B7      ; Make a in B7 positive
	  SRL      15, B11     ; Change dy_diag to +1
L1:
	  JRNV     L2          ; Jump if a < 0

; Handle case where a >= 0:
	  MOVX     B0, B7      ; Take absolute value of a
	  MOVX     B12, B11    ; Change dx_diag to +1
L2:
	  MOVX     B11, B12    ; dx_nondiag=dx_diag, dy_nondiag=0

; Compare magnitudes of a and b:
	  MOVE     B7, B0      ; Copy a and b
	  SRL      16, B0      ; Move b into 16 LSBs
	  CMPXY    B0, B7      ; Compare a and b
	  JRNV     L3          ; Jump is a >= b

; Handle case where a < b; must swap a and b so that a >= b:
	  MOVX     B7, B0      ; Copy b into B0
	  RL       16, B7      ; Swap a and b halves of B7
	  CLR      B12
	  MOVY     B11, B12    ; dx_nondiag=0, dy_nondiag=dy_diag

; Calculate initial values of decision variable (d) and
; loop counter:
L3:       ADD      B0, B0      ; B0 = 2 x b
	  MOVX     B7, B10     ; B10 = a
	  SUB      B10, B0     ; B0 = d (2 x b - a)
	  ADDK     1, B10      ; Loop count = a + 1 (in B10)

; Draw line and return to caller:
	  LINE     0           ; Inner loop of line algorithm
	  RETS     0           ; Return to caller

          END
