;--------------------------------------------------------------
;   The 320C5x table provided with Cross-32, is for the
; TMS320C50/51 digital signal processors, as defined in the
; 1991 TMS320C5x User's Guide.

;--------------------------------------------------------------
; NOTE!  The following statements should be placed at the
;	 begining of the first source file.
;
	CPU	"320C5X.TBL"		;PROCESSOR TABLE
	HOF	"INT8"			;HEX OUTPUT FORMAT
	WDLN	2			;2 BYTE WORD LENGTH

;--------------------------------------------------------------
; NOTE!  The 320C5x table only allows the programmer to declare
;	 one or two conditions in the conditional instructions
; (BCND, BCNDD, CC, CCD, RETC, RETCD, and XC).	The assembler
; will only accept valid pairs of conditions.  Should more than
; two conditions be required, they may be hand coded and added
; to the table.  Example:
;
;	XC	  1			;E700
;	XC	  1, EQ 		;E788
;	XC	  1, EQ, LT		;E7CC
;	XC	  1, LT,EQ		;E7CC

;--------------------------------------------------------------
; NOTE!  The following Memory-Mapped Register and I/O Port
;	 should be placed near the start of the first source
;	 file.
;
IMR	EQU	04H		;Interrupt Mask Register
GREG	EQU	05H		;Global Memory Allocation Register
IFR	EQU	06H		;Interrupt Flag Register
PMST	EQU	07H		;Processor Mode Status Register
RPTC	EQU	08H		;Repeat Counter Register
BRCR	EQU	09H		;Block Repeat Counter Register
PASR	EQU	0AH		;Block Repeat Program Address Start Register
PAER	EQU	0BH		;Block Repeat Program Address End Register
TREG0	EQU	0CH		;Temporary Register Used for Multiplicand
TREG1	EQU	0DH		;Temporary Register Used for Dynamic
				;Shift Count (5 bits only)
TREG2	EQU	0EH		;Temporary Register Used as Bit Pointer
				;in Dynamic Bit Test (4 bits only)
DBMR	EQU	0FH		;Dynamic Bit Manipulation Register
AR0	EQU	10H		;Auxiliary Register Zero
AR1	EQU	11H		;Auxiliary Register One
AR2	EQU	12H		;Auxiliary Register Two
AR3	EQU	13H		;Auxiliary Register Three
AR4	EQU	14H		;Auxiliary Register Four
AR5	EQU	15H		;Auxiliary Register Five
AR6	EQU	16H		;Auxiliary Register Six
AR7	EQU	17H		;Auxiliary Register Seven
INDX	EQU	18H		;Index Register
ARCR	EQU	19H		;Auxiliary Register Compare Register
CBSR1	EQU	1AH		;Circular Buffer 1 Start Register
CBER1	EQU	1BH		;Circular Buffer 1 End Register
CBSR2	EQU	1CH		;Circular Buffer 2 Start Register
CBER2	EQU	1DH		;Circular Buffer 2 End Register
CBCR	EQU	1EH		;Circular Buffer Control Register
BMAR	EQU	1FH		;Block Move Address Register
DRR	EQU	20H		;Data Receive Register
DXR	EQU	21H		;Data Transmit Register
SPC	EQU	22H		;Serial Port Control Register
TIM	EQU	24H		;Timer Register
PRD	EQU	25H		;Period Register
TCR	EQU	26H		;Timer Control Register
PDWSR	EQU	28H		;Program/Data S/W Wait-State Register
IOWSR	EQU	29H		;I/O S/W Wait-State Register
CWSR	EQU	2AH		;S/W Wait-State Control Register
TRCV	EQU	30H		;TDM Data Receive Register
TDXR	EQU	31H		;TDM Transmit Data Register
TSPC	EQU	32H		;TDM Serial Port Control Register
TCSR	EQU	33H		;TDM Channel Select Register
TRTA	EQU	34H		;TDM Receive/Transmit Address Register
TRAD	EQU	35H		;TDM Received Address Register
PA0	EQU	50H		;I/O Port 50h
PA1	EQU	51H		;I/O Port 51h
PA2	EQU	52H		;I/O Port 52h
PA3	EQU	53H		;I/O Port 53h
PA4	EQU	54H		;I/O Port 54h
PA5	EQU	55H		;I/O Port 55h
PA6	EQU	56H		;I/O Port 56h
PA7	EQU	57H		;I/O Port 57h
PA8	EQU	58H		;I/O Port 58h
PA9	EQU	59H		;I/O Port 59h
PA10	EQU	5AH		;I/O Port 5Ah
PA11	EQU	5BH		;I/O Port 5Bh
PA12	EQU	5CH		;I/O Port 5Ch
PA13	EQU	5DH		;I/O Port 5Dh
PA14	EQU	5EH		;I/O Port 5Eh
PA15	EQU	5FH		;I/O Port 5Fh

;--------------------------------------------------------------
; NOTE!  The following example is from the TMS320 DSP Designer's
;	 Notebook Number 25, entitled TMS320C2x/'C5x EVM AIC
; Initialization and Configuration.  It shows how to configure
; the TLC32046 Wide-Band Analog Interface Circuit (AIC) included
; on Texas Instrument's Evaluation Modules (EVMs).  It also
; contains vector and C5x initialization, and was contributed
; by Thomas G. Horner, P.E.

AIC_RESET_LO	setl	0ffefh	;Define constants for AIC
AIC_RESET_HI	setl	010h
AIC_SETUP	setl	03h
AIC_CONTROL	setl	0277h

; Primary Transmit Data Word Format
;
;	d12
;	 |d10 d6  d2
;     d14| |d8 |d4 |d0
;      | | | | | | | |
;      v v v v v v v v
;     xxxxxxxxxxxxxx11b 	Signals Secondary Xmit mode
;
;
; Secondary Transmit Data Word Format
;
;				Secondary Command Syntax
;				  (d1/d0 indicate mode)
;	|TA |  |RA |
;     xx10010xx100100b		TA and RA counter setup example
;				 valid range: 4-63
;	|TB | | RB |
;     x100100x10010010b 	TB and RB counter setup example
;				 valid range: 15-127
;
;	    | cntl |
;     xxxxxx1010110111b 	Control word setup example
;	    | ||||||		     (0/1)
;	    | \|||| \__________ d2 = (out/in) A/D highpass filter
;	    |  ||| \___________ d3 = (out/in) loopback function
;	    |  || \____________ d4 = (no/yes) Aux input pins
;	    |  | \_____________ d5 = (no/yes) RX & TX synchronous
;	    |	\______________ d7/d6 = Gain  0/0 = 1
;	    |				      0/1 = 2
;	    |				      1/0 = 4
;	    |				      1/1 = 1
;	    |			d8 = don't care
;	     \_________________ d9 = (out/in) second order sin
;				     x/x filter
;
;-------------------------------------------------------------------
;			MEMORY DEFINITION
;-------------------------------------------------------------------
	ORG	0060H		;Start of On-Chip Data RAM B2
				;Reserve RAM for OPERANDS
AIC_CNTL DFS	1		;AIC control temp memory

;-------------------------------------------------------------------
;			INTERRUPT VECTORS
;-------------------------------------------------------------------
	ORG	0000H		;External Interrupt Vectors
	B	START		;Processor Reset
	B	INT1		;External Interrupt #1
	B	INT2		;External Interrupt #2
	B	INT3		;External Interrupt #3
	B	TINT		;Timer Interrupt
	B	RINT		;Serial Port Receive Interrupt
	B	XINT		;Serial Port Transmit Interrupt
	B	TRINT		;TDM Serial Port Receive Interrupt
	B	TXINT		;TDM Serial Port Transmit Interrupt
	B	INT4		;External Interrupt #4
	DFS	14		;Reserved space - 14 words
	B	TRAP		;S/W Trap
	B	NMI		;Non-maskable external interrupt

;-------------------------------------------------------------------
;			CODE
;-------------------------------------------------------------------
				;Section for program code
	ORG	0030h		;Start of ROM
START
	ldp	#0		;Initialize data pointer
	setc	INTM		;Global interrupt disable
	splk	#0h,IMR 	;Clear interrupt mask register

;-------------	SETUP S/W WAIT-STATE GENERATOR
	splk	#8, CWSR	;Normal wait-state mapping,
				;I/O space=64k
	splk	#0, PDWSR	;Prog/Data space=0 wait-states
	splk	#5555h, IOWSR	;I/O space=1 wait states

;-------------	INITIALIZE SERIAL PORT
	ldp	#0
	splk	#8h, SPC	;DBL=0	(bl): loopback mode
				;disabled
				;FO=0	(b2): 16-bit word
				;operation
				;FSM=1	(b3): fram sync control
				;MCM=0	(b4): external CLKX
				;TXM=0	(b5): external FSX
				;XRST=0 (b6): Xmit RESET
				;RRST=0 (b7): Rec RESET
	opl	#0c0h, SPC	;XRST=1 (b6): Xmit ENABLE
				;RRST=2 (b7): Rec ENABLE

;-------------	INITIALIZE TLC32046 AIC
	ldp	AIC_CNTL
	lacc	#AIC_RESET_LO	;Force AIC RESET low
	sacl	AIC_CNTL
	out	AIC_CNTL, PA2
	rpt	#40		;Keep LO for 2 usec
				;(Spec=800 nsec min)
	nop
	or	#AIC_RESET_HI	;Set AIC RESET high
	sacl	AIC_CNTL
	out	AIC_CNTL, PA2

	ldp	#0
	opl	#020h,IMR	;Enable Xmit interrupt bit
	opl	#0h,IFR 	;Clear pending interrupts
	clrc	INTM		;Global interrupt enable.
	lacl	#0		;Dummy Xmit for
				;synchronization
	sacl	DXR
	lacc	#AIC_SETUP	;Signal secondary Xmit mode
	idle
	lacc	#AIC_CONTROL	;Send control word
	idle

	setc	INTM		;Global interrupt disable.
	lacl	#010h		;Enable serial port RECEIVE
				;interrupts
	sacl	IMR		; REC = IMR b4
	opl	#0h, IFR	;Clear pending interrupts.
	clrc	INTM		;Global interrupt enable.

;-------------	MAIN ROUTINE
MAIN
	idle
	b	MAIN

;--------------------------------------------------------------
;		INTERRUPT SERVICE ROUTINES
;--------------------------------------------------------------
RINT				;SERIAL PORT RECEIVE INTERRUPT
	ldp	#0
	lacc	DRR, 4		;REad latest AIC input w/ 16x
				;gain
	samm	DXR		;Echo to AIC output
	rete			;Return to MAIN w/ interrupt
				;enable
XINT				;SERIAL PORT TRANSMIT
				;INTERRUPT
	samm	DXR
	rete

;-------------	UNUSED INTERRUPT TRAPS
INT1	idle		;External Interrupt #1
INT2	idle		;External Interrupt #2
INT3	idle		;External Interrupt #3
TINT	idle		;Timer Interrupt
;RINT	idle		;Serial Port Receive Interrupt
;XINT	idle		;Serial Port Transmit Interrupt
TRINT	idle		;TDM Serial Port Receive Interrupt
TXINT	idle		;TDM Serial Port Transmit Interrupt
INT4	idle		;External Interrupt #4
TRAP	idle		;S/W Trap
NMI	idle		;Non-maskable external interrupt

	END

