;------------------------------------------------------
;   The 320C2X table provided with Cross-32, is for the
; TMS320C25 digital signal processor, as defined in the
; Second-Generation TMS320 User's Guide.  The table may
; be configured for any specific DSP by the user.
;
       CPU     "320C2X.TBL"     ; CPU TABLE
       HOF     "INT8"           ; HEX OUTPUT FORMAT
       WDLN     2               ; 2 BYTE WORD LENGTH
;
;------------------------------------------------------
;   THIS IS A MATRIX MULTIPLICATION EXAMPLE FOR
; THE TMS32020 DIGITAL SIGNAL PROCESSOR FAMILY.
; IT BEGINS ON 305 OF DIGITAL SIGNAL PROCESSING
; APPLICATIONS WITH THE TMS320 FAMILY FROM
; TEXAS INSTRUMENTS, AND AFTER ONLY FORMAT
; MODIFICATIONS FOR CROSS-32, IT IS PASSED ON
; AS AN EXAMPLE, FREE OF CHARGE, BY UNIVERSAL
; CROSS-ASSEMBLERS.

;***********************************************
;   ALL INPUTS AND OUTPUTS FOR THIS PROGRAM    *
;   SHOULD BE OR ARE IN Q12 FORMAT EXCEPT      *
;   FOR THE M, N, AND P, WHICH SHOULD BE Q0.   *
;***********************************************
       ORG     32
M:     EQU      0
N:     EQU      1
P:     EQU      2
ANS:   EQU      3
BDM1:  EQU      4
ONE:   EQU      5
NM1:   EQU      6
PM1:   EQU      7
AR0:   EQU      0
AR1:   EQU      1
PA0:   EQU      0
;
; INITIALIZATION
;
       LDPK     6
       LRLK     AR1,300H
       LARP     1
       LACK     1
       SACL     ONE
;
; READ SIZES OF MATRICES
;
       RPTK     2
       IN       *+,PA0
;
; MORE INITIALIZATION
;
       LAC      M
       ADD      ONE
       SACL     M
       LAC      N
       SUB      ONE
       SACL     NM1
       LT       N
       MPY      P
       PAC
       SUB      ONE
       SACL     BDM1
       LAC      P
       SUB      ONE
       SACL     PM1
;
; READ IN THE B MATRIX
;
       LRLK     AR1,308H
       RPT      BDM1
       IN       *+,PA0
CALLR: LAC      M
       SUB      ONE
       SACL     M
       BZ       QT
;
; CALL ROUTINE TO READ IN A ROW
; OF THE MATRIX.
;
       CALL     IO
       LRLK     AR1,308H
       LARP     1
       LAR      AR0,PM1
;
; CLEAR ACCUMULATOR AND P REGISTER.
;
MUL:   MPYK     0
       ZAC
;
; MULTIPLY A ROW BY A COLUMN
;
       RPT      NM1
       MAC      0FF00H,*+
       APAC
;
; OUTPUT RESULT
;
       SACH     ANS,4
       OUT      ANS,PA0
       LARP     0
;
; CHECK TO SEE IF ALL COLUMS HAVE BEEN PROCESSED.
;
       BANZ     MUL,*-,1
;
;      GO GET NEXT ROW
;
       B        CALLR
QT:    IDLE
IO:    CNFD
       LARP     1
       LRLK     AR1,200H
       RPT      NM1
       IN       *+,PA0
       CNFP
       RET

