;------------------------------------------------------
;   The TMS320C1X table provided, is for a
; TMS320C10 digital signal processor.  The table may
; be configured for any specific DSP by the user.
;
       CPU     "320C1X.TBL"     ; CPU TABLE
       HOF     "INT8"           ; HEX OUTPUT FORMAT
       WDLN     2               ; 2 BYTE WORD LENGTH
;
;------------------------------------------------------
;   THIS IS AN EXAMPLE FOR THE TMS320 DIGITAL SIGNAL
; PROCESSOR FAMILY.  IT BEGINS ON 187 OF DIGITAL
; SIGNAL PROCESSING APPLICATIONS WITH THE TMS320
; FAMILY FROM TEXAS INSTRUMENTS, AND AFTER ONLY FORMAT
; MODIFICATIONS, IT IS PASSED ON AS AN EXAMPLE,
; FREE OF CHARGE, BY UNIVERSAL CROSS-ASSEMBLERS.

       TITL    "MULAWEXP"
;**
;      'MULAWEXP' PERFORM A MU-LAW EXPANSION, THE
;      8-BIT DATA INPUT IS
;
;      Y + P S2 S1 S0 Q3 Q2 Q1 Q0  WHICH CONSISTS OF
;
;      POLARITY BIT: p
;      3-BIT SEQMENT NUMBER: S = S2 S1 S0
;      4-BIT QUANTIZATION NUMBER: Q = Q3 Q2 Q1 Q0
;
;      THE INPUT Y IS EXPANDED INTO A 14-BIT OUTPUT
;
;      X = P X12 X11 X10 ... X2 X1 X0 CONSISTING OF
;
;      POLARITY BIT:P
;      AND A 13-BIT MAGNITUDE
;                               S
;      (X12...X0) = (33 +2Q) X 2  - 33
;
;      PORT 0 IS USED FOR I/O
;      WORST-CASE TIMING IN CYCLES: 6 INIT / 23 LOOP
;      SPACE REQUIREMENTS IN WORDS: 8 DATA / 46 PROGRAM
;
; CONSTANTS:
;
ONE:   EQU     1       ;= 1
BIT7:  EQU     2       ;= >0080
BIAS:  EQU     3       ;= 33
;
; VARIABLES:
;
Y:     EQU     4       ;MU-LAW COMPRESSED 8-BIT DATA INPUT
X:     EQU     5       ;DECODED (EXPANDED) 14-BIT OUTPUT
P:     EQU     6       ;POLARITY OF DATA (0 FOR POS)
S:     EQU     7       ;3-BIT SEQMENT NUMBER
SUM:   EQU     8       ;VALUE TO BE SHIFTED
;
;      ORG     0
;
INIT:  LACK    1
       SACL    ONE
       LAC     ONE,7
       SACL    BIT7
       LACK    33
       SACL    BIAS
;
; INVERT INPUT
;
START: IN      Y,0
       LACK    00FFH
       XOR     Y
       SACL    Y
;
; SAVE POLARITY AND STRIP TO LOW 7 BITS
       AND     BIT7
       SACL    P       ;0000 FOR POS; 0080 FOR NEG
       LACK    007FH
       AND     Y
       SACL    Y
;
; MAGNITUDE IS CORRECT. STRIP Y OF S AND Q.
       LAC     Y,12    ;SHIFT S INTO HIGH HALF OF ACC
       SACH    S
       LAC     Y,1     ;DOUBLE
       SUB     S,5     ;REMOVE S BITS (STRIP TO 2Q)
       ADD     BIAS
       SACL    SUM     ;SUM = 2Q + BIAS
;
; SHIFT SUM BY S AND REMOVE BIAS
       LACK    SBASE   ;OFFSET FOR SHIFT ROUTINE
       ADD     S,1     ;DOUBLE S (2 WORDS/SHIFT SEGMENT)
       CALA
       SUB     BIAS
;
; ACC = MAGNITUDE, ADD POLARITY TO BIT 13
       ADD     P,6
       SACL    X
       OUT     X,0     ;OUTPUT RESULT TO PORT 0
FIN:   B       FIN
;
;
; LOAD SUM SHIFTED 0:7
SBASE: LAC     SUM,0
       RET
       LAC     SUM,1
       RET
       LAC     SUM,2
       RET
       LAC     SUM,3
       RET
       LAC     SUM,4
       RET
       LAC     SUM,5
       RET
       LAC     SUM,6
       RET
       LAC     SUM,7
       RET
;
       END
