;******************************************************
;
; THE 1802 TABLE CONTAINS THE INSTRUCTIONS USED BY THE
; 1802, 1804, 1805 & 1806 FAMILIES OF MICROPROCESSORS.
; THE EXTRA INSTRUCTIONS FOR THE HIGHER PROCESSORS ARE
; CLEARLY MARKED AT THE END OF THE TABLE, AND MAY BE
; REMOVED BY THE USER.

         CPU     "1802.TBL"       ; CPU TABLE
         HOF     "INT8"           ; HEX OUTPUT FORMAT

; THIS IS AN EXAMPLE FOR THE 1802 MICROPROCESSOR.
; IT IS TAKEN FROM PAGE 175 OF THE NOVEMBER 29, 1984
; ISSUE OF EDN, AND AFTER ONLY FORMAT MODIFICATIONS,
; IT IS PASSED ON AS AN EXAMPLE, FREE OF
; CHARGE, BY UNIVERSAL CROSS-ASSEMBLERS.

;******************************************************
;
; THIS PROGRAM IS AN EXAMPLE SUBROUTINE TO DRIVE A
; VACUUM-FLUORESCENT DISPLAY.

; AUTHOR:  ANTONIO RODRIGUES
;          RCA SOLID STATE DIVISION
;          SOMERVILLE, NJ

VACUUM:  ORG     0200H
         SEX     R7
         SEQ
         REQ                ; SYNC OUT
         LDI     45H
         PLO     R7         ; SET STARTING LOCATION 45H
         LDI     38H
         PLO     RE
LOOP2:   LDI     07
         PLO     RF         ; 7 BITS PER LOCATION
LOOP1:   OUT     01         ; OUTPUT BIT BO
         DEC     R7
         LDN     R7
         SHRC               ; SHIFT RIGHT
         STR     R7
         DEC     RF
         GLO     RF
         BNZ     LOOP1
         LDN     RF
         SHRC
         SHRC               ; TWO ADDITIONAL SHIFTS
         STR     R7         ; RE-STORE
         INC     R7         ; INCREMENT POINTER
         DEC     RE         ; DECREMENT COUNTER
         GLO     RE
         BNZ     LOOP2
         SEP     R5         ; RETURN

         END     VACUUM
