            ;****************************************
            ;*     Example Program For  CP-2051     *
            ;*         Serial port Interface        *
            ;****************************************
            ORG     000H

INIT_SR:    MOV    A,#0FDH                ; Set baud rate 9600
            MOV    TH1,A
            MOV    TL1,A
            MOV    TMOD,#00100000B        ; Timer1 Mode 1
            CLR    ES                     ; Disable serial interupt
            CLR    ET1                    ; Disable timer1 interupt
            SETB   TR1                    ; Set timer1 control
            MOV    SCON,#01010000B        ; Serial mode 1
            ;
LOOP:       MOV     DPTR,#TAB1
            LCALL   TX_BOX
            MOV     DPTR,#TAB2
            LCALL   TX_BOX
            MOV     DPTR,#TAB3
            LCALL   TX_BOX
            MOV     DPTR,#TAB4
            LCALL   TX_BOX
            MOV     DPTR,#TAB5
            LCALL   TX_BOX
            MOV     DPTR,#TAB6
            LCALL   TX_BOX
            MOV     DPTR,#TAB7
            LCALL   TX_BOX
            MOV     DPTR,#TAB8
            LCALL   TX_BOX
            MOV     DPTR,#TAB9
            LCALL   TX_BOX
            MOV     DPTR,#TAB10
            LCALL   TX_BOX
            MOV     DPTR,#TAB11
            LCALL   TX_BOX
            MOV     DPTR,#TAB12
            LCALL   TX_BOX
            MOV     DPTR,#TAB13
            LCALL   TX_BOX
            SJMP    $



TAB1:       DB     'Soft Ware  :  Demo Serial port Transmitter'
            DB     0DH,0AH
TAB2:       DB     'Example    :  abcdefghijklmnopqrstuvwxyz'
            DB     0DH,0AH
TAB3:       DB     '           :  ABCDEFGHIJKLMNOPQRSTUVWXYZ'
            DB     0DH,0AH
TAB4:       DB     '           :  !@#$%^&*()_+|{}<>?'
            DB     0DH,0AH
TAB5:       DB     '           :  1234567890-=\[],./'
            DB     0DH,0AH
TAB6:       DB     'Hard Ware  :  CP-2051 V1.0'
            DB     0DH,0AH
TAB7:       DB     'Product of :  ETT CO.,LTD.'
            DB     0DH,0AH
TAB8:       DB     'Address    :  1108/32 Sukhumvit Rd.'
            DB     0DH,0AH
TAB9:       DB     '           :  Phrakanong Bangkok 10110'
            DB     0DH,0AH
TAB10:      DB     'Tel.       :  391 7215-6'
            DB     0DH,0AH
TAB11:      DB     '           :  712 1120-1'
            DB     0DH,0AH
TAB12:      DB     '           :  712 1123'
            DB     0DH,0AH
TAB13:      DB     'Fax.       :  3917216'
            DB     0DH,0AH

            ;****************************
            ;*    Send data 1 Byte      *
            ;* Input    : ACC           *
            ;* Output   : Serial port   *
            ;****************************
            ;
TX_BYTE:    PUSH   IE
            CLR    ES
            CLR    TI
            MOV    SBUF,A
            JNB    TI,$
            CLR    TI
            POP    IE
            RET

            ;*****************************************
            ;*  Transmit ASCII Until Carrier Return  *
            ;*  Input  : DPTR (ASCII Code Table)     *
            ;*  Output : ASCII Code to Serial Port   *
            ;*         : Stop If Line Feed (0AH)     *
            ;*****************************************
            ;
TX_BOX:     MOV     R0,#0       ; Get ASCII
TX_BOX1:    MOV     A,R0
            MOVC    A,@A+DPTR
            CJNE    A,#0AH,TX_BOX2
            SJMP    TX_BOX3
TX_BOX2:    LCALL   TX_BYTE
            INC     R0
            SJMP    TX_BOX1
TX_BOX3:    LCALL   TX_BYTE
            RET

            ;***********************************
            ;* Send 1 byte BCD to ASCII form   *
            ;*  Input    :  ACC (Binary)       *
            ;*  Output   :  Serial port        *
            ;*  Register :  ACC.,B.            *
            ;*  Sub.Call :  TX_BYTE            *
            ;***********************************
            ;
TX_BCD:     MOV    B,A
            SWAP   A
            ACALL  SBCD
            MOV    A,B
SBCD:       ANL    A,#0FH
            ORL    A,#30H
            LCALL  TX_BYTE
            RET

            ;******************************
            ;*    Send 2 byte of ASCII    *
            ;*  Input : ACC (HEX)         *
            ;*  Example : A = A3H         *
            ;*          : send 41H,33H    *
            ;******************************
            ;
TX_2ASC:    LCALL  HEX_2ASC
            LCALL  TX_BYTE
            MOV    A,B
            LCALL  TX_BYTE
            RET

            ;******************************
            ;*   Convert HEX to ASCII     *
            ;* Input    :  A              *
            ;* Output   :  A (high-byte)  *
            ;*          :  B (low-byte)   *
            ;******************************
            ;
HEX_2ASC:   PUSH   ACC
            LCALL  HEX_TO_ASC
            MOV    B,A              ; B = Lo byte
            POP    ACC
            SWAP   A
            LCALL  HEX_TO_ASC
            RET

            ;********************************
            ;*  Convert hex (0-F) to ASCII  *
            ;*  Input   : ACC (HEX code)    *
            ;*  Output  : ACC (ASCII code)  *
            ;********************************
            ;
HEX_TO_ASC: PUSH   PSW
            CLR    CY
            ANL    A,#00001111B
            CJNE   A,#09H,HTOA1
            SETB   CY
HTOA1:      JNB    CY,HTOA2       ;> 0AH
            ORL    A,#30H         ;< 0AH
            SJMP   END_HTOA
HTOA2:      SUBB   A,#09H         ;> 0AH
            ORL    A,#40H
END_HTOA:   POP    PSW
            RET

            ;*********************************
            ;*  Receive ascii one character  *
            ;*  from Serial port             *
            ;*  Output  : ACC                *
            ;*********************************
            ;
RX_BYTE:    PUSH   IE
            CLR    ES               ; Disable Interupt
            JNB    RI,$             ; Wait data
            CLR    RI
            MOV    A,SBUF
            POP    IE
            RET

            ;************************************
            ;* Function = Receive ASCII 2 bytes *
            ;*            from serial port and  *
            ;*            convert to hex in "A" *
            ;* Output   = Registor ACC          *
            ;************************************
            ;
RX_2ASCII:  PUSH   B
            PUSH   IE
            CLR    ES
            JNB    RI,$             ;Wait data
            CLR    RI
            MOV    A,SBUF
            LCALL  ASC_TO_HEX       ;Convert to hex
            SWAP   A
            MOV    B,A              ;Hi-nibble
            ;** second byte **
            JNB    RI,$             ;Wait for second byte
            CLR    RI
            MOV    A,SBUF
            LCALL  ASC_TO_HEX       ;Convert ot hex
            ORL    A,B              ;Merge
            POP    IE
            POP    B
            RET

            ;**********************************
            ;*  ASC_TO_HEX  = ASCII TO HEX    *
            ;*  Function    = Convert one byte*
            ;*                of ASCII to one *
            ;*                byte in hex.    *
            ;*  Input       = "A" carry ASCII *
            ;*  Output      = "A" = HEX       *
            ;**********************************
            ;
ASC_TO_HEX: PUSH   PSW
            CLR    CY
            CJNE   A,#41H,MORE_A        ; "A"
MORE_A:     JC     AH2
AH1:        ADD    A,#09
AH2:        ANL    A,#00001111B
            POP    PSW
            RET

            ;***********************************
            ;*   Serial Port Service Routine   *
            ;*  USED Register Bank 2           *
            ;*  OVER_RX  : Set if buffer full  *
            ;*           : Set if 0AH Detect   *
            ;*  Input    : R0 (Pointer Buffer) *
            ;*           : R1 (Buffer count)   *
            ;***********************************
            ;
SERL_IN:    CLR     ES                  ; disable serial interupt
            PUSH    PSW                 ; push Reg.
            PUSH    ACC
            PUSH    DPL
            PUSH    DPH
            SETB    RS1                 ; Select Bank #2
            ;
            JBC     RI,STRT_RX          ; RX flag
            CLR     TI                  ; clear TX flag
            SJMP    OUT_SER             ; Ignore if TX Interupt
STRT_RX:    ;JB      OVER_RX,OUT_SER     ; Buffer full not receive
            MOV     A,SBUF              ; Get data from serial port
            MOV     @R0,A               ; Save to buffer (with carry)
            CLR     ACC.7               ; Ignore parity bit
            CJNE    A,#0AH,NEXT_RX      ; Check end of files
            SJMP    RX_READY
NEXT_RX:    MOV     A,R1                ; Buffer counter
            CJNE    A,#50,CHK_RBUF      ; 50 byte buffer check
CHK_RBUF:   JNC     RX_READY            ; Buffer full
            INC     R1                  ; Addvance counter
            INC     R0                  ; Addvance pointer
            SJMP    OUT_SER             ; Data already save
RX_READY:   ;SETB    OVER_RX             ; Buffer full or ready received
            ;
OUT_SER:    POP     DPH                 ; restore Reg.
            POP     DPL
            POP     ACC
            POP     PSW
            SETB    ES                  ; enable serial interupt
OUT_SRI:    RETI                        ; end of serial service

            END



