;****************************
;* Program Test Serial Port *
;* Hardware : CP-2051  V2.0 *
;* Complier : SXA51         *
;****************************

            ORG     0000H
MAIN:       MOV     SP,#128-32          ; Initial Stack 32 Byte
INIT_SER:   MOV     A,#0FDH             ; Set baud rate 9600
            MOV     TH1,A
            MOV     TL1,A
            MOV     TMOD,#00100000B     ; Timer1 Mode 1
            CLR     ES                  ; Disable serial interupt
            CLR     ET1                 ; Disable timer1 interupt
            SETB    TR1                 ; Set timer1 control
            MOV     SCON,#01010000B     ; Serial mode 1
            ;
            LCALL   PRINT_SER
            DB      0CH,'Hardware : CP-2051 V2.0',0DH,0AH
            DB      'ETT CO.,LTD'
            DB      'Press Any Key For Echo Receive Data From Serial Port'
            DB      0DH,0AH,00H
LOOP:       LCALL   RX_BYTE
            LCALL   TX_BYTE
            SJMP    LOOP

;*************************
;* Send 1-Byte to RS-232 *
;* Input   : ACC         *
;* Output  : Serial port *
;*************************
;
TX_BYTE:    PUSH   IE
            CLR    TI
            MOV    SBUF,A
            JNB    TI,$
            CLR    TI
            POP    IE
            RET

;****************************
;* Receive Data From RS-232 *
;* Input   :  Serial Port   *
;* Output  :  ACC           *
;****************************
;
RX_BYTE:    PUSH   IE
            JNB    RI,$             ; Wait data
            CLR    RI
            MOV    A,SBUF
            POP    IE
            RET

;************************************
;*  Print Data data to Serial Port  *
;*  to display buffer.              *
;*  Usage    : LCALL PRINT_SER      *
;*           : DB   'xxxx',00       *
;*  Register : ACC                  *
;*  Note     : last byte must be 00 *
;************************************
;
PRINT_SER:  POP     DPH
            POP     DPL
PRINT1:     CLR     A
            MOVC    A,@A+DPTR
            CJNE    A,#00H,PRINT2
            SJMP    PRINT3
PRINT2:     LCALL   TX_BYTE
            INC     DPTR
            SJMP    PRINT1
PRINT3:     PUSH    DPL
            PUSH    DPH
            RET

            END

