;****************************
;* Program Test DS1820(Temp)*
;* Hardware : CP-2051  V2.0 *
;* Complier : SXA51         *
;****************************

DQ          EQU     P3.2                ; Int0
CRC         EQU     40H
ROMBUF      EQU     CRC+1
MEMBUF      EQU     ROMBUF+8
CR          EQU     0DH
LF          EQU     0AH

            ORG     0000H
MAIN:       MOV     SP,#128-32          ; Initial Stack 32 Byte
INIT_SER:   MOV     A,#0FDH             ; Set baud rate 9600
            MOV     TH1,A
            MOV     TL1,A
            MOV     TMOD,#00100000B     ; Timer1 Mode 1
            CLR     ES                  ; Disable serial interupt
            CLR     ET1                 ; Disable timer1 interupt
            SETB    TR1                 ; Set timer1 control
            MOV     SCON,#01010000B     ; Serial mode 1
            ;
DS1820:     LCALL   touchreset         ;initial device
            jnc     DS1820
            call    readrom            ;read rom to buffer
            mov     a,#44h             ;start conversion
            call    touchbyte          ;send command
            mov     b,#255             ;wait 500 msec
            call    msec               ;
            mov     b,#255             ;
            call    msec               ;
            call    touchreset         ;initial device
            mov     a,#0cch            ;skip rom command
            call    touchbyte          ;send command
            mov     b,#9               ;read 9 byte
            call    read_1820          ;read scratch pad memroy

            mov     r0,#rombuf
            mov     r1,#7
            call    gen_crc
            mov     a,crc
            xrl     a,rombuf+7
            jz      mn5
            call    printstr
            db      'CRC error of ROM contents',07,CR,LF,00

mn5:        call    printstr
            db      '    Content of laser ROM DS1820',CR,LF
            db      '----------------------------------------',CR,LF
            db      '| CRC | 48 bit serial no  | family code|',CR,LF
            db      '----------------------------------------',CR,LF
            db      '|  ',00

            mov     a,rombuf+7         ;show 8 bit crc
            call    send_bcd
            call    printstr
            db      ' | ',00           ;space
            mov     r0,#rombuf+6       ;show 48 bit serial number
            mov     r2,#6
txrom1:     mov     a,@r0
            call    send_bcd
            mov     a,#' '
            call    tx_byte
            dec     r0
            djnz    r2,txrom1

            call    printstr
            db      '|     ',00
            mov     a,rombuf
            call    send_bcd            ;show family code

            call    printstr
            db      '     |',CR,LF
            db      '----------------------------------------',CR,LF,00

            mov     r0,#membuf
            mov     r1,#8
            call    gen_crc
            mov     a,crc
            xrl     a,membuf+8
            jz      showtemp
            call    printstr
            db      'CRC error of scratchpad',07,CR,LF,00

showtemp:   call    printstr
            db      'temp = '
            db      00
            mov     a,membuf            ;show temperture
            clr     cy
            rrc     a
            push    psw
mn1:        mov     dptr,#temp_tab
            movc    a,@a+dptr
            call    send_bcd
            pop     psw
            jnc     mn2
            call    printstr
            db      '.5',00
mn2:        call    printstr
            db      ' c   ',CR,00
            mov     b,#255             ;next temp
            call    msec
            mov     b,#255
            call    msec

mn3:        lcall   touchreset         ;initial device
            mov     a,#0cch
            call    touchbyte
            mov     a,#44h             ;start conversion
            call    touchbyte          ;send command
            mov     b,#255             ;wait 500 msec
            call    msec               ;
            mov     b,#255             ;
            call    msec               ;
            call    touchreset         ;initial device
            mov     a,#0cch            ;skip rom command
            call    touchbyte          ;send command
            mov     b,#9               ;read 9 byte
            call    read_1820          ;read scratch pad memroy
            sjmp    showtemp

;*********************************
;* Send 1 byte BCD to ASCII form *
;*  Input   :  ACC = Binary      *
;*  Output  :  BCD To rs232 ch   *
;*  Register:  ACC.,B.           *
;*********************************
;
SEND_BCD:   CLR     TI
            MOV     B,A
            SWAP    A
            ACALL   SBCD
            MOV     A,B
SBCD:       ANL     A,#0FH
            CJNE    A,#0AH,SBCD2
SBCD2:      JC      SBCD3
            ADD     A,#55
            SJMP    SBCD4
SBCD3:      ORL     A,#30H
SBCD4:      CLR     ES
            MOV     SBUF,A
            JNB     TI,$
            CLR     TI
            SETB    ES
            RET

;**************************************
;*  Generate CRC for consecutive data *
;* Input    : R0=pointed to buffer    *
;*            R1=byte count.          *
;**************************************
;
gen_crc:    mov     crc,#0
chcrc1:     mov     a,@r0
            call    do_crc
            inc     r0
            djnz    r1,chcrc1
            ret

;********************************
;*     CRC check (8 bit CRC)    *
;* Input   : ACC=data to cal.   *
;* Output  : CRC (internal ram) *
;********************************
;
do_crc:     push    acc
            mov     b,#8
crc_loop:   xrl     a,crc
            rrc     a
            mov     a,crc
            jnc     zero
            xrl     a,#18h
zero:       rrc     a
            mov     crc,a
            pop     acc
            rr      a
            push    acc
            djnz    b,crc_loop
            pop     acc
            ret

;*************************************
;*          Read ROM Command         *
;* Function : read 64 bit or lasered *
;*            ROM tom buffer.        *
;*************************************
;
readrom:    call    touchreset
            mov     a,#33h             ; read rom command
            call    touchbyte
            mov     r2,#8              ; 8 byte of ROM
            mov     r0,#rombuf
rdrom2:     mov     r1,#8              ; 8 bit/byte
            clr     a
rdrom1:     clr     dq                 ;start with lo
            mov     b,#8
            djnz    b,$                ;still low unil b=0
            setb    dq                 ;DQ=hi
            nop                       ; 2 nop
            nop
            nop
            mov     c,dq               ;read data bit
            rrc     a                  ;store in ACC
            mov     b,#100
rdrom4:     mov     c,dq
            jc      rdrom3
            djnz    b,rdrom4
rdrom3:     nop
            nop
            nop
            djnz    r1,rdrom1          ;next bit
            mov     @r0,a              ;save byte in buffer
            inc     r0                 ;advance pointer
            djnz    r2,rdrom2          ;next address
            ret

;*********************************
;*     Read scratchpad memory    *
;* Input    : B = amount of mem  *
;*            etc.B=4,read 4 byte*
;*            from address 0.    *
;*            memory.            *
;*********************************
;
READ_1820:  MOV     A,#0BEH            ; read scratchpad command
            CALL    TOUCHBYTE          ; send commnad
RD_SCRAT:   MOV     R2,B               ; prepare buffer
            MOV     R0,#MEMBUF
RDSCT2:     MOV     R1,#8
            CLR     A
RDSCT1:     CLR     DQ                 ;start
            MOV     B,#8
            DJNZ    B,$                ;still low
            SETB    DQ                 ;DQ=hi
            NOP
            NOP
            MOV     C,DQ               ;read data bit
            RRC     A                  ;store in ACC
            MOV     B,#100
RDSCT4:     MOV     C,DQ
            JC      RDSCT3
            DJNZ    B,RDSCT4
RDSCT3:     NOP
            NOP
            NOP
            DJNZ    R1,RDSCT1          ;next bit
            MOV     @R0,A              ;save byte in buffer
            INC     R0                 ;advance pointer
            DJNZ    R2,RDSCT2          ;next address
            CALL    TOUCHRESET
            RET

;*********************************
;* DS1820 Reset & Precence pulse *
;* Output   : Carry flag set if  *
;*           found precence pulse*
;*********************************
;
TOUCHRESET: PUSH    B
            PUSH    ACC
            MOV     A,#4
            CLR     DQ
            MOV     B,#221
            DJNZ    B,$
            SETB    DQ
            MOV     B,#6
            CLR     C
WAITLOW:    JB      DQ,WH
            DJNZ    B,WAITLOW
            DJNZ    ACC,WAITLOW
            SJMP    SHORT
WH:         MOV     B,#111
HL:         ORL     C,/DQ
            DJNZ    B,HL
SHORT:      POP     ACC
            POP     B
            RET

;*******************************
;* Write Byte in ACC to DS1820 *
;*******************************
;
TOUCHBYTE:  PUSH    B
            MOV     B,#8
BIT_LOOP:   RRC     A
            ACALL   TOUCHBIT
            DJNZ    B,BIT_LOOP
            RRC     A
            POP     B
            RET
TOUCHBIT:   CLR     DQ
            NOP
            NOP
            NOP
            NOP
            MOV     DQ,C
            NOP
            NOP
            NOP
            NOP
            NOP
            NOP
            MOV     C,DQ
            PUSH    B
            MOV     B,#12
            DJNZ    B,$
            POP     B
            SETB    DQ
            RET


TEMP_TAB:   DB      00H,01H,02H,03H,04H
            DB      05H,06H,07H,08H,09H
            DB      10H,11H,12H,13H,14H
            DB      15H,16H,17H,18H,19H
            DB      20H,21H,22H,23H,24H
            DB      25H,26H,27H,28H,29H
            DB      30H,31H,32H,33H,34H
            DB      35H,36H,37H,38H,39H
            DB      40H,41H,42H,43H,44H
            DB      45H,46H,47H,48H,49H
            DB      50H,51H,52H,53H,54H
            DB      55H,56H,57H,58H,59H
            DB      60H,61H,62H,63H,64H
            DB      65H,66H,67H,68H,69H
            DB      70H,71H,72H,73H,74H
            DB      75H,76H,77H,78H,79H
            DB      80H,81H,82H,83H,84H
            DB      85H,86H,87H,88H,89H
            DB      90H,91H,92H,93H,94H
            DB      95H,96H,97H,98H,99H

;*****************************************
;* PRINTSTR = SEND STRING                *
;* FUNTION  = Send string at memory -    *
;*            location  after instruction*
;*            lcall PRINT  instruction   *
;*            end of string must be 00   *
;*****************************************
;
;Note that the end of string table must be 00
;NOTE : when used this sub routine must not enable ES
;
PRINTSTR:   POP     DPH       ; Get Pointer(stack)
            POP     DPL
            PUSH    IE
            PUSH    ACC
            CLR     ES
STSD0:      CLR     A
            MOVC    A,@A+DPTR
            JZ      STSD2
STSD1:      CLR     TI
            MOV     SBUF,A
            JNB     TI,$                ;Wait to send
            CLR     TI
            INC     DPTR
            SJMP    STSD0
STSD2:      POP     ACC
            POP     IE
            INC     DPTR
            PUSH    DPL
            PUSH    DPH
            RET

;**************************************
;* RX_BYTE  = Receive byte            *
;* FUNCTION : Receive 1 byte from     *
;*            serial port.            *
;* Output   : Register ACC.           *
;**************************************
;
RX_BYTE:    PUSH    IE
            CLR     ES
            CLR     RI
            JNB     RI,$
RX_BT1:     MOV     A,SBUF
            CLR     RI
            POP     ES
            RET

;**************************************
;* TX_BYTE  = 1 BYTE SEND             *
;* FUNCTION = Send data in A to serial*
;*            port.                   *
;* INPUT    = Data in A to transmit   *
;* OUTPUT   = Serial port             *
;**************************************
;
TX_BYTE:    PUSH    IE
            CLR     ES
            CLR     TI
            MOV     SBUF,A
            JNB     TI,$
            CLR     TI
            POP     IE
            RET

MSEC:       MOV     DPTR,#65536-152
MD1:        INC     DPTR
            MOV     A,DPH
            ORL     A,DPL
            JNZ     MD1
            NOP
            DJNZ    B,MSEC
            RET
            end

