            ;****************************************
            ;*     Example Program For  CP-2051     *
            ;*          4bit LCD Interface          *
            ;****************************************

            RS_LCD      EQU     P3.4        ; RS LCD (Pin T0)
            CS_LCD      EQU     P3.5        ; E  LCD (PIN T1)
            DSP_BUFF    EQU     22H         ; Display buffer 16 byte

            ORG     0000H
            ;
MAIN:       LCALL   INIT_LCD
            MOV     R3,#0           ; Pointer show
LOOP:       LCALL   DSP_LEFT        ; left display
            LCALL   WR_DSP          ; display data to LCD
            INC     R3              ; Shift pointer
            LJMP    LOOP

            ;*******************************
            ;* Fill data to Display buffer *
            ;* for show display Left style *
            ;*******************************
            ;
DSP_LEFT:   MOV     R2,#16          ; counter display buffer
            MOV     A,R3
            MOV     R0,A            ; pointer data in buffer
            MOV     R1,#DSP_BUFF
            MOV     DPTR,#TAB_LCD
DSP_LFT1:   MOV     A,R0
            MOVC    A,@A+DPTR       ; get data
            MOV     @R1,A           ; Fill data to buffer
            INC     R0
            INC     R1
            DJNZ    R2,DSP_LFT1
            RET

            ;*********************
            ;* Write data to LCD *
            ;* Reg. : R0,R2,ACC  *
            ;*********************
            ;
WR_DSP:     MOV     R0,#DSP_BUFF    ; display buffer
            MOV     A,#00H          ; goto line 1
            LCALL   GOTO_LCD
            MOV     R2,#8
WR_DSP1:    MOV     A,@R0
            LCALL   WR_LCD
            INC     R0
            DJNZ    R2,WR_DSP1
            ;
            MOV     R2,#8
            MOV     A,#40H          ; goto line 2
            LCALL   GOTO_LCD
WR_DSP2:    MOV     A,@R0
            LCALL   WR_LCD
            INC     R0
            DJNZ    R2,WR_DSP2
            LCALL   DELAY
            RET

TAB_LCD:    DB      '                '
            DB      ' Example Program for LCD 4bit Interface with CP-2051'
            DB      ' By ETT CO.,LTD. 1108/32 Sukhumvit Rd. Phrakanong'
            DB      ' Bangkok 10110  Tel. 3917215-6 7121120-1 7121123'
            DB      ' Fax. 3917216  CPU AT89C2051 is Micro Controller'
            DB      ' Compatible with MCS-51 family Thank You !!'

            ;**************************
            ;*   Write ASCII to LCD   *
            ;* Input  : ACC  (ASCII)  *
            ;* Output : Data bus LCD  *
            ;**************************
            ;
WR_LCD:     SETB    RS_LCD          ; Write Data select
            MOV     B,A
            ANL     A,#0F0H
            MOV     P1,A            ; High byte
            LCALL   EN_LCD
            MOV     A,B             ; Low byte
            SWAP    A
            ANL     A,#0F0H
            MOV     P1,A
            LCALL   EN_LCD
            RET

            ;**************************
            ;* Write Instruction LCD  *
            ;* Input  : ACC (Command) *
            ;* Output : Data bus LCD  *
            ;**************************
            ;
WR_INS:     CLR     RS_LCD          ; Instruction select
            MOV     B,A
            ANL     A,#0F0H
            MOV     P1,A            ; High byte
            LCALL   EN_LCD
            MOV     A,B             ; Low byte
            SWAP    A
            ANL     A,#0F0H
            MOV     P1,A
            LCALL   EN_LCD
            RET

            ;************************
            ;* Goto position of LCD *
            ;* Input : ACC (addr.)  *
            ;************************
            ;
GOTO_LCD:   SETB    ACC.7
            LCALL   WR_INS
            RET

            ;**********************
            ;*   Mov LCD cursor   *
            ;* to Left 1 position *
            ;**********************
            ;
SHF_LFT:    MOV     A,#10H
            LCALL   WR_INS
            RET

            ;***********************
            ;*    Mov LCD cursor   *
            ;* to Right 1 position *
            ;***********************
            ;
SHF_RGT:    MOV     A,#14H
            LCALL   WR_INS
            RET

            ;*******************
            ;*   Initial LCD   *
            ;* 4-Bit Interface *
            ;*******************
            ;
INIT_LCD:   CLR     RS_LCD
            MOV     A,#33H          ; Set DL=1 3-time
            LCALL   WR_INS
            MOV     A,#32H          ; Clear DL=0 1-time
            LCALL   WR_INS
            MOV     A,#28H          ; Function set
            LCALL   WR_INS          ; DL=0 4Bit,N=1 2Line,F=0 5X7
            MOV     A,#0CH          ; Display on/off Control
            LCALL   WR_INS          ; Entry display,cursor off,cursor not blink
            MOV     A,#06H          ; Entry mode set
            LCALL   WR_INS          ; I/D=1 Increment,S=0 cursor shift
            MOV     A,#01H          ; Clear display
            LCALL   WR_INS          ; clear display,set DD RAM address=0
            RET

            ;**********************
            ;*  Enable Pin E LCD  *
            ;* Active Chip select *
            ;**********************
            ;
EN_LCD:     CLR     CS_LCD          ; Enable LCD
            LCALL   BUSY            ; Busy delay time
            SETB    CS_LCD          ; Disable LCD
            RET

            ;***********************
            ;* Delay time for Busy *
            ;*    Wait LCD Ready   *
            ;***********************
            ;
BUSY:       MOV     R7,#0FFH
            DJNZ    R7,$
            RET

            ;**************
            ;* Delay Time *
            ;**************
            ;
DELAY:      MOV     R5,#2
DEL1:       MOV     R6,#0FFH
DEL2:       MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,DEL2
            DJNZ    R5,DEL1
            RET

            END

